;----------------------------------------------------------------------------
;
;  CosmoX KEYBOARD Handling Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

.DATA

ALIGN 2

KeyBuffer           DB  128 dup (0)     ;  Key Status
OldInt9Address      DD  ?               ;  BIOS IRQ keyboard handler address
KeyActive           DB  0               ;  It's the keyboard handler active?

KeyMap      DB 01Bh,031h,032h,033h,034h,035h,036h,037h,038h,039h,030h,02Dh,03Dh,008h,008h,071h,077h,065h,072h,074h,079h,075h,069h,06Fh,070h,05Bh,05Dh,00Dh,000h,061h,073h,064h
            DB 066h,067h,068h,06Ah,06Bh,06Ch,03Bh,027h,060h,000h,05Ch,07Ah,078h,063h,076h,062h,06Eh,06Dh,02Ch,02Eh,02Fh,000h,02Ah,000h,020h,000h,000h,000h,000h,000h,000h,000h
            DB 000h,000h,000h,000h,000h,000h,037h,038h,039h,02Dh,034h,035h,036h,02Bh,031h,032h,033h,030h,02Eh,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
            DB 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
            DB 01Bh,021h,040h,023h,024h,025h,05Eh,026h,02Ah,028h,029h,05Fh,03Dh,008h,008h,051h,057h,045h,052h,054h,059h,055h,049h,04Fh,050h,07Bh,07Dh,00Dh,000h,041h,053h,044h
            DB 046h,047h,048h,04Ah,04Bh,04Ch,03Ah,063h,07Eh,000h,07Ch,05Ah,058h,043h,056h,042h,04Eh,04Dh,03Ch,03Eh,03Fh,000h,000h,000h,020h,000h,000h,000h,000h,000h,000h,000h
            DB 000h,000h,000h,000h,000h,000h,000h,000h,000h,02Dh,000h,035h,000h,02Bh,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
            DB 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h

.CODE

PUBLIC  CSInstallKeyBoard, CSKey, CSRemoveKeyboard, CSWaitKey, CSReadKey
PUBLIC  CSLockKeys, CSAsc, CSCheckKeys

CSInstallKeyBoard PROC
  MOV DL, KeyActive
  OR  DL, DL
  JNZ EndKeyInstall
  XOR DX, DX
  MOV ES, DX
  CLI
  MOV EAX, ES:[24h]
  MOV OldInt9Address, EAX
  MOV AX, OFFSET KeyBoardHandler
  MOV DX, SEG KeyBoardHandler
  MOV ES:[24h], AX
  MOV ES:[26h], DX
  STI
  MOV KeyActive, 1
EndKeyInstall:
  RET
KeyBoardHandler:
  PUSH AX
  PUSH CX
  PUSH DS
  PUSH SI
  MOV CL, 1
  IN  AL, 60h
  TEST AL, 80h
  JZ  StoreKey
  AND AL, 7Fh
  XOR CL, CL
StoreKey:
  XOR AH, AH
  MOV SI, AX
  MOV AX, @DATA
  MOV DS, AX
  MOV KeyBuffer[SI], CL
  IN  AL, 61h
  OR  AL, 80h
  OUT 61h, AL
  MOV AL, 20h
  OUT 20h, AL
  POP SI
  POP DS
  POP CX
  POP AX
  IRET
CSInstallKeyBoard ENDP

CSRemoveKeyBoard PROC
  MOV DL, KeyActive
  OR  DL, DL
  JZ  AlreadyRemoved
  XOR DX, DX
  MOV ES, DX
  CLI
  MOV EAX, OldInt9Address
  MOV ES:[24h], EAX
  STI
  XOR SI, SI
  XOR AX, AX
EmptyKeyBuffer:
  MOV KeyBuffer[SI], AL
  INC SI
  CMP SI, 128
  JL  EmptyKeyBuffer
  MOV KeyActive, AL
AlreadyRemoved:
  RET
CSRemoveKeyboard ENDP

CSKey PROC
  MOV BX, BP
  MOV BP, SP
  MOV DL, KeyActive
  OR  DL, DL
  JZ  NoKeyBoard
  XOR AH, AH
  MOV SI, [BP+04]
  CMP KeyBuffer[SI], 1
  JNZ NoKey
  MOV AX, 1
  MOV BP, BX
  RET 2
NoKey:
  XOR AX, AX
  MOV BP, BX
  RET 2
NoKeyBoard:
  MOV AX, 0FFFFh
  MOV BP, BX
  RET 2
CSKey ENDP

CSWaitKey PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, 0FFFFh
  MOV DL, KeyActive
  OR  DL, DL
  JZ  NoWait
  MOV SI, [BP+04]
  CMP SI, 0FFFFh
  JE  WaitAnyKey
WaitKey:
  CMP KeyBuffer[SI], 1
  JE  KeyFound
  JMP WaitKey
WaitAnyKey:
  XOR SI, SI
WaitAnyKeyLoop:
  CMP KeyBuffer[SI], 1
  JE  KeyFound
  INC SI
  CMP SI, 129
  JNZ WaitAnyKeyLoop
  JMP WaitAnyKey
KeyFound:
  CMP KeyBuffer[SI], 1
  JE  KeyFound
NoWait:
  MOV BP, BX
  RET 2
CSWaitKey ENDP

CSReadKey PROC
  MOV AX, 0FFFFh
  MOV DL, KeyActive
  OR  DL, DL
  JZ  NoKeyRead
ReadKey:
  XOR SI, SI
ReadKeyLoop:
  CMP KeyBuffer[SI], 1
  JE  ReadKeyFound
  INC SI
  CMP SI, 129
  JNZ ReadKeyLoop
  JMP ReadKey
ReadKeyFound:
  CMP KeyBuffer[SI], 1
  JE  ReadKeyFound
  MOV AX, SI
NoKeyRead:
  RET
CSReadKey ENDP

CSCheckKeys PROC
  MOV AX, 0FFFFh
  MOV DL, KeyActive
  OR  DL, DL
  JZ  NoKeyCheck
  XOR SI, SI
CheckKeyLoop:
  CMP KeyBuffer[SI], 1
  JE  CheckKeyFound
  INC SI
  CMP SI, 129
  JNZ CheckKeyLoop
  XOR AX, AX
  JMP NoKeyCheck
CheckKeyFound:
  CMP KeyBuffer[SI], 1
  JE  CheckKeyFound
  MOV AX, SI
NoKeyCheck:
  RET
CSCheckKeys ENDP

CSLockKeys PROC
  PUSH BP
  MOV BP, SP
  MOV AX, 0040h
  MOV ES, AX
  MOV DI, 0017h
  MOV AL, [BP+08]
  CMP AL, 2
  JE  ScrollKey
  CMP AL, 1
  JE  CapsKey
  MOV AL, [BP+06]
  AND AL, 01h
  CMP AL, 0
  JE  TurnOffNum
  MOV AL, 20h
  OR  ES:[DI], AL
  JMP EndLockKeys
TurnOffNum:
  MOV AL, 20h
  XOR AL, 0FFh
  AND ES:[DI], AL
  JMP EndLockKeys
CapsKey:
  MOV AL, [BP+06]
  AND AL, 01h
  CMP AL, 0
  JE  TurnOffCaps
  MOV AL, 40h
  OR  ES:[DI], AL
  JMP EndLockKeys
TurnOffCaps:
  MOV AL, 40h
  XOR AL, 0FFh
  AND ES:[DI], AL
  JMP EndLockKeys
ScrollKey:
  MOV AL, [BP+06]
  AND AL, 01h
  CMP AL, 0
  JE  TurnOffScroll
  MOV AL, 10h
  OR  ES:[DI], AL
  JMP EndLockKeys
TurnOffScroll:
  MOV AL, 10h
  XOR AL, 0FFh
  AND ES:[DI], AL
EndLockKeys:
  POP BP
  RET 4
CSLockKeys ENDP

CSAsc PROC
  PUSH BP
  MOV BP, SP
  XOR SI, SI
  MOV BX, [BP+08]
  MOV AX, [BP+06]
  AND AX, 1
  OR  AX, AX
  JZ  NotShift
  MOV SI, 128
NotShift:
  XOR AH, AH
  DEC BX
  ADD SI, BX
  MOV AL, KeyMap[SI]
  POP BP
  RET 4
CSAsc ENDP

END
