;----------------------------------------------------------------------------
;
;  CosmoX IMAGE Handling Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

PCXheaderType STRUC
  Man         DB  ?
  Ver         DB  ?
  Encoding    DB  ?
  PCXBPP      DB  ?
  XMin        DW  ?
  YMin        DW  ?
  PCXXSize    DW  ?
  PCXYSize    DW  ?
  Hdpi        DW  ?
  Vdpi        DW  ?
  Colormap    DB  48 dup(?)
  Unused      DB  64 dup(?)
PCXheaderType ENDS

BMPHeaderType STRUC
  BMPID           DW  ?
  FileSize        DD  ?
  Reserved1       DW  ?
  Reserved2       DW  ?
  OffBits         DD  ?
  HSize           DD  ?
  BMPXSize        DD  ?
  BMPYSize        DD  ?
  Planes          DW  ?
  BMPBPP          DW  ?
  Compression     DD  ?
  SizeImage       DD  ?
  XPelsPerMeter   DD  ?
  YPelsPerMeter   DD  ?
  ClrUsed         DD  ?
  ClrImportant    DD  ?
BMPHeaderType ENDS

.DATA

ALIGN 2

BMPHeader           BMPHeaderType <>
PCXHeader           PCXHeaderType <>
Buffer              DB  ?

.CODE

PUBLIC xCSLoadPCX, xCSLoadBMP, xCSSaveBMP

xCSLoadPCX PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV ES, [BP+20]
  MOV AX, [BP+16]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+18]
  MOV DS, [BP+10]
  MOV DX, [BP+08]
  XOR AX, AX
  MOV AH, 3Dh
  INT 21h
  JC  ErrorOpenPCX
  MOV BX, AX
  MOV AX, SEG PCXHeader
  MOV DS, AX
  MOV DX, OFFSET PCXHeader
  MOV CX, SIZE PCXHeader
  MOV AH, 3Fh
  INT 21h
  JC  ErrorReadingPCX
  CMP PCXHeader.Ver, 5
  JNE ErrorBadPCX
  CMP PCXHeader.Encoding, 1
  JNE ErrorBadPCX
  CMP PCXHeader.PCXBPP, 8
  JNE ErrorBadPCX
  MOV AX, PCXHeader.Xmin
  DEC AX
  SUB PCXheader.PCXxSize, AX
  MOV AX, PCXHeader.Ymin
  DEC AX
  SUB PCXHeader.PCXySize, AX
  XOR DX, DX
  XOR AX, AX
  MOV SI, PCXHeader.PCXySize
  TEST PCXHeader.PCXxSize, 1
  JZ  PCXLoadLoop
  INC PCXHeader.PCXxSize
PCXLoadLoop:
  CALL ReadBuffer
  JC  ErrorReadingPCX
  MOV AL, Buffer
  MOV CL, AL
  AND AL, 0C0h
  CMP AL, 0C0h
  MOV AL, CL
  JZ  DecodePCXRle
  MOV ES:[DI], AL
  INC DI
  INC DX
  CMP DX, PCXHeader.PCXxSize
  JL  PCXNextData
  ADD DI, 320
  SUB DI, DX
  XOR DX, DX
  DEC SI
  JMP PCXNextData
DecodePCXRle:
  AND AL, 3Fh
  MOV CL, AL
  CALL ReadBuffer
  JC  ErrorReadingPCX
  MOV AL, Buffer
DecodePCXRleLoop:
  MOV ES:[DI], AL
  INC DI
  INC DX
  CMP DX, PCXheader.PCXxSize
  JL  DecodePCX
  ADD DI, 320
  SUB DI, DX
  XOR DX, DX
  DEC SI
DecodePCX:
  DEC CL
  JNZ DecodePCXRleLoop
PCXNextData:
  OR  SI, SI
  JNZ PCXLoadLoop
  CALL ReadBuffer
  JC  ErrorReadingPCX
  MOV ES, [BP+14]
  MOV DI, [BP+12]
  MOV CX, 768
LoadPCXPal:
  CALL ReadBuffer
  JC  ErrorReadingPCX
  MOV AL, Buffer
  SHR AL, 2
  STOSB
  DEC CX
  JNZ LoadPCXPal
  MOV AH, 3Eh
  INT 21h
  XOR AX, AX
  JMP EndLoadPCX
ErrorOpenPCX:
  MOV AX, 1
  JMP EndLoadPCX
ErrorReadingPCX:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 2
  JMP EndLoadPCX
ErrorBadPCX:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 3
EndLoadPCX:
  POP DS
  POP BP
  RET 14
xCSLoadPCX ENDP

xCSLoadBMP PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV ES, [BP+20]
  MOV AX, [BP+16]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+18]
  MOV DS, [BP+10]
  MOV DX, [BP+08]
  XOR AX, AX
  MOV AH, 3Dh
  INT 21h
  JC  ErrorOpenBMP
  MOV BX, AX
  MOV AX, SEG BMPHeader
  MOV DS, AX
  MOV DX, OFFSET BMPHeader
  MOV CX, SIZE BMPHeader
  MOV AH, 3Fh
  INT 21h
  JC  ErrorReadingBMP
  CMP BMPHeader.BMPID, 19778
  JNE ErrorBadBMP
  CMP BMPHeader.Planes, 1
  JNE ErrorBadBMP
  CMP BMPHeader.BMPBPP, 8
  JNE ErrorBadBMP
  CMP BMPHeader.Compression, 0
  JNE ErrorBadBMP
  MOV GS, [BP+14]
  MOV SI, [BP+12]
  MOV CX, 256
LoadBMPPal:
  CALL ReadBuffer
  JC  ErrorReadingBMP
  MOV AL, Buffer
  SHR AL, 2
  MOV GS:[SI+2], AL
  CALL ReadBuffer
  JC  ErrorReadingBMP
  MOV AL, Buffer
  SHR AL, 2
  MOV GS:[SI+1], AL
  CALL ReadBuffer
  JC  ErrorReadingBMP
  MOV AL, Buffer
  SHR AL, 2
  MOV GS:[SI], AL
  CALL ReadBuffer
  JC  ErrorReadingBMP
  ADD SI, 3
  DEC CX
  JNZ LoadBMPPal
  MOV EAX, BMPHeader.BMPYSize
  DEC AX
  MOV DX, AX
  SHL DX, 8
  SHL AX, 6
  ADD AX, DX
  ADD DI, AX
  MOV ECX, BMPHeader.BMPYSize
LoadBMPLoop:
  PUSH CX
  PUSH DS
  MOV ECX, BMPheader.BMPXSize
  MOV AX, ES
  MOV DS, AX
  MOV AH, 03Fh
  MOV DX, DI
  INT 21h
  POP DS
  POP CX
  JC ErrorReadingBMP
  SUB DI, 320
  DEC CX
  JNZ LoadBMPLoop
  MOV AH, 3Eh
  INT 21h
  XOR AX, AX
  JMP EndLoadBMP
ErrorOpenBMP:
  MOV AX, 1
  JMP EndLoadBMP
ErrorReadingBMP:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 2
  JMP EndLoadBMP
ErrorBadBMP:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 3
EndLoadBMP:
  POP DS
  POP BP
  RET 14
xCSLoadBMP ENDP

xCSSaveBMP PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV ES, [BP+24]
  MOV DS, [BP+10]
  MOV DX, [BP+08]
  XOR AX, AX
  MOV CX, 20h
  MOV AH, 3Ch
  INT 21h
  JC  ErrorCreateBMP
  MOV BX, AX
  MOV BMPHeader.BMPID, 19778
  XOR EAX, EAX
  XOR ECX, ECX
  MOV AX, [BP+18]
  SUB AX, [BP+22]
  INC AX
  MOV BMPHeader.BMPXSize, EAX
  MOV CX, [BP+16]
  SUB CX, [BP+20]
  INC CX
  MOV BMPHeader.BMPYSize, ECX
  MUL CX
  MOV BMPHeader.SizeImage, EAX
  ADD AX, 1078
  MOV BMPHeader.FileSize, EAX
  XOR EAX, EAX
  MOV BMPHeader.Reserved1, AX
  MOV BMPHeader.Reserved2, AX
  MOV BMPHeader.OffBits, 1078
  MOV BMPHeader.HSize, 40
  MOV BMPHeader.Planes, 1
  MOV BMPHeader.BMPBPP, 8
  MOV BMPHeader.Compression, EAX
  MOV BMPHeader.XPelsPerMeter, 3790
  MOV BMPHeader.YPelsPerMeter, 3780
  MOV BMPHeader.ClrUsed, EAX
  MOV BMPHeader.ClrImportant, EAX
  MOV AX, SEG BMPHeader
  MOV DS, AX
  MOV DX, OFFSET BMPHeader
  MOV CX, SIZE BMPHeader
  MOV AH, 40h
  INT 21h
  JC  ErrorWritingBMP
  MOV GS, [BP+14]
  MOV SI, [BP+12]
  MOV CX, 256
SaveBMPPal:
  MOV AL, GS:[SI+2]
  SHL AL, 2
  MOV Buffer, AL
  CALL WriteBuffer
  JC  ErrorWritingBMP
  MOV AL, GS:[SI+1]
  SHL AL, 2
  MOV Buffer, AL
  CALL WriteBuffer
  JC  ErrorWritingBMP
  MOV AL, GS:[SI]
  SHL AL, 2
  MOV Buffer, AL
  CALL WriteBuffer
  JC  ErrorWritingBMP
  MOV Buffer, 0
  CALL WriteBuffer
  JC  ErrorWritingBMP
  ADD SI, 3
  DEC CX
  JNZ SaveBMPPal
  MOV ECX, BMPHeader.BMPYSize
SaveBMPloop:
  MOV DX, CX
  ADD DX, [BP+20]
  DEC DX
  MOV SI, DX
  SHL DX, 8
  SHL SI, 6
  ADD DX, SI
  ADD DX, [BP+22]
  PUSH CX
  PUSH DS
  MOV ECX, BMPHeader.BMPXSize
  MOV AX, ES
  MOV DS, AX
  MOV AH, 40h
  INT 21h
  POP DS
  POP CX
  JC  ErrorWritingBMP
  DEC CX
  JNZ SaveBMPloop
  XOR AX, AX
  JMP EndSaveBMP
ErrorCreateBMP:
  MOV AX, 1
  JMP EndSaveBMP
ErrorWritingBMP:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 2
EndSaveBMP:
  POP DS
  POP BP
  RET 18
xCSSaveBMP ENDP

ReadBuffer PROC
  PUSH DS
  PUSH AX
  PUSH CX
  PUSH DX
  MOV DX, OFFSET Buffer
  MOV AX, @DATA
  MOV DS, AX
  MOV CX, 1
  MOV AH, 3Fh
  INT 21h
  POP DX
  POP CX
  POP AX
  POP DS
  RET
ReadBuffer ENDP

WriteBuffer PROC
  PUSH DS
  PUSH AX
  PUSH CX
  PUSH DX
  MOV DX, OFFSET Buffer
  MOV AX, @DATA
  MOV DS, AX
  MOV CX, 1
  MOV AH, 40h
  INT 21h
  POP DX
  POP CX
  POP AX
  POP DS
  RET
WriteBuffer ENDP

END
