;----------------------------------------------------------------------------
;
;  CosmoX FONT Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

EXTRN BMapActive      :  BYTE
EXTRN BMapSeg         :  WORD
EXTRN ClipX1          :  WORD
EXTRN ClipX2          :  WORD
EXTRN ClipY1          :  WORD
EXTRN ClipY2          :  WORD

CosmoXFontFile STRUC
    FontFileTitle     DB  'CosmoX Font File    '
    LibVersion        DB  'CosmoX Library v1.6 '
CosmoXFontFile ENDS

.DATA

ALIGN 2

TextX               DW  ?               ;  Current text X
TextY               DW  ?               ;  Current text Y
TexturePos          DW  0               ;  Current position within TextTexture
FontHeader          CosmoXFontFile <>
FontID              DB  'CosmoX Font File    '
TextSpacing         DB  8               ;  Character spacing in pixels
TextTexture         DB  64 dup (15)     ;  Text texture for PrintTextured
INCLUDE FONT.INC                        ;  Font Data

.CODE

PUBLIC  xCSLoadFont, xCSPrint, xCSPrintSolid, xCSPrintTextured
PUBLIC  xCSPrintBlended, xCSPrintReversed, CSTextTexture, CSGetTextSpacing
PUBLIC  CSSetTextSpacing, CSResetFont, xCSSetFont, xCSGetFont, xCSLen

xCSLoadFont PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DS, [BP+10]
  MOV DX, [BP+08]
  MOV AX, 3D00h
  INT 21h
  JC  FontError
  MOV BX, AX
  MOV AX, SEG FontHeader
  MOV DS, AX
  MOV DX, OFFSET FontHeader
  MOV CX, 40
  MOV AH, 3Fh
  INT 21h
  JC  ReadingFontError
  MOV AX, DS
  MOV ES, AX
  MOV DI, OFFSET FontID
  MOV SI, OFFSET FontHeader
  MOV CX, 20
  REPE CMPSB
  JNE NoFontError
  MOV AX, [BP+14]
  MOV DS, AX
  MOV DX, [BP+12]
  MOV CX, 2048
  MOV AH, 3Fh
  INT 21h
  JC  ReadingFontError
  MOV AX, 3E00h
  INT 21h
  JC  FontError
  XOR AX, AX
  JMP EndLoad
ReadingFontError:
  MOV AX, 3E00h
  INT 21h
  MOV AX, 2
  JMP EndLoad
NoFontError:
  MOV AX, 3E00h
  INT 21h
  MOV AX, 3
  JMP EndLoad
FontError:
  MOV AX, 1
EndLoad:
  POP DS
  POP BP
  RET 8
xCSLoadFont ENDP

xCSPrint PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+18]
  MOV ES, AX
  MOV AX, [BP+16]
  MOV FS, AX
  MOV BX, [BP+14]
  MOV AX, SEG FontBuffer
  MOV DS, AX
  MOV AX, [BP+12]
  MOV TextX, AX
  MOV AX, [BP+10]
  MOV TextY, AX
NextChar:
  XOR AX, AX
  MOV AL, FS:[BX]
  OR  AL, AL
  JZ  EndPrint
  SHL AX, 3
  MOV SI, AX
NextY:
  XOR DX, DX
  MOV CH, 80h
NextX:
  MOV CL, FontBuffer[SI]
  TEST CL, CH
  JZ  SkipPixel
  MOV AX, TextY
  CMP AX, ClipY1
  JB  SkipPixel
  CMP AX, ClipY2
  JA  SkipPixel
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  MOV AX, TextX
  CMP AX, ClipX1
  JB  SkipPixel
  CMP AX, ClipX2
  JA  SkipPixel
  ADD DI, AX
  MOV CL, [BP+8]
  MOV ES:[DI], CL
SkipPixel:
  SHR CX, 1
  INC DX
  INC TextX
  CMP DX, 8
  JNZ NextX
  INC SI
  MOV AX, [BP+12]
  MOV TextX, AX
  INC TextY
  MOV DX, [BP+10]
  ADD DX, 8
  CMP DX, TextY
  JNZ NextY
  MOV AX, [BP+10]
  MOV TextY, AX
  MOV AX, [BP+12]
  XOR DX, DX
  MOV DL, TextSpacing
  ADD AX, DX
  MOV [BP+12], AX
  MOV TextX, AX
  INC BX
  JMP NextChar
EndPrint:
  XOR AX, AX
  MOV TextY, AX
  MOV TextX, AX
  POP DS
  POP BP
  RET 12
xCSPrint ENDP

xCSPrintSolid PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+20]
  MOV ES, AX
  MOV AX, [BP+18]
  MOV FS, AX
  MOV BX, [BP+16]
  MOV AX, SEG FontBuffer
  MOV DS, AX
  MOV AX, [BP+14]
  MOV TextX, AX
  MOV AX, [BP+12]
  MOV TextY, AX
NextSolidChar:
  XOR AX, AX
  MOV AL, FS:[BX]
  OR  AL, AL
  JZ  EndPrintSolid
  SHL AX, 3
  MOV SI, AX
NextSolidY:
  XOR DX, DX
  MOV CH, 80h
NextSolidX:
  MOV CL, FontBuffer[SI]
  TEST CL, CH
  JZ  BGSolidPixel
  MOV AX, TextY
  CMP AX, ClipY1
  JB  SkipSolidPixel
  CMP AX, ClipY2
  JA  SkipSolidPixel
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  MOV AX, TextX
  CMP AX, ClipX1
  JB  SkipSolidPixel
  CMP AX, ClipX2
  JA  SkipSolidPixel
  ADD DI, AX
  MOV CL, [BP+10]
  MOV ES:[DI], CL
  JMP SkipSolidPixel
BGSolidPixel:
  MOV AX, TextY
  CMP AX, ClipY1
  JB  SkipSolidPixel
  CMP AX, ClipY2
  JA  SkipSolidPixel
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  MOV AX, TextX
  CMP AX, ClipX1
  JB  SkipSolidPixel
  CMP AX, ClipX2
  JA  SkipSolidPixel
  ADD DI, AX
  MOV CL, [BP+08]
  MOV ES:[DI], CL
SkipSolidPixel:
  SHR CX, 1
  INC DX
  INC TextX
  CMP DX, 8
  JNZ NextSolidX
  INC SI
  MOV AX, [BP+14]
  MOV TextX, AX
  INC TextY
  MOV DX, [BP+12]
  ADD DX, 8
  CMP DX, TextY
  JNZ NextSolidY
  MOV AX, [BP+12]
  MOV TextY, AX
  MOV AX, [BP+14]
  ADD AX, 8
  MOV [BP+14], AX
  MOV TextX, AX
  INC BX
  JMP NextSolidChar
EndPrintSolid:
  XOR AX, AX
  MOV TextY, AX
  MOV TextX, AX
  POP DS
  POP BP
  RET 14
xCSPrintSolid ENDP

xCSPrintTextured PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+16]
  MOV ES, AX
  MOV AX, [BP+14]
  MOV FS, AX
  MOV BX, [BP+12]
  MOV AX, SEG FontBuffer
  MOV DS, AX
  XOR AX, AX
  MOV TexturePos, AX
  MOV AX, [BP+10]
  MOV TextX, AX
  MOV AX, [BP+08]
  MOV TextY, AX
NextTexturedChar:
  XOR AX, AX
  MOV AL, FS:[BX]
  OR  AL, AL
  JZ  EndPrintTextured
  SHL AX, 3
  MOV SI, AX
NextTexturedY:
  XOR DX, DX
  MOV CH, 80h
NextTexturedX:
  MOV CL, FontBuffer[SI]
  TEST CL, CH
  JZ  SkipTexturedPixel
  MOV AX, TextY
  CMP AX, ClipY1
  JB  SkipTexturedPixel
  CMP AX, ClipY2
  JA  SkipTexturedPixel
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  MOV AX, TextX
  CMP AX, ClipX1
  JB  SkipTexturedPixel
  CMP AX, ClipX2
  JA  SkipTexturedPixel
  ADD DI, AX
  PUSH SI
  MOV SI, TexturePos
  MOV CL, TextTexture[SI]
  POP SI
  MOV ES:[DI], CL
SkipTexturedPixel:
  SHR CX, 1
  INC DX
  INC TextX
  INC TexturePos
  CMP DX, 8
  JNZ NextTexturedX
  INC SI
  MOV AX, [BP+10]
  MOV TextX, AX
  INC TextY
  MOV DX, [BP+08]
  ADD DX, 8
  CMP DX, TextY
  JNZ NextTexturedY
  MOV AX, [BP+08]
  MOV TextY, AX
  MOV AX, [BP+10]
  XOR DX, DX
  MOV TexturePos, DX
  MOV DL, TextSpacing
  ADD AX, DX
  MOV [BP+10], AX
  MOV TextX, AX
  INC BX
  JMP NextTexturedChar
EndPrintTextured:
  XOR AX, AX
  MOV TextY, AX
  MOV TextX, AX
  MOV TexturePos, AX
  POP DS
  POP BP
  RET 10
xCSPrintTextured ENDP

xCSPrintReversed PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+18]
  MOV ES, AX
  MOV AX, [BP+16]
  MOV FS, AX
  MOV BX, [BP+14]
  MOV AX, SEG FontBuffer
  MOV DS, AX
  MOV AX, [BP+12]
  MOV TextX, AX
  MOV AX, [BP+10]
  ADD AX, 8
  MOV TextY, AX
NextReversedChar:
  XOR AX, AX
  MOV AL, FS:[BX]
  OR  AL, AL
  JZ  EndReversedPrint
  SHL AX, 3
  MOV SI, AX
NextReversedY:
  XOR DX, DX
  MOV CH, 80h
NextReversedX:
  MOV CL, FontBuffer[SI]
  TEST CL, CH
  JZ  SkipReversedPixel
  MOV AX, TextY
  CMP AX, ClipY1
  JB  SkipReversedPixel
  CMP AX, ClipY2
  JA  SkipReversedPixel
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  MOV AX, TextX
  CMP AX, ClipX1
  JB  SkipReversedPixel
  CMP AX, ClipX2
  JA  SkipReversedPixel
  ADD DI, AX
  MOV CL, [BP+08]
  MOV ES:[DI], CL
SkipReversedPixel:
  SHR CX, 1
  INC DX
  INC TextX
  CMP DX, 8
  JNZ NextReversedX
  INC SI
  MOV AX, [BP+12]
  MOV TextX, AX
  DEC TextY
  MOV DX, [BP+10]
  CMP DX, TextY
  JNZ NextReversedY
  MOV AX, [BP+10]
  ADD AX, 8
  MOV TextY, AX
  MOV AX, [BP+12]
  XOR DX, DX
  MOV DL, TextSpacing
  ADD AX, DX
  MOV [BP+12], AX
  MOV TextX, AX
  INC BX
  JMP NextReversedChar
EndReversedPrint:
  XOR AX, AX
  MOV TextY, AX
  MOV TextX, AX
  POP DS
  POP BP
  RET 12
xCSPrintReversed ENDP

xCSPrintBlended PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndBPrint
  MOV AX, [BP+18]
  MOV ES, AX
  MOV AX, [BP+16]
  MOV FS, AX
  MOV BX, [BP+14]
  MOV AX, SEG FontBuffer
  MOV DS, AX
  MOV AX, BMapSeg
  MOV GS, AX
  MOV AX, [BP+12]
  MOV TextX, AX
  MOV AX, [BP+10]
  MOV TextY, AX
NextBChar:
  XOR AX, AX
  MOV AL, FS:[BX]
  OR  AL, AL
  JZ  EndBPrint
  SHL AX, 3
  MOV SI, AX
NextBY:
  XOR DX, DX
  MOV CH, 80h
NextBX:
  MOV CL, FontBuffer[SI]
  TEST CL, CH
  JZ  SkipBPixel
  MOV AX, TextY
  CMP AX, ClipY1
  JB  SkipBPixel
  CMP AX, ClipY2
  JA  SkipBPixel
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  MOV AX, TextX
  CMP AX, ClipX1
  JB  SkipBPixel
  CMP AX, ClipX2
  JA  SkipBPixel
  ADD DI, AX
  PUSH BX
  MOV BL, ES:[DI]
  MOV CL, [BP+08]
  MOV BH, CL
  MOV CL, GS:[BX]
  POP BX
  MOV ES:[DI], CL
SkipBPixel:
  SHR CX, 1
  INC DX
  INC TextX
  CMP DX, 8
  JNZ NextBX
  INC SI
  MOV AX, [BP+12]
  MOV TextX, AX
  INC TextY
  MOV DX, [BP+10]
  ADD DX, 8
  CMP DX, TextY
  JNZ NextBY
  MOV AX, [BP+10]
  MOV TextY, AX
  MOV AX, [BP+12]
  XOR DX, DX
  MOV DL, TextSpacing
  ADD AX, DX
  MOV [BP+12], AX
  MOV TextX, AX
  INC BX
  JMP NextBChar
EndBPrint:
  XOR AX, AX
  MOV TextY, AX
  MOV TextX, AX
  POP DS
  POP BP
  RET 12
xCSPrintBlended ENDP

CSSetTextSpacing PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+04]
  MOV TextSpacing, AL
  MOV BP, BX
  RET 2
CSSetTextSpacing ENDP

CSTextTexture PROC
  MOV BX, BP
  MOV DX, DS
  MOV BP, SP
  MOV DS, [BP+06]
  MOV SI, [BP+04]
  MOV AX, SEG TextTexture
  MOV ES, AX
  MOV DI, OFFSET TextTexture
  MOV CX, 64
  SHR CX, 2
  REP MOVSD
  MOV BP, BX
  MOV DS, DX
  RET 4
CSTextTexture ENDP

CSGetTextSpacing PROC
  XOR AH, AH
  MOV AL, TextSpacing
  RET
CSGetTextSpacing ENDP

CSResetFont PROC
  PUSH DS
  MOV AX, 351Fh
  INT 21h
  MOV AX, ES
  MOV DS, AX
  MOV SI, BX
  SUB SI, 1024
  MOV AX, SEG FontBuffer
  MOV ES, AX
  MOV DI, OFFSET FontBuffer
  MOV CX, 512
  REP MOVSD
  POP DS
  RET
CSResetFont ENDP

xCSSetFont PROC
  MOV DX, DS
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV SI, [BP+04]
  MOV DS, AX
  MOV AX, SEG FontBuffer
  MOV DI, OFFSET FontBuffer
  MOV ES, AX
  MOV CX, 512
  REP MOVSD
  MOV DS, DX
  MOV BP, BX
  RET 4
xCSSetFont ENDP

xCSGetFont PROC
  MOV DX, DS
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV DI, [BP+04]
  MOV ES, AX
  MOV AX, SEG FontBuffer
  MOV SI, OFFSET FontBuffer
  MOV DS, AX
  MOV CX, 512
  REP MOVSD
  MOV DS, DX
  MOV BP, BX
  RET 4
xCSGetFont ENDP

xCSLen PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+08]
  MOV DI, [BP+06]
  MOV ES, AX
  XOR CX, CX
  XOR AX, AX
FindLen:
  MOV AL, ES:[DI]
  INC DI
  OR  AL, AL
  JZ  EndFindLen
  INC CX
  JMP FindLen
EndFindLen:
  XOR BH, BH
  MOV AX, CX
  MOV BL, 8
  XOR DX, DX
  MUL BX
  POP BP
  RET 4
xCSLen ENDP

END
