;----------------------------------------------------------------------------
;
;  CosmoX EMS Handling Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

EMSMoveStruct STRUC
  EMSLength   DD  ?
  SType       DB  ?
  SHandle     DW  ?
  SOffset     DW  ?
  SSegment    DW  ?
  DType       DB  ?
  DHandle     DW  ?
  DOffset     DW  ?
  DSegment    DW  ?
EMSMoveStruct ENDS

.DATA

ALIGN 2

EMMID               DB  'EMMXXXX0'      ;  Expanded Memory manager ID
EMSMove             EMSMoveStruct <>    ;  EMS Move Struct

.CODE

PUBLIC  CSDetectEMS, CSGetEMSFrame, CSFreeEMSPages, CSTotalEMSPages, CSFreeEMS
PUBLIC  CSTotalEMS, CSAllocateEMS, CSDeallocateEMS, CSMapEMS, CSEMSHandles
PUBLIC  CSMapEMSLayer, CSResizeEMS, CSMoveToEMS, CSMoveFromEMS, CSMoveEMS
PUBLIC  xCSGetEMSVer

CSDetectEMS PROC
  PUSH DS
  MOV AX, @DATA
  MOV DS, AX
  MOV SI, OFFSET EMMID
  MOV DI, 000Ah
  MOV AX, 3567h
  INT 21h
  XOR AX, AX
  MOV CX, 8
  REPE CMPSB
  SETE AL
  POP DS
  RET
CSDetectEMS ENDP

xCSGetEMSVer PROC
  MOV AX, 4600h
  INT 67h
  OR  AH, AH
  JZ  EMSVersion
  XOR AX, AX
EMSVersion:
  RET
xCSGetEMSVer ENDP

CSGetEMSFrame PROC
  XOR AX, AX
  XOR BX, BX
  MOV AH, 41h
  INT 67h
  MOV AX, BX
  RET
CSGetEMSFrame ENDP

CSFreeEMSPages PROC
  XOR AX, AX
  MOV AH, 42h
  XOR BX, BX
  INT 67h
  MOV AX, BX
  RET
CSFreeEMSPages ENDP

CSTotalEMSPages PROC
  XOR AX, AX
  MOV AH, 42h
  XOR DX, DX
  INT 67h
  MOV AX, DX
  RET
CSTotalEMSPages ENDP

CSFreeEMS PROC
  XOR AX, AX
  MOV AH, 42h
  XOR BX, BX
  INT 67h
  MOV AX, BX
  XOR DX, DX
  SHL AX, 4
  RET
CSFreeEMS ENDP

CSTotalEMS PROC
  XOR AX, AX
  MOV AH, 42h
  XOR DX, DX
  INT 67h
  MOV AX, DX
  XOR DX, DX
  SHL AX, 4
  RET
CSTotalEMS ENDP

CSEMSHandles PROC
  XOR AX, AX
  MOV AH, 4Bh
  XOR BX, BX
  INT 67h
  MOV AX, BX
  RET
CSEMSHandles ENDP

CSAllocateEMS PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  XOR DX, DX
  MOV BX, [BP+06]
  MOV AH, 43h
  INT 67h
  OR  AH, AH
  JNZ NoEMSMemory
  MOV AX, DX
  POP BP
  RET 2
NoEMSMemory:
  XOR AX, AX
  POP BP
  RET 2
CSAllocateEMS ENDP

CSDeallocateEMS PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  MOV DX, [BP+06]
  MOV AH, 45h
  INT 67h
  POP BP
  RET 2
CSDeallocateEMS ENDP

CSMapEMS PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  MOV DX, [BP+10]
  MOV AL, [BP+08]
  AND AL, 03h
  MOV BX, [BP+06]
  MOV AH, 44h
  INT 67h
  POP BP
  RET 6
CSMapEMS ENDP

CSMapEMSLayer PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  MOV DX, [BP+08]
  MOV BX, [BP+06]
MapEMSLayer:
  MOV AH, 44h
  INT 67h
  INC BX
  INC AL
  CMP AL, 4
  JNZ MapEMSLayer
  POP BP
  RET 4
CSMapEMSLayer ENDP

CSResizeEMS PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  XOR BX, BX
  MOV DX, [BP+08]
  MOV BX, [BP+06]
  MOV AH, 51h
  INT 67h
  MOV AX, BX
  POP BP
  RET 4
CSResizeEMS ENDP

CSMoveToEMS PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+22]
  MOV EMSMove.SSegment, AX
  MOV AX, [BP+18]
  MOV EMSMove.SOffset, AX
  MOV AX, [BP+16]
  MOV EMSMove.DHandle, AX
  MOV AX, [BP+14]
  MOV EMSMove.DSegment, AX
  MOV AX, [BP+12]
  MOV EMSMove.DOffset, AX
  MOV EAX, [BP+08]
  MOV EMSMove.EMSLength, EAX
  XOR AX, AX
  MOV EMSMove.SType, AL
  MOV EMSMove.SHandle, AX
  MOV AL, 1
  MOV EMSMove.DType, AL
  MOV AX, SEG EMSMove
  MOV DS, AX
  MOV SI, OFFSET EMSMove
  XOR AX, AX
  MOV AH, 57h
  INT 67h
  POP DS
  POP BP
  RET 16
CSMoveToEMS ENDP

CSMoveFromEMS PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+22]
  MOV EMSMove.DSegment, AX
  MOV AX, [BP+18]
  MOV EMSMove.DOffset, AX
  MOV AX, [BP+16]
  MOV EMSMove.SHandle, AX
  MOV AX, [BP+14]
  MOV EMSMove.SSegment, AX
  MOV AX, [BP+12]
  MOV EMSMove.SOffset, AX
  MOV EAX, [BP+08]
  MOV EMSMove.EMSLength, EAX
  XOR AX, AX
  MOV EMSMove.DType, AL
  MOV EMSMove.DHandle, AX
  MOV AL, 1
  MOV EMSMove.SType, AL
  MOV AX, SEG EMSMove
  MOV DS, AX
  MOV SI, OFFSET EMSMove
  XOR AX, AX
  MOV AH, 57h
  INT 67h
  POP DS
  POP BP
  RET 16
CSMoveFromEMS ENDP

CSMoveEMS PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+22]
  MOV EMSMove.SHandle, AX
  MOV AX, [BP+20]
  MOV EMSMove.SSegment, AX
  MOV AX, [BP+18]
  MOV EMSMove.SOffset, AX
  MOV AX, [BP+16]
  MOV EMSMove.DHandle, AX
  MOV AX, [BP+14]
  MOV EMSMove.DSegment, AX
  MOV AX, [BP+12]
  MOV EMSMove.DOffset, AX
  MOV EAX, [BP+08]
  MOV EMSMove.EMSLength, EAX
  MOV AL, 1
  MOV EMSMove.SType, AL
  MOV EMSMove.DType, AL
  MOV AX, SEG EMSMove
  MOV DS, AX
  MOV SI, OFFSET EMSMove
  XOR AX, AX
  MOV AH, 57h
  INT 67h
  POP DS
  POP BP
  RET 16
CSMoveEMS ENDP

END
