;----------------------------------------------------------------------------
;
;  CosmoX DRAW Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

EXTRN BMapActive    :  BYTE
EXTRN BMapSeg       :  WORD
EXTRN ClipX1        :  WORD
EXTRN ClipX2        :  WORD
EXTRN ClipY1        :  WORD
EXTRN ClipY2        :  WORD

.DATA

ALIGN 2

Xerr                DW  0             ; \
Yerr                DW  0             ;   |
DeltaX              DW  0             ;   |
DeltaY              DW  0             ;   | Bresenham's line algorithm
XInc                DW  0             ;   |
YInc                DW  0             ;   |
Distance            DW  0             ;  /
Point               DW  0             ;  Just some variables to help me
WindowHeight        DW  0             ;  Used by CSWindow to speed things up
WindowPos1          DW  0             ;  Used by CSWindow to speed things up
WindowPos2          DW  0             ;  Used by CSWindow to speed things up
WindowWidth         DW  0             ;  Used by CSWindow to speed things up

.CODE

PUBLIC  CSPset, CSPoint, CSBox, CSBoxF, CSLine, CSCircle, CSCircleF, CSEllipse
PUBLIC  CSEllipseF, CSScroll, CSScrollArea, CSPcopy, CSPcopyT, CSPcopyB
PUBLIC  CSPcopyC, CSClear, CSWin, CSAntiAliase, CSTri, CSCopyBlock, CSPsetB
PUBLIC  CSBoxFB

PUTPIXEL MACRO
LOCAL NoPut
  CMP DX, ClipX1
  JL  NoPut
  CMP DX, ClipX2
  JG  NoPut
  CMP BX, ClipY1
  JL  NoPut
  CMP BX, ClipY2
  JG  NoPut
  MOV DI, BX
  SHL BX, 8
  SHL DI, 6
  ADD DI, BX
  ADD DI, DX
  MOV ES:[DI], AL
NoPut:
ENDM

HLINE MACRO
LOCAL NoLineH, NoClipX1, NoClipX2, NoOddPixel
  CMP DX, ClipX1
  JGE NoClipX1
  MOV DX, ClipX1
NoClipX1:
  CMP DX, ClipX2
  JG  NoLineH
  CMP CX, ClipX1
  JL  NoLineH
  CMP CX, ClipX2
  JLE NoClipX2
  MOV CX, ClipX2
 NoClipX2:
  CMP BX, ClipY1
  JL  NoLineH
  CMP BX, ClipY2
  JG  NoLineH
  SUB CX, DX
  MOV DI, BX
  SHL BX, 8
  SHL DI, 6
  ADD DI, BX
  ADD DI, DX
  TEST DI, 1
  JZ  NoOddPixel
  MOV ES:[DI], AL
  INC DI
  DEC CX
  JLE NoLineH
NoOddPixel:
  SHR CX, 1
  REP STOSW
  ADC CX, CX
  REP STOSB
NoLineH:
ENDM

CSPset PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+10]
  MOV DX, [BP+06]
  MOV CX, [BP+08]
  MOV ES, AX
  CMP DX, ClipY1
  JL  NoPutPixel
  CMP DX, ClipY2
  JG  NoPutPixel
  CMP CX, ClipX1
  JL  NoPutPixel
  CMP CX, ClipX2
  JG  NoPutPixel
  MOV DI, DX
  SHL DX, 6
  SHL DI, 8
  MOV AL, [BP+04]
  ADD DI, DX
  ADD DI, CX
  MOV ES:[DI], AL
NoPutPixel:
  MOV BP, BX
  RET 8
CSPset ENDP

CSPoint PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+08]
  MOV CX, [BP+04]
  MOV DX, [BP+06]
  MOV ES, AX
  MOV DI, CX
  SHL CX, 8
  SHL DI, 6
  ADD DI, CX
  ADD DI, DX
  XOR AH, AH
  MOV AL, ES:[DI]
  MOV BP, BX
  RET 6
CSPoint ENDP

CSPsetB PROC
  PUSH BP
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndPsetB
  MOV BX, BMapSeg
  MOV AX, [BP+12]
  MOV DX, [BP+08]
  MOV CX, [BP+10]
  MOV ES, AX
  MOV GS, BX
  CMP DX, ClipY1
  JL  EndPsetB
  CMP DX, ClipY2
  JG  EndPsetB
  CMP CX, ClipX1
  JL  EndPsetB
  CMP CX, ClipX2
  JG  EndPsetB
  MOV DI, DX
  SHL DX, 6
  SHL DI, 8
  MOV BH, [BP+06]
  ADD DI, DX
  ADD DI, CX
  MOV BL, ES:[DI]
  MOV AL, GS:[BX]
  MOV ES:[DI], AL
EndPsetB:
  POP BP
  RET 8
CSPsetB ENDP

CSBox PROC
  PUSH BP
  MOV BP, SP
  MOV DX, [BP+16]
  MOV ES, DX
  MOV AX, [BP+14]
  MOV DX, [BP+10]
  CMP AX, DX
  JLE NoSwap1
  XCHG AX, DX
  MOV [BP+14], AX
  MOV [BP+10], DX
NoSwap1:
  MOV AX, [BP+12]
  MOV DX, [BP+08]
  CMP AX, DX
  JLE NoSwap2
  XCHG AX, DX
  MOV [BP+12], AX
  MOV [BP+08], DX
NoSwap2:
  MOV CX, [BP+10]
  MOV DX, [BP+12]
  SUB CX, [BP+14]
  MOV BX, [BP+08]
  MOV SI, DX
  SHL DX, 8
  MOV DI, BX
  SHL BX, 8
  SHL SI, 6
  MOV AX, [BP+06]
  SHL DI, 6
  MOV AH, AL
  ADD SI, DX
  ADD DI, BX
  ADD SI, [BP+14]
  MOV BX, AX
  ADD DI, [BP+14]
  SHL EAX, 16
  MOV AX, BX
  MOV BX, SI
FixAddressLoopB:
  TEST DI, 3
  JZ  NoOddPixelsB
  MOV ES:[DI], AL
  MOV ES:[SI], AL
  INC DI
  INC SI
  DEC CX
  JG  FixAddressLoopB
NoOddPixelsB:
  OR  CX, CX
  JLE EndDrawHLines
  MOV DX, CX
  SHR CX, 2
  REP STOSD
  MOV CX, DX
  AND CX, 3
  SHR CX, 1
  REP STOSW
  ADC CX, CX
  REP STOSB
  MOV DI, SI
  MOV CX, DX
  SHR CX, 2
  REP STOSD
  MOV CX, DX
  AND CX, 3
  SHR CX, 1
  REP STOSW
  ADC CX, CX
  REP STOSB
EndDrawHLines:
  MOV SI, DI
  MOV DI, BX
  MOV CX, [BP+08]
  SUB CX, [BP+12]
  INC CX
VLineLoopB:
  MOV ES:[SI], AL
  MOV ES:[DI], AL
  ADD SI, 320
  ADD DI, 320
  DEC CX
  JNZ VLineLoopB
EndDrawBox:
  POP BP
  RET 12
CSBox ENDP

CSBoxF PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+14]
  MOV ES, AX
  MOV AX, [BP+12]
  MOV DX, [BP+08]
  CMP AX, DX
  JLE NoSwap3
  XCHG AX, DX
  MOV [BP+12], AX
  MOV [BP+08], DX
NoSwap3:
  MOV AX, [BP+10]
  MOV DX, [BP+06]
  CMP AX, DX
  JLE NoSwap4
  XCHG AX, DX
  MOV [BP+10], AX
  MOV [BP+06], DX
NoSwap4:
  MOV CX, [BP+08]
  SUB CX, [BP+12]
  INC CX
  MOV SI, CX
  MOV DX, [BP+06]
  SUB DX, [BP+10]
  INC DX
  MOV AX, [BP+10]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+12]
  MOV AL, [BP+04]
  MOV AH, AL
NextFillLine:
  TEST DI, 1
  JZ  NoOddPixelsBF
  MOV ES:[DI], AL
  INC DI
  DEC CX
  JLE FinishLine
NoOddPixelsBF:
  SHR CX, 1
  REP STOSW
  ADC CX, CX
  REP STOSB
FinishLine:
  MOV CX, SI
  SUB DI, SI
  ADD DI, 320
  DEC DX
  JNZ NextFillLine
  MOV BP, BX
  RET 12
CSBoxF ENDP

CSBoxFB PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndBoxFB
  MOV AX, BMapSeg
  MOV GS, AX
  MOV AX, [BP+16]
  MOV DX, [BP+12]
  CMP AX, DX
  JLE NoSwap5
  XCHG AX, DX
  MOV [BP+16], AX
  MOV [BP+12], DX
NoSwap5:
  MOV AX, [BP+14]
  MOV DX, [BP+10]
  CMP AX, DX
  JLE NoSwap6
  XCHG AX, DX
  MOV [BP+14], AX
  MOV [BP+10], DX
NoSwap6:
  MOV AX, [BP+16]
  MOV DX, [BP+14]
  CMP AX, ClipX2
  JG  EndBoxFB
  CMP AX, ClipX1
  JGE X1Ok
  MOV AX, ClipX1
X1Ok:
  CMP DX, ClipY2
  JG  EndBoxFB
  CMP DX, ClipY1
  JGE Y1Ok
  MOV DX, ClipY1
Y1Ok:
  MOV [BP+16], AX
  MOV [BP+14], DX
  MOV AX, [BP+12]
  MOV DX, [BP+10]
  CMP AX, ClipX1
  JL  EndBoxFB
  CMP AX, ClipX2
  JLE X2Ok
  MOV AX, ClipX2
X2Ok:
  CMP DX, ClipY1
  JL  EndBoxFB
  CMP DX, ClipY2
  JLE Y2Ok
  MOV DX, ClipY2
Y2Ok:
  MOV CX, AX
  SUB CX, [BP+16]
  MOV DI, DX
  SUB DI, [BP+14]
  INC CX
  INC DI
  MOV DX, [BP+18]
  MOV DS, DX
  MOV AX, [BP+14]
  MOV SI, AX
  SHL AX, 8
  SHL SI, 6
  ADD SI, AX
  ADD SI, [BP+16]
  MOV DX, CX
  MOV BH, [BP+08]
FillBlend:
  MOV BL, [SI]
  MOV AL, GS:[BX]
  MOV [SI], AL
  INC SI
  DEC CX
  JNZ FillBlend
  ADD SI, 320
  SUB SI, DX
  MOV CX, DX
  DEC DI
  JNZ FillBlend
EndBoxFB:
  POP DS
  POP BP
  RET 12
CSBoxFB ENDP

CSLine PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  MOV BX, [BP+16]
  MOV Xerr, AX
  MOV Yerr, AX
  MOV ES, BX
  MOV AX, [BP+10]
  MOV DX, [BP+08]
  SUB AX, [BP+14]
  SUB DX, [BP+12]
  MOV BX, 1
  XOR CX, CX
  OR  AX, AX
  JZ  ZeroXInc
  JG  PosXInc
  NEG AX
  NOT CX
  MOV XInc, CX
  MOV DeltaX, AX
  NEG AX
  NOT CX
  JMP OkXInc
PosXInc:
  MOV XInc,  BX
  MOV DeltaX, AX
  JMP OkXInc
ZeroXInc:
  MOV XInc, CX
  MOV DeltaX, AX
OkXInc:
  OR  DX, DX
  JE  ZeroYInc
  JG  PosYInc
  NEG DX
  NOT CX
  MOV YInc, CX
  MOV DeltaY, DX
  NEG DX
  NOT CX
  JMP OkYInc
PosYInc:
  MOV YInc, BX
  MOV DeltaY, DX
  JMP OkYInc
ZeroYInc:
  MOV YInc, CX
  MOV DeltaY, DX
OkYInc:
  MOV AX, DeltaX
  MOV DX, DeltaY
  CMP AX, DX
  JNG DistanceY
  MOV Distance, AX
  JMP DistanceOk
DistanceY:
  MOV Distance, DX
DistanceOk:
  MOV CX, -1
  MOV DX, [BP+14]
  MOV BX, [BP+12]
DrawLoopLine:
  CMP DX, ClipX1
  JL  SkipPixelLine
  CMP BX, ClipY1
  JL  SkipPixelLine
  CMP DX, ClipX2
  JG  SkipPixelLine
  CMP BX, ClipY2
  JG  SkipPixelLine
  MOV AX, BX
  MOV SI, BX
  SHL AX, 8
  SHL SI, 6
  ADD SI, AX
  ADD SI, DX
  MOV AL, [BP+06]
  MOV ES:[SI], AL
SkipPixelLine:
  MOV AX, Xerr
  MOV DI, Yerr
  ADD AX, DeltaX
  ADD DI, DeltaY
  MOV Xerr, AX
  MOV Yerr, DI
  CMP AX, Distance
  JNG NoRollOverX
  SUB AX, Distance
  ADD DX, XInc
  MOV Xerr, AX
NoRollOverX:
  CMP DI, Distance
  JNG UpdateCounterLine
  SUB DI, Distance
  ADD BX, YInc
  MOV Yerr, DI
UpdateCounterLine:
  INC CX
  CMP CX, Distance
  JLE DrawLoopLine
  POP BP
  RET 12
CSLine ENDP

CSCircle PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+14]
  MOV DX, [BP+12]
  MOV BX, [BP+10]
  MOV CX, [BP+08]
  MOV SI, [BP+06]
  PUSH AX
  PUSH DX
  PUSH BX
  PUSH CX
  PUSH CX
  PUSH SI
  CALL CSEllipse
  POP BP
  RET 10
CSCircle ENDP

CSCircleF PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+14]
  MOV DX, [BP+12]
  MOV BX, [BP+10]
  MOV CX, [BP+08]
  MOV SI, [BP+06]
  PUSH AX
  PUSH DX
  PUSH BX
  PUSH CX
  PUSH CX
  PUSH SI
  CALL CSEllipseF
  POP BP
  RET 10
CSCircleF ENDP

CSEllipse PROC
  PUSH BP
  SUB SP, 12
  MOV BP, SP
  MOV AX, [BP+28]
  MOV ES, AX
  MOV DX, [BP+22]
  CMP DX, 0
  JNE NotVLine
  MOV DX, [BP+24]
  SUB DX, [BP+20]
  MOV CX, [BP+24]
  ADD CX, [BP+20]
  CMP DX, ClipY1
  JGE NoClipY1
  MOV DX, ClipY1
NoClipY1:
  CMP DX, ClipY2
  JG  EndEllipse
  CMP CX, ClipY1
  JL  EndEllipse
  CMP CX, ClipY2
  JLE NoClipY2
  MOV CX, ClipY2
NoClipY2:
  MOV AX, [BP+26]
  CMP AX, ClipX1
  JL  EndEllipse
  CMP AX, ClipX2
  JG  EndEllipse
  SUB CX, DX
  INC CX
  MOV DI, DX
  SHL DX, 8
  SHL DI, 6
  ADD DI, DX
  ADD DI, AX
  MOV AX, [BP+18]
VLineLoop:
  MOV ES:[DI], AL
  ADD DI, 320
  DEC CX
  JNZ VLineLoop
  JMP EndEllipse
NotVLine:
  MOV DX, [BP+20]
  CMP DX, 0
  JNE NotHLine
  MOV DX, [BP+26]
  SUB DX, [BP+22]
  MOV CX, [BP+26]
  ADD CX, [BP+22]
  CMP DX, ClipX1
  JGE NoClipX1
  MOV DX, ClipX1
NoClipX1:
  CMP DX, ClipX2
  JG  EndEllipse
  CMP CX, ClipX1
  JL  EndEllipse
  CMP CX, ClipX2
  JLE NoClipX2
  MOV CX, ClipX2
NoClipX2:
  MOV AX, [BP+24]
  CMP AX, ClipY1
  JL  EndEllipse
  CMP AX, ClipY2
  JG  EndEllipse
  SUB CX, DX
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, DX
  MOV AX, [BP+18]
  MOV AH, AL
  SHR CX, 1
  REP STOSW
  ADC CX, 1
  REP STOSB
  JMP EndEllipse
NotHLine:
  MOV AX, [BP+20]
  CMP AX, [BP+22]
  JG  OtherAxis
  XOR DX, DX
  MOV [BP+10], DX
  MOV [BP+06], DX
  MOV AX, [BP+22]
  MOV BX, AX
  MUL BX
  MOV [BP+04], AX
  PUSH AX
  SHR AX, 1
  NEG AX
  MOV [BP], AX
  MOV BX, [BP+20]
  MOV [BP+08], BX
  POP AX
  XOR DX, DX
  DIV BX
  MOV [BP+02], AX
  MOV AX, [BP+18]
AxisLoopX:
  MOV DX, [BP]
  CMP DX, 0
  JG  OnlyFourPixelsX
FourPixelsLoopX:
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+10]
  ADD BX, [BP+08]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  ADD BX, [BP+08]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+10]
  SUB BX, [BP+08]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  SUB BX, [BP+08]
  PUTPIXEL
  MOV DX, [BP+10]
  INC DX
  MOV [BP+10], DX
  MOV BX, [BP+06]
  ADD BX, [BP+20]
  MOV [BP+06], BX
  MOV DX, [BP]
  ADD DX, BX
  MOV [BP], DX
  CMP DX, 0
  JLE FourPixelsLoopX
  JMP UpdateCountersX
OnlyFourPixelsX:
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+10]
  ADD BX, [BP+08]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  ADD BX, [BP+08]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+10]
  SUB BX, [BP+08]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  SUB BX, [BP+08]
  PUTPIXEL
UpdateCountersX:
  MOV DX, [BP+04]
  SUB DX, [BP+02]
  MOV [BP+04], DX
  MOV BX, [BP]
  SUB BX, DX
  MOV [BP], BX
  MOV DX, [BP+08]
  DEC DX
  MOV [BP+08], DX
  CMP DX, 0
  JNE AxisLoopX
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  PUTPIXEL
  JMP EndEllipse
OtherAxis:
  XOR DX, DX
  MOV [BP+10], DX
  MOV [BP+06], DX
  MOV AX, [BP+20]
  MOV BX, AX
  MUL BX
  MOV [BP+04], AX
  PUSH AX
  SHR AX, 1
  NEG AX
  MOV [BP], AX
  MOV BX, [BP+22]
  MOV [BP+08], BX
  POP AX
  XOR DX, DX
  DIV BX
  MOV [BP+02], AX
  MOV AX, [BP+18]
AxisLoopY:
  MOV DX, [BP]
  CMP DX, 0
  JG  OnlyFourPixelsY
FourPixelsLoopY:
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+08]
  ADD BX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+08]
  ADD BX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+08]
  SUB BX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+08]
  SUB BX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+10]
  INC DX
  MOV [BP+10], DX
  MOV BX, [BP+06]
  ADD BX, [BP+22]
  MOV [BP+06], BX
  MOV DX, [BP]
  ADD DX, BX
  MOV [BP], DX
  CMP DX, 0
  JLE FourPixelsLoopY
  JMP UpdateCountersY
OnlyFourPixelsY:
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+08]
  ADD BX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+08]
  ADD BX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD DX, [BP+08]
  SUB BX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+08]
  SUB BX, [BP+10]
  PUTPIXEL
UpdateCountersY:
  MOV DX, [BP+04]
  SUB DX, [BP+02]
  MOV [BP+04], DX
  MOV BX, [BP]
  SUB BX, DX
  MOV [BP], BX
  MOV DX, [BP+08]
  DEC DX
  MOV [BP+08], DX
  CMP DX, 0
  JNE AxisLoopY
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  ADD BX, [BP+10]
  PUTPIXEL
  MOV DX, [BP+26]
  MOV BX, [BP+24]
  SUB BX, [BP+10]
  PUTPIXEL
EndEllipse:
  ADD SP, 12
  POP BP
  RET 12
CSEllipse ENDP

CSEllipseF PROC
  PUSH BP
  SUB SP, 12
  MOV BP, SP
  MOV AX, [BP+28]
  MOV ES, AX
  MOV DX, [BP+22]
  CMP DX, 0
  JNE NotVLineF
  MOV DX, [BP+24]
  SUB DX, [BP+20]
  MOV CX, [BP+24]
  ADD CX, [BP+20]
  CMP DX, ClipY1
  JGE NoClipY1F
  MOV DX, ClipY1
NoClipY1F:
  CMP DX, ClipY2
  JG  EndEllipseF
  CMP CX, ClipY1
  JL  EndEllipseF
  CMP CX, ClipY2
  JLE NoClipY2F
  MOV CX, ClipY2
NoClipY2F:
  MOV AX, [BP+26]
  CMP AX, ClipX1
  JL  EndEllipseF
  CMP AX, ClipX2
  JG  EndEllipseF
  SUB CX, DX
  INC CX
  MOV DI, DX
  SHL DX, 8
  SHL DI, 6
  ADD DI, DX
  ADD DI, AX
  MOV AX, [BP+18]
VLineLoopF:
  MOV ES:[DI], AL
  ADD DI, 320
  DEC CX
  JNZ VLineLoopF
  JMP EndEllipseF
NotVLineF:
  MOV DX, [BP+20]
  CMP DX, 0
  JNE NotHLineF
  MOV DX, [BP+26]
  SUB DX, [BP+22]
  MOV CX, [BP+26]
  ADD CX, [BP+22]
  CMP DX, ClipX1
  JGE NoClipX1F
  MOV DX, ClipX1
NoClipX1F:
  CMP DX, ClipX2
  JG  EndEllipseF
  CMP CX, ClipX1
  JL  EndEllipseF
  CMP CX, ClipX2
  JLE NoClipX2F
  MOV CX, ClipX2
NoClipX2F:
  MOV AX, [BP+24]
  CMP AX, ClipY1
  JL  EndEllipseF
  CMP AX, ClipY2
  JG  EndEllipseF
  SUB CX, DX
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, DX
  MOV AX, [BP+18]
  MOV AH, AL
  SHR CX, 1
  REP STOSW
  ADC CX, 1
  REP STOSB
  JMP EndEllipseF
NotHLineF:
  MOV AX, [BP+20]
  CMP AX, [BP+22]
  JG  OtherAxisF
  XOR DX, DX
  MOV [BP+10], DX
  MOV [BP+06], DX
  MOV AX, [BP+22]
  MOV BX, AX
  MUL BX
  MOV [BP+04], AX
  PUSH AX
  SHR AX, 1
  NEG AX
  MOV [BP], AX
  MOV BX, [BP+20]
  MOV [BP+08], BX
  POP AX
  XOR DX, DX
  DIV BX
  MOV [BP+02], AX
  MOV AX, [BP+18]
  MOV AH, AL
AxisLoopXF:
  MOV DX, [BP]
  CMP DX, 0
  JG  OnlyFourPixelsXF
FourPixelsLoopXF:
  MOV DX, [BP+26]
  MOV CX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  ADD CX, [BP+10]
  ADD BX, [BP+08]
  HLINE
  MOV DX, [BP+26]
  MOV CX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  ADD CX, [BP+10]
  SUB BX, [BP+08]
  HLINE
  MOV DX, [BP+26]
  MOV CX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  ADD CX, [BP+10]
  HLINE
  MOV DX, [BP+10]
  INC DX
  MOV [BP+10], DX
  MOV BX, [BP+06]
  ADD BX, [BP+20]
  MOV [BP+06], BX
  MOV DX, [BP]
  ADD DX, BX
  MOV [BP], DX
  CMP DX, 0
  JLE FourPixelsLoopXF
  JMP UpdateCountersXF
OnlyFourPixelsXF:
  MOV DX, [BP+26]
  MOV CX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  ADD CX, [BP+10]
  ADD BX, [BP+08]
  HLINE
  MOV DX, [BP+26]
  MOV CX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+10]
  ADD CX, [BP+10]
  SUB BX, [BP+08]
  HLINE
UpdateCountersXF:
  MOV DX, [BP+04]
  SUB DX, [BP+02]
  MOV [BP+04], DX
  MOV BX, [BP]
  SUB BX, DX
  MOV [BP], BX
  MOV DX, [BP+08]
  DEC DX
  MOV [BP+08], DX
  CMP DX, 0
  JNE AxisLoopXF
  JMP EndEllipseF
OtherAxisF:
  XOR DX, DX
  MOV [BP+10], DX
  MOV [BP+06], DX
  MOV AX, [BP+20]
  MOV BX, AX
  MUL BX
  MOV [BP+04], AX
  PUSH AX
  SHR AX, 1
  NEG AX
  MOV [BP], AX
  MOV BX, [BP+22]
  MOV [BP+08], BX
  POP AX
  XOR DX, DX
  DIV BX
  MOV [BP+02], AX
  MOV AX, [BP+18]
  MOV AH, AL
AxisLoopYF:
  MOV DX, [BP]
  CMP DX, 0
  JG  UpdateCountersYF
FourPixelsLoopYF:
  MOV DX, [BP+26]
  MOV CX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+08]
  ADD CX, [BP+08]
  ADD BX, [BP+10]
  HLINE
  MOV DX, [BP+26]
  MOV CX, [BP+26]
  MOV BX, [BP+24]
  SUB DX, [BP+08]
  ADD CX, [BP+08]
  SUB BX, [BP+10]
  HLINE
  MOV DX, [BP+10]
  INC DX
  MOV [BP+10], DX
  MOV BX, [BP+06]
  ADD BX, [BP+22]
  MOV [BP+06], BX
  MOV DX, [BP]
  ADD DX, BX
  MOV [BP], DX
  CMP DX, 0
  JLE FourPixelsLoopYF
UpdateCountersYF:
  MOV DX, [BP+04]
  SUB DX, [BP+02]
  MOV [BP+04], DX
  MOV BX, [BP]
  SUB BX, DX
  MOV [BP], BX
  MOV DX, [BP+08]
  DEC DX
  MOV [BP+08], DX
  CMP DX, 0
  JNE AxisLoopYF
EndEllipseF:
  ADD SP, 12
  POP BP
  RET 12
CSEllipseF ENDP

CSScroll PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+12]
  MOV DS, AX
  MOV ES, AX
  MOV AL, [BP+08]
  CMP AL, 3
  JE  ScrollRight
  CMP AL, 2
  JE  ScrollLeft
  CMP AL, 1
  JE  ScrollDown
  MOV AX, [BP+10]
  MOV SI, AX
  SHL AX, 8
  SHL SI, 6
  ADD SI, AX
  XOR DI, DI
  MOV CX, 16000
  REP MOVSD
  POP DS
  POP BP
  RET 6
ScrollDown:
  MOV AX, [BP+10]
  MOV BX, AX
  SHL AX, 8
  SHL BX, 6
  ADD AX, BX
  MOV CX, 63996
  MOV DI, CX
  MOV SI, DI
  SUB SI, AX
  SUB CX, AX
  SHR CX, 2
  STD
  REP MOVSD
  CLD
  POP DS
  POP BP
  RET 6
ScrollLeft:
  XOR DI, DI
  MOV SI, [BP+10]
  MOV CX, 64000
  SUB CX, [BP+10]
  SHR CX, 2
  REP MOVSD
  POP DS
  POP BP
  RET 6
ScrollRight:
  MOV CX, 63996
  MOV DI, CX
  SUB CX, [BP+10]
  MOV SI, CX
  SHR CX, 2
  STD
  REP MOVSD
  CLD
  POP DS
  POP BP
  RET 6
CSScroll ENDP

CSScrollArea PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+18]
  MOV DS, AX
  MOV ES, AX
  MOV AL, [BP+08]
  CMP AL, 3
  JE  AScrollRight
  CMP AL, 2
  JE  AScrollLeft
  CMP AL, 1
  JE  AScrollDown
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  MOV SI, DI
  ADD SI, 320
  MOV DX, [BP+12]
  SUB DX, [BP+16]
  INC DX
  MOV CX, DX
  MOV BX, [BP+14]
  INC BX
AScrollLoopU:
  SHR CX, 1
  REP MOVSW
  ADC CX, CX
  REP MOVSB
  SUB SI, DX
  MOV DI, SI
  ADD SI, 320
  MOV CX, DX
  INC BX
  CMP BX, [BP+10]
  JL  AScrollLoopU
  POP DS
  POP BP
  RET 12
AScrollDown:
  MOV AX, [BP+10]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  MOV SI, DI
  SUB SI, 320
  MOV DX, [BP+12]
  SUB DX, [BP+16]
  INC DX
  MOV CX, DX
  MOV BX, [BP+14]
  INC BX
AScrollLoopD:
  SHR CX, 1
  REP MOVSW
  ADC CX, CX
  REP MOVSB
  SUB SI, DX
  MOV DI, SI
  SUB SI, 320
  MOV CX, DX
  INC BX
  CMP BX, [BP+10]
  JL  AScrollLoopD
  POP DS
  POP BP
  RET 12
AScrollLeft:
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  MOV SI, DI
  INC SI
  MOV DX, [BP+12]
  SUB DX, [BP+16]
  MOV CX, DX
  MOV BX, [BP+14]
AScrollLoopL:
  SHR CX, 1
  REP MOVSW
  ADC CX, CX
  REP MOVSB
  SUB SI, DX
  ADD SI, 320
  MOV DI, SI
  DEC DI
  MOV CX, DX
  INC BX
  CMP BX, [BP+10]
  JLE AScrollLoopL
  POP DS
  POP BP
  RET 12
AScrollRight:
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+12]
  MOV SI, DI
  DEC SI
  MOV DX, [BP+12]
  SUB DX, [BP+16]
  MOV CX, DX
  MOV BX, [BP+14]
  STD
AScrollLoopR:
  SHR CX, 1
  REP MOVSW
  ADC CX, CX
  REP MOVSB
  ADD DI, 320
  ADD DI, DX
  MOV SI, DI
  DEC SI
  MOV CX, DX
  INC BX
  CMP BX, [BP+10]
  JLE AScrollLoopR
  CLD
  POP DS
  POP BP
  RET 12
CSScrollArea ENDP

CSClear PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV ES, AX
  XOR DI, DI
  MOV AL, [BP+04]
  MOV AH, AL
  MOV DX, AX
  SHL EAX, 16
  MOV AX, DX
  MOV CX, 16000
  REP STOSD
  MOV BP, BX
  RET 4
CSClear ENDP

CSPcopy PROC
  MOV BX, BP
  MOV DX, DS
  MOV BP, SP
  MOV AX, [BP+06]
  MOV DS, AX
  MOV AX, [BP+04]
  MOV ES, AX
  XOR SI, SI
  XOR DI, DI
  MOV CX, 16000
  REP MOVSD
  MOV DS, DX
  MOV BP, BX
  RET 4
CSPcopy ENDP

CSPcopyT PROC
  MOV BX, BP
  MOV DX, DS
  MOV BP, SP
  MOV AX, [BP+06]
  MOV DS, AX
  MOV AX, [BP+04]
  MOV ES, AX
  XOR SI, SI
  XOR DI, DI
  XOR CX, CX
PcopyTLoop:
  MOV AL, [SI]
  OR  AL, AL
  JZ  SkipPcopyTPixel
  MOV ES:[DI], AL
SkipPcopyTPixel:
  INC SI
  INC DI
  INC CX
  CMP CX, 64000
  JNZ PcopyTLoop
  MOV DS, DX
  MOV BP, BX
  RET 4
CSPcopyT ENDP

CSPcopyB PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndPcopyB
  MOV AX, BMapSeg
  MOV GS, AX
  MOV AX, [BP+06]
  MOV DS, AX
  MOV AX, [BP+04]
  MOV ES, AX
  XOR SI, SI
  XOR DI, DI
  XOR CX, CX
PcopyBLoop:
  MOV AL, [SI]
  OR  AL, AL
  JZ  SkipPcopyBPixel
  MOV BL, ES:[DI]
  MOV BH, AL
  MOV AL, GS:[BX]
  MOV ES:[DI], AL
SkipPcopyBPixel:
  INC SI
  INC DI
  INC CX
  CMP CX, 64000
  JNZ PcopyBLoop
EndPcopyB:
  POP DS
  POP BP
  RET 4
CSPcopyB ENDP

CSPcopyC PROC
  PUSH BP
  MOV DX, DS
  MOV BP, SP
  MOV AX, [BP+10]
  MOV DS, AX
  MOV AX, [BP+08]
  MOV ES, AX
  MOV BX, [BP+06]
  XOR SI, SI
  XOR DI, DI
  XOR CX, CX
PcopyCLoop:
  MOV AL, [SI]
  OR  AL, AL
  JZ  SkipPcopyCPixel
  MOV AX, BX
  MOV ES:[DI], AL
SkipPcopyCPixel:
  INC SI
  INC DI
  INC CX
  CMP CX, 64000
  JNZ PcopyCLoop
  MOV DS, DX
  POP BP
  RET 6
CSPcopyC ENDP

CSWin PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+18]
  MOV ES, AX
  MOV CX, [BP+12]
  SUB CX, [BP+16]
  INC CX
  MOV WindowWidth, CX
  MOV SI, CX
  MOV DX, [BP+10]
  SUB DX, [BP+14]
  INC DX
  MOV WindowHeight, DX
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  MOV WindowPos1, DI
  MOV AL, [BP+08]
  MOV AH, AL
NextWindowLine:
  TEST DI, 1
  JZ  NoOddPixelWL
  MOV ES:[DI], AL
  INC DI
  DEC CX
  JLE SkipWindowLine
NoOddPixelWL:
  SHR CX, 1
  REP STOSW
  ADC CX, CX
  REP STOSB
SkipWindowLine:
  MOV CX, SI
  SUB DI, SI
  ADD DI, 320
  DEC DX
  JNZ NextWindowLine
  MOV CX, WindowWidth
  MOV DI, WindowPos1
  MOV AL, [BP+04]
  MOV AH, AL
  SHR CX, 1
  REP STOSW
  ADC CX, CX
  REP STOSB
  MOV CX, WindowHeight
  MOV DI, WindowPos1
  MOV AL, [BP+06]
NextWindowPixel:
  MOV ES:[DI], AL
  ADD DI, 320
  DEC CX
  JNZ NextWindowPixel
  MOV CX, WindowHeight
  DEC CX
  MOV DI, WindowPos1
  INC DI
  MOV AL, [BP+06]
NextWindowPixel2:
  MOV ES:[DI], AL
  ADD DI, 320
  DEC CX
  JNZ NextWindowPixel2
  MOV CX, WindowWidth
  MOV AX, [BP+10]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  MOV AL, [BP+06]
  MOV AH, AL
  SHR CX, 1
  REP STOSW
  ADC CX, CX
  REP STOSB
  MOV CX, WindowHeight
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+12]
  MOV WindowPos2, DI
  MOV AL, [BP+04]
NextWindowPixel3:
  MOV ES:[DI], AL
  ADD DI, 320
  DEC CX
  JNZ NextWindowPixel3
  MOV CX, WindowHeight
  MOV DI, WindowPos2
  DEC DI
  MOV AL, [BP+04]
NextWindowPixel4:
  MOV ES:[DI], AL
  ADD DI, 320
  DEC CX
  JNZ NextWindowPixel4
  MOV BP, BX
  RET 16
CSWin ENDP

CSAntiAliase PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DX, [BP+08]
  MOV CX, 64000
  MOV DS, DX
  XOR SI, SI
AntiAliaseLoop:
  XOR AX, AX
  XOR BX, BX
  XOR DX, DX
  MOV AL, [SI-1]
  MOV DL, [SI+1]
  ADD BX, AX
  MOV AL, [SI-320]
  ADD BX, DX
  MOV DL, [SI+1]
  ADD BX, AX
  MOV AL, [SI]
  ADD BX, DX
  SHR BX, 2
  ADD BX, AX
  SHR BX, 1
  MOV [SI], BL
  INC SI
  DEC CX
  JNZ AntiAliaseLoop
  POP DS
  POP BP
  RET 2
CSAntiAliase ENDP

CSTri PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+20]
  MOV BX, [BP+18]
  MOV CX, [BP+16]
  MOV DX, [BP+14]
  MOV SI, [BP+12]
  MOV DI, [BP+06]
  PUSH AX
  PUSH BX
  PUSH CX
  PUSH DX
  PUSH SI
  PUSH DI
  CALL CSLine
  MOV AX, [BP+20]
  MOV BX, [BP+14]
  MOV CX, [BP+12]
  MOV DX, [BP+10]
  MOV SI, [BP+08]
  MOV DI, [BP+06]
  PUSH AX
  PUSH BX
  PUSH CX
  PUSH DX
  PUSH SI
  PUSH DI
  CALL CSLine
  MOV AX, [BP+20]
  MOV BX, [BP+10]
  MOV CX, [BP+08]
  MOV DX, [BP+18]
  MOV SI, [BP+16]
  MOV DI, [BP+06]
  PUSH AX
  PUSH BX
  PUSH CX
  PUSH DX
  PUSH SI
  PUSH DI
  CALL CSLine
  POP BP
  RET 16
CSTri ENDP

CSCopyBlock PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+18]
  MOV BX, [BP+16]
  MOV DS, AX
  MOV ES, BX
  MOV CX, [BP+10]
  SUB CX, [BP+14]
  MOV DX, [BP+12]
  MOV BX, [BP+08]
  MOV AX, DX
  MOV SI, DX
  SHL AX, 8
  SHL SI, 6
  ADD SI, AX
  ADD SI, [BP+14]
  MOV DI, SI
  INC CX
  INC BX
  MOV AX, CX
CopyBlockLoop:
  SHR CX, 1
  REP MOVSW
  ADC CX, CX
  REP MOVSB
  MOV CX, AX
  ADD SI, 320
  ADD DI, 320
  SUB SI, AX
  SUB DI, AX
  INC DX
  CMP DX, BX
  JNE CopyBlockLoop
  POP DS
  POP BP
  RET 12
CSCopyBlock ENDP

END
