;----------------------------------------------------------------------------
;
;  CosmoX DISK Handling Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

DtaStruct STRUC
  Res       DB  21 dup(?)
  Attr      DB  ?
  FileTime  DW  ?
  FileData  DW  ?
  FileSize  DD  ?
  FileName  DB  13 dup(?)
  Res2      DB  85 dup(?)
DtaStruct ENDS

.DATA

ALIGN 2

DtaSeg              DW  ?               ;  Last Dta Segment
DtaOff              DW  ?               ;  Last Dta offset
OldInt24Off         DW  ?               ;  Original Int 24h offset
OldInt24Seg         DW  ?               ;  Original Int 24h segment
Dta                 DtaStruct <>        ;  DOS Dta structure
ErrorFlag           DB  0

.CODE

PUBLIC  xCSDrive, CSTotalDrives, CSFreeDiskSpc, CSTotalDiskSpc, xCSPath
PUBLIC  xCSFindFile, xCSChdir, xCSSetDrive

xCSDrive PROC
  PUSH BP
  MOV BP, SP
  MOV AX, 1900h
  INT 21h
  XOR AH, AH
  ADD AL, 41h
  POP BP
  RET
xCSDrive ENDP

CSTotalDrives PROC
  MOV AX, 1900h
  INT 21h
  XOR DH, DH
  MOV DL, AL
  MOV AX, 0E00h
  INT 21h
  MOV SI, AX
  XOR CX, CX
FindDrives:
  MOV AX, 440Eh
  MOV BX, CX
  INC BX
  INT 21h
  JC EndFindDrives
  INC CX
  CMP CX, SI
  JL  FindDrives
EndFindDrives:
  MOV AX, CX
  RET
CSTotalDrives ENDP

CSFreeDiskSpc PROC
  MOV SI, BP
  MOV BP, SP
  MOV DX, [BP+04]
  MOV AH, 36h
  INT 21h
  CMP AX, 0FFFFh
  JNE GiveFree
  MOV DX, AX
  MOV BP, SI
  RET 2
GiveFree:
  MUL BX
  MUL CX
  MOV BP, SI
  RET 2
CSFreeDiskSpc ENDP

CSTotalDiskSpc PROC
  MOV SI, BP
  MOV BP, SP
  MOV DX, [BP+04]
  MOV AH, 36h
  INT 21h
  CMP AX, 0FFFFh
  JNZ GiveTotal
  MOV DX, AX
  MOV BP, SI
  RET 2
GiveTotal:
  MUL DX
  MUL CX
  MOV BP, SI
  RET 2
CSTotalDiskSpc ENDP

xCSPath PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, 1900h
  INT 21h
  XOR DH, DH
  MOV DL, AL
  INC DL
  MOV DS, [BP+10]
  MOV SI, [BP+08]
  ADD AL, 41h
  MOV [SI], AL
  INC SI
  MOV AL, 3Ah
  MOV [SI], AL
  INC SI
  MOV AL, 5Ch
  MOV [SI], AL
  INC SI
  MOV AH, 47h
  INT 21h
  POP DS
  POP BP
  RET 4
xCSPath ENDP

xCSFindFile PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DS, [BP+16]
  MOV SI, [BP+14]
  MOV DL, [SI]
  OR  DL, DL
  JZ  FindNextFile
  MOV AX, SEG Dta
  MOV DS, AX
  MOV DX, OFFSET Dta
  MOV AX, 1A00h
  INT 21h
  MOV DS, [BP+16]
  MOV DX, [BP+14]
  MOV CX, [BP+12]
  MOV AX, 4E00h
  INT 21h
  JC  FileNotFound
  JMP StoreFile
FindNextFile:
  MOV AX, 4F00h
  INT 21h
  JC  FileNotFound
StoreFile:
  MOV AX, SEG Dta
  MOV DS, AX
  MOV SI, OFFSET Dta
  ADD SI, 30
  MOV ES, [BP+10]
  MOV DI, [BP+08]
  XOR CX, CX
StoreNextChar:
  MOV AL, [SI]
  OR  AL, AL
  JZ  EndStoreFile
  MOV ES:[DI], AL
  INC DI
  INC SI
  INC CX
  CMP CX, 13
  JNZ StoreNextChar
EndStoreFile:
  MOV AX, SEG Dta
  MOV ES, AX
  MOV DI, OFFSET Dta
  ADD DI, 30
  MOV AL, 20h
  MOV CX, 13
  REP STOSB
  POP DS
  POP BP
  RET 10
FileNotFound:
  MOV ES, [BP+10]
  MOV DI, [BP+08]
  XOR AX, AX
  STOSB
  POP DS
  POP BP
  RET 10
xCSFindFile ENDP

xCSChdir PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, 3B00h
  MOV DS, [BP+10]
  MOV DX, [BP+08]
  INT 21h
  JC  ErrorChdir
  XOR AX, AX
  POP DS
  POP BP
  RET 4
ErrorChdir:
  MOV AX, 0FFFFh
  POP DS
  POP BP
  RET 4
xCSChdir ENDP

xCSSetDrive PROC
  PUSH BP
  MOV BP, SP
  MOV AX, 0E00h
  MOV DL, [BP+06]
  INT 21h
  POP BP
  RET 2
xCSSetDrive ENDP

END
