;----------------------------------------------------------------------------
;
;  CosmoX 3D Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

EXTRN BMapActive  :  BYTE
EXTRN BMapSeg     :  WORD
EXTRN ClipX1      :  WORD
EXTRN ClipX2      :  WORD
EXTRN ClipY1      :  WORD
EXTRN ClipY2      :  WORD

.DATA

ALIGN 2

EndU                DW  200 dup(?)      ;  Used by Gouraud and Texture
EndV                DW  200 dup(?)      ;  Used by Gouraud and Texture
EndX                DW  200 dup(?)      ;  Last X in scanline
StartU              DW  200 dup(?)      ;  Used by Goraud and Texture
StartV              DW  200 dup(?)      ;  Used by Goraud and Texture
StartX              DW  200 dup(?)      ;  First X in scanline
FirstY              DW  ?               ;  First ScanLine
LastY               DW  ?               ;  Last ScanLine
TextureWrap         DW  63              ;  Used to wrap the texture
TextureAdd          DW  4               ;  Used to skip GET-PUT header
Counter             DW  ?               ;  Used in texture-mapping subs
TextureSize         DB  6               ;  Texture size (in bits to shift)

.CODE

PUBLIC  CSTriF, CSTriFB, CSTriG, CSTriGB, CSTriT, CSTriTB, CSTextureWidth
PUBLIC  CSTriTF

CSTriF PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+20]
  MOV ES, AX
  MOV AX, [BP+16]
  MOV BX, [BP+12]
  CMP AX, BX
  JLE Swap12
  MOV [BP+16], BX
  MOV [BP+12], AX
  MOV BX, [BP+14]
  MOV AX, [BP+18]
  MOV [BP+18], BX
  MOV [BP+14], AX
Swap12:
  MOV AX, [BP+16]
  MOV BX, [BP+08]
  CMP AX, BX
  JLE Swap13
  MOV [BP+16], BX
  MOV [BP+08], AX
  MOV BX, [BP+10]
  MOV AX, [BP+18]
  MOV [BP+18], BX
  MOV [BP+10], AX
Swap13:
  MOV AX, [BP+12]
  MOV BX, [BP+08]
  CMP AX, BX
  JLE EndSwaps1
  MOV [BP+12], BX
  MOV [BP+08], AX
  MOV BX, [BP+10]
  MOV AX, [BP+14]
  MOV [BP+14], BX
  MOV [BP+10], AX
EndSwaps1:
  MOV AX, 8000h
  XOR SI, SI
InitTriFX:
  MOV StartX[SI], AX
  ADD SI, 2
  CMP SI, 400
  JL  InitTriFX
  MOV AX, ClipY1
  MOV FirstY, AX
  MOV BX, [BP+16]
  CMP BX, ClipY2
  JG  EndDrawTriF
  CMP BX, AX
  JL  ClipFY
  MOV FirstY, BX
ClipFY:
  MOV AX, ClipY2
  MOV LastY, AX
  MOV BX, [BP+08]
  CMP BX, ClipY1
  JL  EndDrawTriF
  CMP BX, AX
  JG  ClipLY
  MOV LastY, BX
ClipLY:
  XOR ECX, ECX
  MOV BX, [BP+16]
  MOV CX, [BP+12]
  SUB CX, BX
  JNZ Connect11
  CMP BX, ClipY1
  JL  End11
  CMP BX, ClipY2
  JG  End11
  SHL BX, 1
  MOV AX, [BP+18]
  MOV StartX[BX], AX
  JMP End11
Connect11:
  MOV AX, [BP+14]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+18]
  SHL EDX, 16
  MOV BX, [BP+16]
Next11:
  CMP BX, ClipY1
  JL  Skip11
  CMP BX, ClipY2
  JG  Skip11
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
Skip11:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+12]
  JLE Next11
End11:
  XOR ECX, ECX
  MOV BX, [BP+12]
  MOV CX, [BP+08]
  SUB CX, BX
  JNZ Connect12
  CMP BX, ClipY1
  JL  End12
  CMP BX, ClipY2
  JG  End12
  SHL BX, 1
  MOV AX, [BP+14]
  MOV StartX[BX], AX
  JMP End12
Connect12:
  MOV AX, [BP+10]
  SUB AX, [BP+14]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+14]
  SHL EDX, 16
  MOV BX, [BP+12]
Next12:
  CMP BX, ClipY1
  JL  Skip12
  CMP BX, ClipY2
  JG  Skip12
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
Skip12:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE Next12
End12:
  XOR ECX, ECX
  MOV BX, [BP+16]
  MOV CX, [BP+08]
  SUB CX, BX
  JNZ Connect13
  CMP BX, ClipY1
  JL  End13
  CMP BX, ClipY2
  JG  End13
  SHL BX, 1
  MOV AX, [BP+18]
  MOV EndX[BX], AX
  MOV DX, StartX[BX]
  CMP DX, AX
  JL  End13
  MOV StartX[BX], AX
  MOV EndX[BX], DX
  JMP End13
Connect13:
  MOV AX, [BP+10]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+18]
  SHL EDX, 16
  MOV BX, [BP+16]
Next13:
  CMP BX, ClipY1
  JL  Skip13
  CMP BX, ClipY2
  JG  Skip13
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndX[SI], CX
  MOV DI, StartX[SI]
  CMP DI, CX
  JL  Skip13
  MOV StartX[SI], CX
  MOV EndX[SI], DI
Skip13:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE Next13
End13:
  MOV CX, FirstY
  MOV AX, [BP+06]
  MOV AH, AL
  MOV BX, AX
  SHL EAX, 16
  MOV AX, BX
  MOV DI, CX
  MOV BX, DI
  SHL BX, 8
  SHL DI, 6
  ADD DI, BX
DrawTriF:
  MOV SI, CX
  SHL SI, 1
  MOV BX, StartX[SI]
  CMP BX, 8000h
  JE  SkipTriFLine
DrawTriFLine:
  PUSH CX
  PUSH DI
  MOV CX, EndX[SI]
  CMP BX, ClipX1
  JGE SkipClipX1
  MOV BX, ClipX1
SkipClipX1:
  CMP BX, ClipX2
  JG  SkipTriFLinePop
  CMP CX, ClipX1
  JL  SkipTriFLinePop
  CMP CX, ClipX2
  JLE SkipClipX2
  MOV CX, ClipX2
SkipClipX2:
  SUB CX, BX
  ADD DI, BX
FixAddressLoopF:
  TEST DI, 3
  JZ  NoOddPixelsF
  MOV ES:[DI], AL
  INC DI
  DEC CX
  JG  FixAddressLoopF
NoOddPixelsF:
  OR  CX, CX
  JS  SkipTriFLinePop
  MOV BX, CX
  SHR CX, 2
  REP STOSD
  MOV CX, BX
  AND CX, 3
  SHR CX, 1
  REP STOSW
  ADC CX, CX
  REP STOSB
SkipTriFLinePop:
  POP DI
  POP CX
SkipTriFLine:
  ADD DI, 320
  INC CX
  CMP CX, LastY
  JLE DrawTriF
EndDrawTriF:
  POP BP
  RET 16
CSTriF ENDP

CSTriFB PROC
  PUSH BP
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL,  DL
  JE  EndTriFB
  MOV AX, [BP+20]
  MOV ES, AX
  MOV AX, [BP+16]
  MOV BX, [BP+12]
  CMP AX, BX
  JLE BSwap12
  MOV [BP+16], BX
  MOV [BP+12], AX
  MOV BX, [BP+14]
  MOV AX, [BP+18]
  MOV [BP+18], BX
  MOV [BP+14], AX
BSwap12:
  MOV AX, [BP+16]
  MOV BX, [BP+08]
  CMP AX, BX
  JLE BSwap13
  MOV [BP+16], BX
  MOV [BP+08], AX
  MOV BX, [BP+10]
  MOV AX, [BP+18]
  MOV [BP+18], BX
  MOV [BP+10], AX
BSwap13:
  MOV AX, [BP+12]
  MOV BX, [BP+08]
  CMP AX, BX
  JLE BEndSwaps1
  MOV [BP+12], BX
  MOV [BP+08], AX
  MOV BX, [BP+10]
  MOV AX, [BP+14]
  MOV [BP+14], BX
  MOV [BP+10], AX
BEndSwaps1:
  MOV AX, 8000h
  XOR SI, SI
BInitTriFX:
  MOV StartX[SI], AX
  ADD SI, 2
  CMP SI, 400
  JL  BInitTriFX
  MOV AX, ClipY1
  MOV FirstY, AX
  MOV BX, [BP+16]
  CMP BX, ClipY2
  JG  EndTriFB
  CMP BX, AX
  JL  BClipFY
  MOV FirstY, BX
BClipFY:
  MOV AX, ClipY2
  MOV LastY, AX
  MOV BX, [BP+08]
  CMP BX, ClipY1
  JL  EndTriFB
  CMP BX, AX
  JG  BClipLY
  MOV LastY, BX
BClipLY:
  XOR ECX, ECX
  MOV BX, [BP+16]
  MOV CX, [BP+12]
  SUB CX, BX
  JNZ BConnect11
  CMP BX, ClipY1
  JL  BEnd11
  CMP BX, ClipY2
  JG  BEnd11
  SHL BX, 1
  MOV AX, [BP+18]
  MOV StartX[BX], AX
  JMP BEnd11
BConnect11:
  MOV AX, [BP+14]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+18]
  SHL EDX, 16
  MOV BX, [BP+16]
BNext11:
  CMP BX, ClipY1
  JL  BSkip11
  CMP BX, ClipY2
  JG  BSkip11
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
BSkip11:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+12]
  JLE BNext11
BEnd11:
  XOR ECX, ECX
  MOV BX, [BP+12]
  MOV CX, [BP+08]
  SUB CX, BX
  JNZ BConnect12
  CMP BX, ClipY1
  JL  BEnd12
  CMP BX, ClipY2
  JG  BEnd12
  SHL BX, 1
  MOV AX, [BP+14]
  MOV StartX[BX], AX
  JMP BEnd12
BConnect12:
  MOV AX, [BP+10]
  SUB AX, [BP+14]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+14]
  SHL EDX, 16
  MOV BX, [BP+12]
BNext12:
  CMP BX, ClipY1
  JL  BSkip12
  CMP BX, ClipY2
  JG  BSkip12
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
BSkip12:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE BNext12
BEnd12:
  XOR ECX, ECX
  MOV BX, [BP+16]
  MOV CX, [BP+08]
  SUB CX, BX
  JNZ BConnect13
  CMP BX, ClipY1
  JL  BEnd13
  CMP BX, ClipY2
  JG  BEnd13
  SHL BX, 1
  MOV AX, [BP+18]
  MOV EndX[BX], AX
  MOV DX, StartX[BX]
  CMP DX, AX
  JL  BEnd13
  MOV StartX[BX], AX
  MOV EndX[BX], DX
  JMP BEnd13
BConnect13:
  MOV AX, [BP+10]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+18]
  SHL EDX, 16
  MOV BX, [BP+16]
BNext13:
  CMP BX, ClipY1
  JL  BSkip13
  CMP BX, ClipY2
  JG  BSkip13
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndX[SI], CX
  MOV DI, StartX[SI]
  CMP DI, CX
  JL  BSkip13
  MOV StartX[SI], CX
  MOV EndX[SI], DI
BSkip13:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE BNext13
BEnd13:
  MOV AX, BMapSeg
  MOV FS, AX
  MOV CX, FirstY
  MOV AX, [BP+6]
  MOV DH, AL
  MOV DI, CX
  MOV BX, DI
  SHL BX, 8
  SHL DI, 6
  ADD DI, BX
BDrawTriF:
  MOV SI, CX
  SHL SI, 1
  MOV BX, StartX[SI]
  CMP BX, 8000h
  JE  BSkipTriFLine
BDrawTriFLine:
  CMP BX, ClipX1
  JL  BSkipTriFPixel
  CMP BX, ClipX2
  JG  BSkipTriFPixel
  MOV DL, ES:[DI+BX]
  MOV BP, BX
  MOV BX, DX
  MOV AL, FS:[BX]
  MOV BX, BP
  MOV ES:[DI+BX], AL
BSkipTriFPixel:
  INC BX
  CMP BX, EndX[SI]
  JLE BDrawTriFLine
BSkipTriFLine:
  ADD DI, 320
  INC CX
  CMP CX, LastY
  JLE BDrawTriF
EndTriFB:
  POP BP
  RET 16
CSTriFB ENDP

CSTriG PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+24]
  MOV ES, AX
  MOV AX, [BP+20]
  MOV BX, [BP+14]
  CMP AX, BX
  JLE NoSwap12G
  MOV [BP+14], AX
  MOV [BP+20], BX
  MOV AX, [BP+22]
  MOV BX, [BP+16]
  MOV [BP+16], AX
  MOV [BP+22], BX
  MOV AX, [BP+18]
  MOV BX, [BP+12]
  MOV [BP+12], AX
  MOV [BP+18], BX
NoSwap12G:
  MOV AX, [BP+20]
  MOV BX, [BP+08]
  CMP AX, BX
  JLE NoSwap13G
  MOV [BP+08], AX
  MOV [BP+20], BX
  MOV AX, [BP+22]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+22], BX
  MOV AX, [BP+18]
  MOV BX, [BP+06]
  MOV [BP+06], AX
  MOV [BP+18], BX
NoSwap13G:
  MOV AX, [BP+14]
  MOV BX, [BP+08]
  CMP AX, BX
  JLE EndSwapsG
  MOV [BP+08], AX
  MOV [BP+14], BX
  MOV AX, [BP+16]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+16], BX
  MOV AX, [BP+12]
  MOV BX, [BP+6]
  MOV [BP+06], AX
  MOV [BP+12], BX
EndSwapsG:
  MOV AX, 8000h
  XOR SI, SI
InitTriGX:
  MOV StartX[SI], AX
  ADD SI, 2
  CMP SI, 400
  JL  InitTriGX
  MOV AX, ClipY1
  MOV FirstY, AX
  MOV BX, [BP+20]
  CMP BX, ClipY2
  JG  EndDrawTriG
  CMP BX, AX
  JL  ClipFYG
  MOV FirstY, BX
ClipFYG:
  MOV AX, ClipY2
  MOV LastY, AX
  MOV BX, [BP+08]
  CMP BX, ClipY1
  JL  EndDrawTriG
  CMP BX, AX
  JG  ClipLYG
  MOV LastY, BX
ClipLYG:
  XOR ECX, ECX
  MOV BX, [BP+20]
  MOV CX, [BP+14]
  SUB CX, BX
  JNZ Connect11G
  CMP BX, ClipY1
  JL  End11G
  CMP BX, ClipY2
  JG  End11G
  SHL BX, 1
  MOV AX, [BP+22]
  MOV StartX[BX], AX
  MOV AX, [BP+18]
  MOV StartU[BX], AX
  JMP End11G
Connect11G:
  PUSH ECX
  MOV AX, [BP+12]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+18]
  SHL EDX, 16
  MOV BX, [BP+20]
Col1Step1G:
  CMP BX, 0
  JL  Col1Next1G
  CMP BX, 199
  JG  Col1Next1G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartU[SI], CX
Col1Next1G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+14]
  JLE Col1Step1G
  POP ECX
  MOV AX, [BP+16]
  SUB AX, [BP+22]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+22]
  SHL EDX, 16
  MOV BX, [BP+20]
Col1Step2G:
  CMP BX, ClipY1
  JL  Col1Next2G
  CMP BX, ClipY2
  JG  Col1Next2G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
Col1Next2G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+14]
  JLE Col1Step2G
End11G:
  XOR ECX, ECX
  MOV BX, [BP+14]
  MOV CX, [BP+08]
  SUB CX, BX
  JNZ Connect12G
  CMP BX, ClipY1
  JL  End12G
  CMP BX, ClipY2
  JG  End12G
  SHL BX, 1
  MOV AX, [BP+16]
  MOV StartX[BX], AX
  MOV AX, [BP+12]
  MOV StartU[BX], AX
  JMP End12G
Connect12G:
  PUSH ECX
  MOV AX, [BP+06]
  SUB AX, [BP+12]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+12]
  SHL EDX, 16
  MOV BX, [BP+14]
Col2Step1G:
  CMP BX, 0
  JL  Col2Next1G
  CMP BX, 199
  JG  Col2Next1G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartU[SI], CX
Col2Next1G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE Col2Step1G
  POP ECX
  MOV AX, [BP+10]
  SUB AX, [BP+16]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+16]
  SHL EDX, 16
  MOV BX, [BP+14]
Col2Step2G:
  CMP BX, ClipY1
  JL  Col2Next2G
  CMP BX, ClipY2
  JG  Col2Next2G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
Col2Next2G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE Col2Step2G
End12G:
  XOR ECX, ECX
  MOV BX, [BP+20]
  MOV CX, [BP+08]
  SUB CX, BX
  JNZ Connect13G
  CMP BX, ClipY1
  JL  End13G
  CMP BX, ClipY2
  JG  End13G
  SHL BX, 1
  MOV AX, [BP+18]
  MOV EndU[BX], AX
  MOV AX, [BP+22]
  MOV EndX[BX], AX
  MOV DI, StartX[BX]
  CMP DI, AX
  JL  End13G
  MOV EndX[BX], DI
  MOV StartX[BX], AX
  MOV DI, StartU[BX]
  MOV AX, EndU[BX]
  MOV StartU[BX], AX
  MOV EndU[BX], DI
  JMP End13G
Connect13G:
  PUSH ECX
  MOV AX, [BP+06]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+18]
  SHL EDX, 16
  MOV BX, [BP+20]
Col3Step1G:
  CMP BX, 0
  JL  Col3Next1G
  CMP BX, 199
  JG  Col3Next1G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndU[SI], CX
Col3Next1G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE Col3Step1G
  POP ECX
  MOV AX, [BP+10]
  SUB AX, [BP+22]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+22]
  SHL EDX, 16
  MOV BX, [BP+20]
Col3Step2G:
  CMP BX, ClipY1
  JL  Col3Next2G
  CMP BX, ClipY2
  JG  Col3Next2G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndX[SI], CX
  MOV DI, StartX[SI]
  CMP DI, CX
  JL  Col3Next2G
  MOV StartX[SI], CX
  MOV EndX[SI], DI
  MOV CX, StartU[SI]
  MOV DI, EndU[SI]
  MOV StartU[SI], DI
  MOV EndU[SI], CX
Col3Next2G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE Col3Step2G
End13G:
  MOV CX, FirstY
  MOV DI, CX
  MOV BX, DI
  SHL BX, 8
  SHL DI, 6
  ADD DI, BX
DrawGTri:
  MOV SI, CX
  SHL SI, 1
  MOV BX, StartX[SI]
  CMP BX, 8000h
  JE  SkipTriGLine
  PUSH DI
  PUSH CX
  XOR ECX, ECX
  MOV CX, EndX[SI]
  SUB CX, StartX[SI]
  INC CX
  MOV AX, EndU[SI]
  SUB AX, StartU[SI]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, StartU[SI]
  SHL EDX, 16
DrawTriGLine:
  MOV BX, StartX[SI]
  MOV BP, EndX[SI]
  CMP BP, ClipX1
  JL  SkipTriGLinePop
  CMP BP, ClipX2
  JLE NoClipX2G
  MOV BP, ClipX2
NoClipX2G:
  CMP BX, ClipX2
  JG  SkipTriGLinePop
  CMP BX, ClipX1
  JGE NoClipX1G
ClipX1LoopG:
  INC BX
  ADD EDX, EAX
  CMP BX, ClipX1
  JL  ClipX1LoopG
NoClipX1G:
  ADD DI, BX
  SUB BP, BX
  JZ  SkipTriGLinePop
  MOV BX, BP
FixAddressLoopG:
  TEST DI, 3
  JZ  NoOddPixelsG
  MOV ECX, EDX
  SHR ECX, 16
  ADD EDX, EAX
  MOV ES:[DI], CL
  INC DI
  DEC BP
  JG  FixAddressLoopG
NoOddPixelsG:
  MOV BX, BP
  SHR BP, 2
  JZ  DrawLeftPixelsG
  PUSH BX
Draw4PixelsLoopG:
  MOV ECX, EDX
  SHR ECX, 16
  ADD EDX, EAX
  MOV BL, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD EDX, EAX
  MOV BH, CL
  SHL EBX, 16
  MOV ECX, EDX
  SHR ECX, 16
  ADD EDX, EAX
  MOV BL, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD EDX, EAX
  MOV BH, CL
  ROL EBX, 16
  MOV ES:[DI], EBX
  ADD DI, 4
  DEC BP
  JNZ Draw4PixelsLoopG
  POP BX
DrawLeftPixelsG:
  MOV BP, BX
  AND BP, 3
  JZ  SkipTriGLinePop
LeftPixelsLoopG:
  MOV ECX, EDX
  SHR ECX, 16
  ADD EDX, EAX
  MOV ES:[DI], CL
  INC DI
  DEC BP
  JNZ LeftPixelsLoopG
SkipTriGLinePop:
  POP CX
  POP DI
SkipTriGLine:
  ADD DI, 320
  INC CX
  CMP CX, LastY
  JLE DrawGTri
EndDrawTriG:
  POP BP
  RET 20
CSTriG ENDP

CSTriGB PROC
  PUSH BP
  MOV BP, SP
  PUSH AX
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndTriGB
  MOV AX, [BP+24]
  MOV ES, AX
  MOV AX, [BP+20]
  MOV BX, [BP+14]
  CMP AX, BX
  JLE BNoSwap12G
  MOV [BP+14], AX
  MOV [BP+20], BX
  MOV AX, [BP+22]
  MOV BX, [BP+16]
  MOV [BP+16], AX
  MOV [BP+22], BX
  MOV AX, [BP+18]
  MOV BX, [BP+12]
  MOV [BP+12], AX
  MOV [BP+18], BX
BNoSwap12G:
  MOV AX, [BP+20]
  MOV BX, [BP+08]
  CMP AX, BX
  JLE BNoSwap13G
  MOV [BP+08], AX
  MOV [BP+20], BX
  MOV AX, [BP+22]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+22], BX
  MOV AX, [BP+18]
  MOV BX, [BP+06]
  MOV [BP+06], AX
  MOV [BP+18], BX
BNoSwap13G:
  MOV AX, [BP+14]
  MOV BX, [BP+08]
  CMP AX, BX
  JLE BEndSwapsG
  MOV [BP+08], AX
  MOV [BP+14], BX
  MOV AX, [BP+16]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+16], BX
  MOV AX, [BP+12]
  MOV BX, [BP+06]
  MOV [BP+06], AX
  MOV [BP+12], BX
BEndSwapsG:
  MOV AX, 8000h
  XOR SI, SI
BInitTriGX:
  MOV StartX[SI], AX
  ADD SI, 2
  CMP SI, 400
  JL  BInitTriGX
  MOV AX, ClipY1
  MOV FirstY, AX
  MOV BX, [BP+20]
  CMP BX, ClipY2
  JG  EndTriGB
  CMP BX, AX
  JL  BClipFYG
  MOV FirstY, BX
BClipFYG:
  MOV AX, ClipY2
  MOV LastY, AX
  MOV BX, [BP+08]
  CMP BX, ClipY1
  JL  EndTriGB
  CMP BX, AX
  JG  BClipLYG
  MOV LastY, BX
BClipLYG:
  XOR ECX, ECX
  MOV BX, [BP+20]
  MOV CX, [BP+14]
  SUB CX, BX
  JNZ BConnect11G
  CMP BX, ClipY1
  JL  BEnd11G
  CMP BX, ClipY2
  JG  BEnd11G
  SHL BX, 1
  MOV AX, [BP+22]
  MOV StartX[BX], AX
  MOV AX, [BP+18]
  MOV StartU[BX], AX
  JMP BEnd11G
BConnect11G:
  PUSH ECX
  MOV AX, [BP+12]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+18]
  SHL EDX, 16
  MOV BX, [BP+20]
BCol1Step1G:
  CMP BX, 0
  JL  BCol1Next1G
  CMP BX, 199
  JG  BCol1Next1G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartU[SI], CX
BCol1Next1G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+14]
  JLE BCol1Step1G
  POP ECX
  MOV AX, [BP+16]
  SUB AX, [BP+22]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+22]
  SHL EDX, 16
  MOV BX, [BP+20]
BCol1Step2G:
  CMP BX, ClipY1
  JL  BCol1Next2G
  CMP BX, ClipY2
  JG  BCol1Next2G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
BCol1Next2G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+14]
  JLE BCol1Step2G
BEnd11G:
  XOR ECX, ECX
  MOV BX, [BP+14]
  MOV CX, [BP+08]
  SUB CX, BX
  JNZ BConnect12G
  CMP BX, ClipY1
  JL  BEnd12G
  CMP BX, ClipY2
  JG  BEnd12G
  SHL BX, 1
  MOV AX, [BP+16]
  MOV StartX[BX], AX
  MOV AX, [BP+12]
  MOV StartU[BX], AX
  JMP BEnd12G
BConnect12G:
  PUSH ECX
  MOV AX, [BP+06]
  SUB AX, [BP+12]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+12]
  SHL EDX, 16
  MOV BX, [BP+14]
BCol2Step1G:
  CMP BX, 0
  JL  BCol2Next1G
  CMP BX, 199
  JG  BCol2Next1G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartU[SI], CX
BCol2Next1G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE BCol2Step1G
  POP ECX
  MOV AX, [BP+10]
  SUB AX, [BP+16]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+16]
  SHL EDX, 16
  MOV BX, [BP+14]
BCol2Step2G:
  CMP BX, ClipY1
  JL  BCol2Next2G
  CMP BX, ClipY2
  JG  BCol2Next2G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
BCol2Next2G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE BCol2Step2G
BEnd12G:
  XOR ECX, ECX
  MOV BX, [BP+20]
  MOV CX, [BP+08]
  SUB CX, BX
  JNZ BConnect13G
  CMP BX, ClipY1
  JL  BEnd13G
  CMP BX, ClipY2
  JG  BEnd13G
  SHL BX, 1
  MOV AX, [BP+18]
  MOV EndU[BX], AX
  MOV AX, [BP+22]
  MOV EndX[BX], AX
  MOV DI, StartX[BX]
  CMP DI, AX
  JL  BEnd13G
  MOV EndX[BX], DI
  MOV StartX[BX], AX
  MOV DI, StartU[BX]
  MOV AX, EndU[BX]
  MOV StartU[BX], AX
  MOV EndU[BX], DI
  JMP BEnd13G
BConnect13G:
  PUSH ECX
  MOV AX, [BP+06]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+18]
  SHL EDX, 16
  MOV BX, [BP+20]
BCol3Step1G:
  CMP BX, 0
  JL  BCol3Next1G
  CMP BX, 199
  JG  BCol3Next1G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndU[SI], CX
BCol3Next1G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE BCol3Step1G
  POP ECX
  MOV AX, [BP+10]
  SUB AX, [BP+22]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+22]
  SHL EDX, 16
  MOV BX, [BP+20]
BCol3Step2G:
  CMP BX, ClipY1
  JL  BCol3Next2G
  CMP BX, ClipY2
  JG  BCol3Next2G
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndX[SI], CX
  MOV DI, StartX[SI]
  CMP DI, CX
  JL  BCol3Next2G
  MOV StartX[SI], CX
  MOV EndX[SI], DI
  MOV CX, StartU[SI]
  MOV DI, EndU[SI]
  MOV StartU[SI], DI
  MOV EndU[SI], CX
BCol3Next2G:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+08]
  JLE BCol3Step2G
BEnd13G:
  MOV AX, BMapSeg
  MOV GS, AX
  MOV CX, FirstY
  MOV DI, CX
  MOV BX, DI
  SHL BX, 8
  SHL DI, 6
  ADD DI, BX
BDrawGTri:
  MOV SI, CX
  SHL SI, 1
  MOV BX, StartX[SI]
  CMP BX, 8000h
  JE  BSkipTriGLine
  MOV FS, CX
  XOR ECX, ECX
  MOV CX, EndX[SI]
  SUB CX, StartX[SI]
  INC CX
  MOV AX, EndU[SI]
  SUB AX, StartU[SI]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, StartU[SI]
  SHL EDX, 16
BDrawTriGLine:
  CMP BX, ClipX1
  JL  BSkipTriGPixel
  CMP BX, ClipX2
  JG  BSkipTriGPixel
  MOV ECX, EDX
  SHR ECX, 16
  MOV CH, ES:[DI+BX]
  MOV [BP-02], BX
  MOV BH, CL
  MOV BL, CH
  MOV CL, GS:[BX]
  MOV BX, [BP-02]
  MOV ES:[DI+BX], CL
BSkipTriGPixel:
  ADD EDX, EAX
  INC BX
  CMP BX, EndX[SI]
  JLE BDrawTriGLine
  MOV CX, FS
BSkipTriGLine:
  ADD DI, 320
  INC CX
  CMP CX, LastY
  JLE BDrawGTri
EndTriGB:
  POP AX
  POP BP
  RET 20
CSTriGB ENDP

CSTriT PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+34]
  MOV ES, AX
  MOV AX, [BP+30]
  MOV BX, [BP+26]
  CMP AX, BX
  JLE SwapT1
  MOV [BP+26], AX
  MOV [BP+30], BX
  MOV AX, [BP+32]
  MOV BX, [BP+28]
  MOV [BP+28], AX
  MOV [BP+32], BX
  MOV AX, [BP+20]
  MOV BX, [BP+16]
  MOV [BP+16], AX
  MOV [BP+20], BX
  MOV AX, [BP+18]
  MOV BX, [BP+14]
  MOV [BP+14], AX
  MOV [BP+18], BX
SwapT1:
  MOV AX, [BP+30]
  MOV BX, [BP+22]
  CMP AX, BX
  JLE SwapT2
  MOV [BP+22], AX
  MOV [BP+30], BX
  MOV AX, [BP+32]
  MOV BX, [BP+24]
  MOV [BP+24], AX
  MOV [BP+32], BX
  MOV AX, [BP+20]
  MOV BX, [BP+12]
  MOV [BP+12], AX
  MOV [BP+20], BX
  MOV AX, [BP+18]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+18], BX
SwapT2:
  MOV AX, [BP+26]
  MOV BX, [BP+22]
  CMP AX, BX
  JLE EndSwapsT
  MOV [BP+22], AX
  MOV [BP+26], BX
  MOV AX, [BP+28]
  MOV BX, [BP+24]
  MOV [BP+24], AX
  MOV [BP+28], BX
  MOV AX, [BP+16]
  MOV BX, [BP+12]
  MOV [BP+12], AX
  MOV [BP+16], BX
  MOV AX, [BP+14]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+14], BX
EndSwapsT:
  XOR SI, SI
  MOV AX, 8000h
InitTriTX:
  MOV StartX[SI], AX
  ADD SI, 2
  CMP SI, 400
  JL  InitTriTX
  MOV AX, ClipY1
  MOV FirstY, AX
  MOV BX, [BP+30]
  CMP BX, ClipY2
  JG  EndDrawTriT
  CMP BX, AX
  JL  ClipFYT
  MOV FirstY, BX
ClipFYT:
  MOV AX, ClipY2
  MOV LastY, AX
  MOV BX, [BP+22]
  CMP BX, ClipY1
  JL  EndDrawTriT
  CMP BX, AX
  JG  ClipLYT
  MOV LastY, BX
ClipLYT:
  XOR ECX, ECX
  MOV BX, [BP+30]
  MOV CX, [BP+26]
  SUB CX, BX
  JNZ ConnectT1
  CMP BX, ClipY1
  JL  EndT1
  CMP BX, ClipY2
  JG  EndT1
  SHL BX, 1
  MOV AX, [BP+32]
  MOV StartX[BX], AX
  MOV AX, [BP+20]
  MOV StartU[BX], AX
  MOV AX, [BP+18]
  MOV StartV[BX], AX
  JMP EndT1
ConnectT1:
  PUSH ECX
  MOV AX, [BP+16]
  SUB AX, [BP+20]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+14]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+20]
  SHL EDX, 16
  MOV CX, [BP+18]
  SHL ECX, 16
  MOV SI, [BP+30]
StepT11:
  CMP SI, 0
  JL  NextT11
  CMP SI, 199
  JG  NextT11
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV StartU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV StartV[SI], DI
  SHR SI, 1
NextT11:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+26]
  JLE StepT11
  POP ECX
  MOV AX, [BP+28]
  SUB AX, [BP+32]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+32]
  SHL EDX, 16
  MOV BX, [BP+30]
StepT12:
  CMP BX, ClipY1
  JL  NextT12
  CMP BX, ClipY2
  JG  NextT12
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
NextT12:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+26]
  JLE StepT12
EndT1:
  XOR ECX, ECX
  MOV BX, [BP+26]
  MOV CX, [BP+22]
  SUB CX, BX
  JNZ ConnectT2
  CMP BX, ClipY1
  JL  EndT2
  CMP BX, ClipY2
  JG  EndT2
  SHL BX, 1
  MOV AX, [BP+28]
  MOV StartX[BX], AX
  MOV AX, [BP+16]
  MOV StartU[BX], AX
  MOV AX, [BP+14]
  MOV StartV[BX], AX
  JMP EndT2
ConnectT2:
  PUSH ECX
  MOV AX, [BP+12]
  SUB AX, [BP+16]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+10]
  SUB AX, [BP+14]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+16]
  SHL EDX, 16
  MOV CX, [BP+14]
  SHL ECX, 16
  MOV SI, [BP+26]
StepT21:
  CMP SI, 0
  JL  NextT21
  CMP SI, 199
  JG  NextT21
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV StartU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV StartV[SI], DI
  SHR SI, 1
NextT21:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+22]
  JLE StepT21
  POP ECX
  MOV AX, [BP+24]
  SUB AX, [BP+28]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+28]
  SHL EDX, 16
  MOV BX, [BP+26]
StepT22:
  CMP BX, ClipY1
  JL  NextT22
  CMP BX, ClipY2
  JG  NextT22
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
NextT22:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+22]
  JLE StepT22
EndT2:
  XOR ECX, ECX
  MOV BX, [BP+30]
  MOV CX, [BP+22]
  SUB CX, BX
  JNZ ConnectT3
  CMP BX, ClipY1
  JL  EndT3
  CMP BX, ClipY2
  JG  EndT3
  SHL BX, 1
  MOV AX, [BP+20]
  MOV EndU[BX], AX
  MOV AX, [BP+18]
  MOV EndV[BX], AX
  MOV AX, [BP+32]
  MOV EndX[BX], AX
  MOV DX, StartX[BX]
  CMP DX, AX
  JL  EndT3
  MOV StartX[BX], AX
  MOV EndX[BX], DX
  MOV AX, StartU[BX]
  MOV DX, EndU[BX]
  MOV StartU[BX], DX
  MOV EndU[BX], AX
  MOV AX, StartV[BX]
  MOV DX, EndV[BX]
  MOV StartV[BX], DX
  MOV EndV[BX], AX
  JMP EndT3
ConnectT3:
  PUSH ECX
  MOV AX, [BP+12]
  SUB AX, [BP+20]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+10]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+20]
  SHL EDX, 16
  MOV CX, [BP+18]
  SHL ECX, 16
  MOV SI, [BP+30]
StepT31:
  CMP SI, 0
  JL  NextT31
  CMP SI, 199
  JG  NextT31
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV EndU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV EndV[SI], DI
  SHR SI, 1
NextT31:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+22]
  JLE StepT31
  POP ECX
  MOV AX, [BP+24]
  SUB AX, [BP+32]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+32]
  SHL EDX, 16
  MOV BX, [BP+30]
StepT32:
  CMP BX, ClipY1
  JL  NextT32
  CMP BX, ClipY2
  JG  NextT32
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndX[SI], CX
  MOV DI, StartX[SI]
  CMP DI, CX
  JL  NextT32
  MOV StartX[SI], CX
  MOV EndX[SI], DI
  MOV CX, StartU[SI]
  MOV DI, EndU[SI]
  MOV StartU[SI], DI
  MOV EndU[SI], CX
  MOV CX, StartV[SI]
  MOV DI, EndV[SI]
  MOV StartV[SI], DI
  MOV EndV[SI], CX
NextT32:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+22]
  JLE StepT32
EndT3:
  MOV AX, [BP+08]
  MOV GS, AX
  MOV CX, FirstY
  MOV DI, CX
  MOV SI, CX
  SHL DI, 8
  SHL SI, 6
  ADD DI, SI
DrawTriT:
  MOV SI, CX
  SHL SI, 1
  MOV BX, StartX[SI]
  CMP BX, 8000h
  JE  SkipTriLineT
  PUSH CX
  PUSH DI
  XOR ECX, ECX
  MOV CX, EndX[SI]
  SUB CX, BX
  INC CX
  MOV AX, EndU[SI]
  SUB AX, StartU[SI]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  PUSH EAX
  MOV AX, EndV[SI]
  SUB AX, StartV[SI]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  PUSH EAX
  PUSH AX
  MOV BP, SP
  MOV DX, StartU[SI]
  MOV AX, StartV[SI]
  SHL EDX, 16
  SHL EAX, 16
DrawTriLineT:
  MOV BX, StartX[SI]
  MOV CX, EndX[SI]
  CMP CX, ClipX1
  JL  SkipTriLineTPop
  CMP CX, ClipX2
  JLE NoClipX2T
  MOV CX, ClipX2
NoClipX2T:
  CMP BX, ClipX2
  JG  SkipTriLineTPop
  CMP BX, ClipX1
  JGE NoClipX1T
ClipX1LoopT:
  INC BX
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  CMP BX, ClipX1
  JL  ClipX1LoopT
NoClipX1T:
  ADD DI, BX
  SUB CX, BX
  JZ  SkipTriLineTPop
  MOV BX, CX
  MOV [BP], BX
FixAddressLoopT:
  TEST DI, 3
  JZ  NoOddPixelsT
  MOV ESI, EAX
  SHR ESI, 16
  AND SI, TextureWrap
  MOV CL, TextureSize
  SHL SI, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD SI, CX
  ADD SI, TextureAdd
  ADD SI, [BP+20]
  MOV CL, GS:[SI]
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  MOV ES:[DI], CL
  INC DI
  DEC BX
  JG  FixAddressLoopT
NoOddPixelsT:
  MOV [BP], BX
  SHR BX, 2
  JZ  DrawLeftPixelsT
  MOV Counter, BX
Draw4PixelsLoopT:
  MOV ESI, EAX
  SHR ESI, 16
  AND SI, TextureWrap
  MOV CL, TextureSize
  SHL SI, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD SI, CX
  ADD SI, TextureAdd
  ADD SI, [BP+20]
  MOV BL, GS:[SI]
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  MOV ESI, EAX
  SHR ESI, 16
  AND SI, TextureWrap
  MOV CL, TextureSize
  SHL SI, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD SI, CX
  ADD SI, TextureAdd
  ADD SI, [BP+20]
  MOV BH, GS:[SI]
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  SHL EBX, 16
  MOV ESI, EAX
  SHR ESI, 16
  AND SI, TextureWrap
  MOV CL, TextureSize
  SHL SI, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD SI, CX
  ADD SI, TextureAdd
  ADD SI, [BP+20]
  MOV BL, GS:[SI]
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  MOV ESI, EAX
  SHR ESI, 16
  AND SI, TextureWrap
  MOV CL, TextureSize
  SHL SI, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD SI, CX
  ADD SI, TextureAdd
  ADD SI, [BP+20]
  MOV BH, GS:[SI]
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  ROL EBX, 16
  MOV ES:[DI], EBX
  ADD DI, 4
  DEC Counter
  JNZ Draw4PixelsLoopT
DrawLeftPixelsT:
  MOV BX, [BP]
  AND BX, 3
  JZ  SkipTriLineTPop
LeftPixelsLoopT:
  MOV ESI, EAX
  SHR ESI, 16
  AND SI, TextureWrap
  MOV CL, TextureSize
  SHL SI, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD SI, CX
  ADD SI, TextureAdd
  ADD SI, [BP+20]
  MOV CL, GS:[SI]
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  MOV ES:[DI], CL
  INC DI
  DEC BX
  JNZ LeftPixelsLoopT
SkipTriLineTPop:
  POP AX
  POP EAX
  POP EAX
  POP DI
  POP CX
SkipTriLineT:
  ADD DI, 320
  INC CX
  CMP CX, LastY
  JLE DrawTriT
EndDrawTriT:
  POP BP
  RET 30
CSTriT ENDP

CSTriTB PROC
  PUSH BP
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndTriTB
  MOV AX, [BP+34]
  MOV ES, AX
  MOV AX, [BP+30]
  MOV BX, [BP+26]
  CMP AX, BX
  JLE SwapT1B
  MOV [BP+26], AX
  MOV [BP+30], BX
  MOV AX, [BP+32]
  MOV BX, [BP+28]
  MOV [BP+28], AX
  MOV [BP+32], BX
  MOV AX, [BP+20]
  MOV BX, [BP+16]
  MOV [BP+16], AX
  MOV [BP+20], BX
  MOV AX, [BP+18]
  MOV BX, [BP+14]
  MOV [BP+14], AX
  MOV [BP+18], BX
SwapT1B:
  MOV AX, [BP+30]
  MOV BX, [BP+22]
  CMP AX, BX
  JLE SwapT2B
  MOV [BP+22], AX
  MOV [BP+30], BX
  MOV AX, [BP+32]
  MOV BX, [BP+24]
  MOV [BP+24], AX
  MOV [BP+32], BX
  MOV AX, [BP+20]
  MOV BX, [BP+12]
  MOV [BP+12], AX
  MOV [BP+20], BX
  MOV AX, [BP+18]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+18], BX
SwapT2B:
  MOV AX, [BP+26]
  MOV BX, [BP+22]
  CMP AX, BX
  JLE EndSwapsTB
  MOV [BP+22], AX
  MOV [BP+26], BX
  MOV AX, [BP+28]
  MOV BX, [BP+24]
  MOV [BP+24], AX
  MOV [BP+28], BX
  MOV AX, [BP+16]
  MOV BX, [BP+12]
  MOV [BP+12], AX
  MOV [BP+16], BX
  MOV AX, [BP+14]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+14], BX
EndSwapsTB:
  XOR SI, SI
  MOV AX, 8000h
InitTriTXB:
  MOV StartX[SI], AX
  ADD SI, 2
  CMP SI, 400
  JL  InitTriTXB
  MOV AX, ClipY1
  MOV FirstY, AX
  MOV BX, [BP+30]
  CMP BX, ClipY2
  JG  EndTriTB
  CMP BX, AX
  JL  ClipFYTB
  MOV FirstY, BX
ClipFYTB:
  MOV AX, ClipY2
  MOV LastY, AX
  MOV BX, [BP+22]
  CMP BX, ClipY1
  JL  EndTriTB
  CMP BX, AX
  JG  ClipLYTB
  MOV LastY, BX
ClipLYTB:
  XOR ECX, ECX
  MOV BX, [BP+30]
  MOV CX, [BP+26]
  SUB CX, BX
  JNZ ConnectT1B
  CMP BX, ClipY1
  JL  EndT1B
  CMP BX, ClipY2
  JG  EndT1B
  SHL BX, 1
  MOV AX, [BP+32]
  MOV StartX[BX], AX
  MOV AX, [BP+20]
  MOV StartU[BX], AX
  MOV AX, [BP+18]
  MOV StartV[BX], AX
  JMP EndT1B
ConnectT1B:
  PUSH ECX
  MOV AX, [BP+16]
  SUB AX, [BP+20]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+14]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+20]
  SHL EDX, 16
  MOV CX, [BP+18]
  SHL ECX, 16
  MOV SI, [BP+30]
StepT11B:
  CMP SI, 0
  JL  NextT11B
  CMP SI, 199
  JG  NextT11B
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV StartU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV StartV[SI], DI
  SHR SI, 1
NextT11B:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+26]
  JLE StepT11B
  POP ECX
  MOV AX, [BP+28]
  SUB AX, [BP+32]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+32]
  SHL EDX, 16
  MOV BX, [BP+30]
StepT12B:
  CMP BX, ClipY1
  JL  NextT12B
  CMP BX, ClipY2
  JG  NextT12B
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
NextT12B:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+26]
  JLE StepT12B
EndT1B:
  XOR ECX, ECX
  MOV BX, [BP+26]
  MOV CX, [BP+22]
  SUB CX, BX
  JNZ ConnectT2B
  CMP BX, ClipY1
  JL  EndT2B
  CMP BX, ClipY2
  JG  EndT2B
  SHL BX, 1
  MOV AX, [BP+28]
  MOV StartX[BX], AX
  MOV AX, [BP+16]
  MOV StartU[BX], AX
  MOV AX, [BP+14]
  MOV StartV[BX], AX
  JMP EndT2B
ConnectT2B:
  PUSH ECX
  MOV AX, [BP+12]
  SUB AX, [BP+16]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+10]
  SUB AX, [BP+14]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+16]
  SHL EDX, 16
  MOV CX, [BP+14]
  SHL ECX, 16
  MOV SI, [BP+26]
StepT21B:
  CMP SI, 0
  JL  NextT21B
  CMP SI, 199
  JG  NextT21B
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV StartU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV StartV[SI], DI
  SHR SI, 1
NextT21B:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+22]
  JLE StepT21B
  POP ECX
  MOV AX, [BP+24]
  SUB AX, [BP+28]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+28]
  SHL EDX, 16
  MOV BX, [BP+26]
StepT22B:
  CMP BX, ClipY1
  JL  NextT22B
  CMP BX, ClipY2
  JG  NextT22B
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
NextT22B:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+22]
  JLE StepT22B
EndT2B:
  XOR ECX, ECX
  MOV BX, [BP+30]
  MOV CX, [BP+22]
  SUB CX, BX
  JNZ ConnectT3B
  CMP BX, ClipY1
  JL  EndT3B
  CMP BX, ClipY2
  JG  EndT3B
  SHL BX, 1
  MOV AX, [BP+20]
  MOV EndU[BX], AX
  MOV AX, [BP+18]
  MOV EndV[BX], AX
  MOV AX, [BP+32]
  MOV EndX[BX], AX
  MOV DX, StartX[BX]
  CMP DX, AX
  JL  EndT3B
  MOV StartX[BX], AX
  MOV EndX[BX], DX
  MOV AX, StartU[BX]
  MOV DX, EndU[BX]
  MOV StartU[BX], DX
  MOV EndU[BX], AX
  MOV AX, StartV[BX]
  MOV DX, EndV[BX]
  MOV StartV[BX], DX
  MOV EndV[BX], AX
  JMP EndT3B
ConnectT3B:
  PUSH ECX
  MOV AX, [BP+12]
  SUB AX, [BP+20]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+10]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+20]
  SHL EDX, 16
  MOV CX, [BP+18]
  SHL ECX, 16
  MOV SI, [BP+30]
StepT31B:
  CMP SI, 0
  JL  NextT31B
  CMP SI, 199
  JG  NextT31B
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV EndU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV EndV[SI], DI
  SHR SI, 1
NextT31B:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+22]
  JLE StepT31B
  POP ECX
  MOV AX, [BP+24]
  SUB AX, [BP+32]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+32]
  SHL EDX, 16
  MOV BX, [BP+30]
StepT32B:
  CMP BX, ClipY1
  JL  NextT32B
  CMP BX, ClipY2
  JG  NextT32B
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndX[SI], CX
  MOV DI, StartX[SI]
  CMP DI, CX
  JL  NextT32B
  MOV StartX[SI], CX
  MOV EndX[SI], DI
  MOV CX, StartU[SI]
  MOV DI, EndU[SI]
  MOV StartU[SI], DI
  MOV EndU[SI], CX
  MOV CX, StartV[SI]
  MOV DI, EndV[SI]
  MOV StartV[SI], DI
  MOV EndV[SI], CX
NextT32B:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+22]
  JLE StepT32B
EndT3B:
  MOV AX, [BP+08]
  MOV GS, AX
  MOV AX, BMapSeg
  MOV FS, AX
  MOV CX, FirstY
  MOV DI, CX
  MOV SI, CX
  SHL DI, 8
  SHL SI, 6
  ADD DI, SI
DrawTriTB:
  MOV SI, CX
  SHL SI, 1
  MOV BX, StartX[SI]
  CMP BX, 8000h
  JE  SkipTriLineTB
  PUSH CX
  XOR ECX, ECX
  MOV CX, EndX[SI]
  SUB CX, BX
  INC CX
  MOV AX, EndU[SI]
  SUB AX, StartU[SI]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  PUSH EAX
  MOV AX, EndV[SI]
  SUB AX, StartV[SI]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  PUSH EAX
  PUSH AX
  MOV BP, SP
  MOV AX, EndX[SI]
  MOV [BP], AX
  MOV DX, StartU[SI]
  MOV AX, StartV[SI]
  SHL EDX, 16
  SHL EAX, 16
DrawTriLineTB:
  CMP BX, ClipX1
  JL  SkipTriPixelTB
  CMP BX, ClipX2
  JG  SkipTriPixelTB
  MOV ESI, EAX
  SHR ESI, 16
  AND SI, TextureWrap
  MOV CL, TextureSize
  SHL SI, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD SI, CX
  ADD SI, TextureAdd
  ADD SI, [BP+18]
  MOV CL, ES:[DI+BX]
  MOV CH, GS:[SI]
  OR  CH, CH
  JZ  SkipTriPixelTB
  PUSH BX
  MOV BX, CX
  MOV CL, FS:[BX]
  POP BX
  MOV ES:[DI+BX], CL
SkipTriPixelTB:
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  INC BX
  CMP BX, [BP]
  JLE DrawTriLineTB
  POP AX
  POP EAX
  POP EAX
  POP CX
SkipTriLineTB:
  ADD DI, 320
  INC CX
  CMP CX, LastY
  JLE DrawTriTB
EndTriTB:
  POP BP
  RET 30
CSTriTB ENDP

CSTriTF PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+34]
  MOV ES, AX
  MOV AX, [BP+30]
  MOV BX, [BP+26]
  CMP AX, BX
  JLE SwapT1F
  MOV [BP+26], AX
  MOV [BP+30], BX
  MOV AX, [BP+32]
  MOV BX, [BP+28]
  MOV [BP+28], AX
  MOV [BP+32], BX
  MOV AX, [BP+20]
  MOV BX, [BP+16]
  MOV [BP+16], AX
  MOV [BP+20], BX
  MOV AX, [BP+18]
  MOV BX, [BP+14]
  MOV [BP+14], AX
  MOV [BP+18], BX
SwapT1F:
  MOV AX, [BP+30]
  MOV BX, [BP+22]
  CMP AX, BX
  JLE SwapT2F
  MOV [BP+22], AX
  MOV [BP+30], BX
  MOV AX, [BP+32]
  MOV BX, [BP+24]
  MOV [BP+24], AX
  MOV [BP+32], BX
  MOV AX, [BP+20]
  MOV BX, [BP+12]
  MOV [BP+12], AX
  MOV [BP+20], BX
  MOV AX, [BP+18]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+18], BX
SwapT2F:
  MOV AX, [BP+26]
  MOV BX, [BP+22]
  CMP AX, BX
  JLE EndSwapsTF
  MOV [BP+22], AX
  MOV [BP+26], BX
  MOV AX, [BP+28]
  MOV BX, [BP+24]
  MOV [BP+24], AX
  MOV [BP+28], BX
  MOV AX, [BP+16]
  MOV BX, [BP+12]
  MOV [BP+12], AX
  MOV [BP+16], BX
  MOV AX, [BP+14]
  MOV BX, [BP+10]
  MOV [BP+10], AX
  MOV [BP+14], BX
EndSwapsTF:
  XOR SI, SI
  MOV AX, 8000h
InitTriTXF:
  MOV StartX[SI], AX
  ADD SI, 2
  CMP SI, 400
  JL  InitTriTXF
  MOV AX, ClipY1
  MOV FirstY, AX
  MOV BX, [BP+30]
  CMP BX, ClipY2
  JG  EndDrawTriTF
  CMP BX, AX
  JL  ClipFYTF
  MOV FirstY, BX
ClipFYTF:
  MOV AX, ClipY2
  MOV LastY, AX
  MOV BX, [BP+22]
  CMP BX, ClipY1
  JL  EndDrawTriTF
  CMP BX, AX
  JG  ClipLYTF
  MOV LastY, BX
ClipLYTF:
  XOR ECX, ECX
  MOV BX, [BP+30]
  MOV CX, [BP+26]
  SUB CX, BX
  JNZ ConnectT1F
  CMP BX, ClipY1
  JL  EndT1F
  CMP BX, ClipY2
  JG  EndT1F
  SHL BX, 1
  MOV AX, [BP+32]
  MOV StartX[BX], AX
  MOV AX, [BP+20]
  MOV StartU[BX], AX
  MOV AX, [BP+18]
  MOV StartV[BX], AX
  JMP EndT1F
ConnectT1F:
  PUSH ECX
  MOV AX, [BP+16]
  SUB AX, [BP+20]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+14]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+20]
  SHL EDX, 16
  MOV CX, [BP+18]
  SHL ECX, 16
  MOV SI, [BP+30]
StepT11F:
  CMP SI, 0
  JL  NextT11F
  CMP SI, 199
  JG  NextT11F
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV StartU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV StartV[SI], DI
  SHR SI, 1
NextT11F:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+26]
  JLE StepT11F
  POP ECX
  MOV AX, [BP+28]
  SUB AX, [BP+32]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+32]
  SHL EDX, 16
  MOV BX, [BP+30]
StepT12F:
  CMP BX, ClipY1
  JL  NextT12F
  CMP BX, ClipY2
  JG  NextT12F
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
NextT12F:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+26]
  JLE StepT12F
EndT1F:
  XOR ECX, ECX
  MOV BX, [BP+26]
  MOV CX, [BP+22]
  SUB CX, BX
  JNZ ConnectT2F
  CMP BX, ClipY1
  JL  EndT2F
  CMP BX, ClipY2
  JG  EndT2F
  SHL BX, 1
  MOV AX, [BP+28]
  MOV StartX[BX], AX
  MOV AX, [BP+16]
  MOV StartU[BX], AX
  MOV AX, [BP+14]
  MOV StartV[BX], AX
  JMP EndT2F
ConnectT2F:
  PUSH ECX
  MOV AX, [BP+12]
  SUB AX, [BP+16]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+10]
  SUB AX, [BP+14]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+16]
  SHL EDX, 16
  MOV CX, [BP+14]
  SHL ECX, 16
  MOV SI, [BP+26]
StepT21F:
  CMP SI, 0
  JL  NextT21F
  CMP SI, 199
  JG  NextT21F
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV StartU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV StartV[SI], DI
  SHR SI, 1
NextT21F:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+22]
  JLE StepT21F
  POP ECX
  MOV AX, [BP+24]
  SUB AX, [BP+28]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+28]
  SHL EDX, 16
  MOV BX, [BP+26]
StepT22F:
  CMP BX, ClipY1
  JL  NextT22F
  CMP BX, ClipY2
  JG  NextT22F
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV StartX[SI], CX
NextT22F:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+22]
  JLE StepT22F
EndT2F:
  XOR ECX, ECX
  MOV BX, [BP+30]
  MOV CX, [BP+22]
  SUB CX, BX
  JNZ ConnectT3F
  CMP BX, ClipY1
  JL  EndT3F
  CMP BX, ClipY2
  JG  EndT3F
  SHL BX, 1
  MOV AX, [BP+20]
  MOV EndU[BX], AX
  MOV AX, [BP+18]
  MOV EndV[BX], AX
  MOV AX, [BP+32]
  MOV EndX[BX], AX
  MOV DX, StartX[BX]
  CMP DX, AX
  JL  EndT3F
  MOV StartX[BX], AX
  MOV EndX[BX], DX
  MOV AX, StartU[BX]
  MOV DX, EndU[BX]
  MOV StartU[BX], DX
  MOV EndU[BX], AX
  MOV AX, StartV[BX]
  MOV DX, EndV[BX]
  MOV StartV[BX], DX
  MOV EndV[BX], AX
  JMP EndT3F
ConnectT3F:
  PUSH ECX
  MOV AX, [BP+12]
  SUB AX, [BP+20]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV EBX, EAX
  MOV AX, [BP+10]
  SUB AX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+20]
  SHL EDX, 16
  MOV CX, [BP+18]
  SHL ECX, 16
  MOV SI, [BP+30]
StepT31F:
  CMP SI, 0
  JL  NextT31F
  CMP SI, 199
  JG  NextT31F
  SHL SI, 1
  MOV EDI, EDX
  SHR EDI, 16
  MOV EndU[SI], DI
  MOV EDI, ECX
  SHR EDI, 16
  MOV EndV[SI], DI
  SHR SI, 1
NextT31F:
  ADD EDX, EBX
  ADD ECX, EAX
  INC SI
  CMP SI, [BP+22]
  JLE StepT31F
  POP ECX
  MOV AX, [BP+24]
  SUB AX, [BP+32]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  MOV DX, [BP+32]
  SHL EDX, 16
  MOV BX, [BP+30]
StepT32F:
  CMP BX, ClipY1
  JL  NextT32F
  CMP BX, ClipY2
  JG  NextT32F
  MOV SI, BX
  SHL SI, 1
  MOV ECX, EDX
  SHR ECX, 16
  MOV EndX[SI], CX
  MOV DI, StartX[SI]
  CMP DI, CX
  JL  NextT32F
  MOV StartX[SI], CX
  MOV EndX[SI], DI
  MOV CX, StartU[SI]
  MOV DI, EndU[SI]
  MOV StartU[SI], DI
  MOV EndU[SI], CX
  MOV CX, StartV[SI]
  MOV DI, EndV[SI]
  MOV StartV[SI], DI
  MOV EndV[SI], CX
NextT32F:
  ADD EDX, EAX
  INC BX
  CMP BX, [BP+22]
  JLE StepT32F
EndT3F:
  MOV AX, [BP+08]
  MOV GS, AX
  MOV CX, FirstY
  MOV DI, CX
  MOV SI, CX
  SHL DI, 8
  SHL SI, 6
  ADD DI, SI
DrawTriTF:
  MOV SI, CX
  SHL SI, 1
  MOV BX, StartX[SI]
  CMP BX, 8000h
  JE  SkipTriLineTF
  PUSH CX
  XOR ECX, ECX
  MOV CX, EndX[SI]
  SUB CX, BX
  INC CX
  MOV AX, EndU[SI]
  SUB AX, StartU[SI]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  PUSH EAX
  MOV AX, EndV[SI]
  SUB AX, StartV[SI]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  IDIV ECX
  PUSH EAX
  PUSH AX
  MOV BP, SP
  MOV AX, EndX[SI]
  MOV [BP], AX
  MOV DX, StartU[SI]
  MOV AX, StartV[SI]
  SHL EDX, 16
  SHL EAX, 16
DrawTriLineTF:
  CMP BX, ClipX1
  JL  SkipTriPixelTF
  CMP BX, ClipX2
  JG  SkipTriPixelTF
  MOV ESI, EAX
  SHR ESI, 16
  AND SI, TextureWrap
  MOV CL, TextureSize
  SHL SI, CL
  MOV ECX, EDX
  SHR ECX, 16
  ADD SI, CX
  ADD SI, TextureAdd
  ADD SI, [BP+18]
  PUSH BX
  PUSH AX
  XOR CX, CX
  XOR AX, AX
  MOV BX, SI
  MOV SI, TextureWrap
  INC SI
  MOV CL, GS:[BX-1]
  ADD AX, CX
  MOV CL, GS:[BX]
  ADD AX, CX
  MOV CL, GS:[BX+1]
  ADD AX, CX
  MOV CL, GS:[BX-SI]
  ADD AX, CX
  SHR AX, 2
  MOV CL, GS:[BX+SI]
  ADD AX, CX
  SHR AX, 1
  MOV CL, AL
  POP AX
  POP BX
  OR  CL, CL
  JZ  SkipTriPixelTF
  MOV ES:[DI+BX], CL
SkipTriPixelTF:
  ADD EDX, [BP+06]
  ADD EAX, [BP+02]
  INC BX
  CMP BX, [BP]
  JLE DrawTriLineTF
  POP AX
  POP EAX
  POP EAX
  POP CX
SkipTriLineTF:
  ADD DI, 320
  INC CX
  CMP CX, LastY
  JLE DrawTriTF
EndDrawTriTF:
  POP BP
  RET 30
CSTriTF ENDP

CSTextureWidth PROC
  PUSH BP
  MOV BP, SP
  MOV BX, [BP+06]
  CMP BX, 100h
  JB  No256
  MOV TextureSize, 8h
  MOV TextureWrap, 0FFh
  MOV TextureAdd, 0h
  POP BP
  RET 2
No256:
  MOV AX, 128
  MOV CX, 8
FindWidth:
  TEST BL, AL
  JNZ WidthFound
  SHR AX, 1
  DEC CX
  JNZ FindWidth
WidthFound:
  DEC AX
  MOV TextureWrap, AX
  DEC CL
  MOV TextureSize, CL
  MOV TextureAdd, 4h
  POP BP
  RET 2
CSTextureWidth ENDP

END
