;----------------------------------------------------------------------------
;
;  CosmoX BLENDING Module
;
;  Part of the CosmoX Library 1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

EXTRN BMapActive  : BYTE
EXTRN BMapSeg     : WORD
EXTRN B$SETM      : FAR       ; This is the QB function SETMEM

CosmoXBMapFile STRUC
    BMapFileTitle     DB  'CosmoX BMap File    '
    LibVersion        DB  'CosmoX Library v1.6 '
CosmoXBMapFile ENDS

.DATA

ALIGN 2

BMapHeader          CosmoXBMapFile <>            ; BMap File Header
BMapLoad            CosmoXBMapFile <>            ; BMap File Header
BMapID              DB  'CosmoX BMap File    '   ; BMap File ID

.CODE

PUBLIC  CSCreateBMap, CSSetBMap, CSGetBMap, CSDestroyBMap, xCSSaveBMap,
PUBLIC  xCSLoadBMap

CSCreateBMap PROC
  MOV DL, BMapActive
  OR  DL, DL
  JNZ AlreadyUp
  MOV EAX, -66000
  PUSH EAX
  CALL B$SETM
  MOV AH, 48h
  MOV BX, 4096
  INT 21h
  JC  NoMemory
  MOV BMapSeg, AX
  MOV DL, 1
  MOV BMapActive, DL
  XOR ECX, ECX
  XOR DI, DI
  MOV DX, DS
  MOV DS, AX
CreateBMap:
  MOV [DI], CH
  INC ECX
  INC DI
  CMP ECX, 65536
  JL  CreateBMap
  MOV DS, DX
  XOR AX, AX
  RET
AlreadyUp:
  MOV AX, 2
  RET
NoMemory:
  MOV AX, 1
  RET
CSCreateBMap ENDP

CSSetBMap PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndSetBMap
  MOV AX, BMapSeg
  MOV DS, AX
  MOV AX, [BP+12]
  MOV BX, [BP+10]
  MOV BH, AL
  MOV AL, [BP+08]
  MOV [BX], AL
EndSetBMap:
  POP DS
  POP BP
  RET 6
CSSetBMap ENDP

CSGetBMap PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, 0FFFFh
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndGetBMap
  MOV AX, BMapSeg
  MOV DS, AX
  MOV AX, [BP+10]
  MOV BX, [BP+08]
  MOV BH, AL
  XOR AH, AH
  MOV AL, [BX]
EndGetBMap:
  POP DS
  POP BP
  RET 4
CSGetBMap ENDP

CSDestroyBMap PROC
  MOV DL, BMapActive
  OR  DL, DL
  JZ  AlreadyDown
  MOV AX, BMapSeg
  MOV ES, AX
  MOV AH, 49h
  INT 21h
  MOV EAX, 66000
  PUSH EAX
  CALL B$SETM
AlreadyDown:
  RET
CSDestroyBMap ENDP

xCSSaveBMap PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  ErrorNoBMap
  MOV DS, [BP+10]
  MOV DX, [BP+08]
  XOR CX, CX
  MOV AH, 3Ch
  INT 21h
  JC  ErrorOpenSBMap
  MOV BX, AX
  MOV AX, SEG BMapHeader
  MOV DS, AX
  MOV DX, OFFSET BMapHeader
  MOV CX, 40
  MOV AH, 40h
  INT 21h
  JC  ErrorSaveBMap
  MOV AX, BMapSeg
  MOV DS, AX
  XOR DX, DX
  MOV CX, 8000h
  MOV AH, 40h
  INT 21h
  JC  ErrorSaveBMap
  MOV DX, 8000h
  MOV CX, 8000h
  MOV AH, 40h
  INT 21h
  JC  ErrorSaveBMap
  MOV AH, 3Eh
  INT 21h
  JC  ErrorSaveBMap
  XOR AX, AX
  JMP EndSaveBMap
ErrorSaveBMap:
  XOR AX, AX
  MOV AX, 2
  JMP EndSaveBMap
ErrorOpenSBMap:
  XOR AX, AX
  MOV AX, 1
  JMP EndSaveBMap
ErrorNoBMap:
  MOV AX, 3
EndSaveBMap:
  POP DS
  POP BP
  RET 4
xCSSaveBMap ENDP

xCSLoadBMap PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndLoadBMap
  MOV DS, [BP+10]
  MOV DX, [BP+08]
  XOR CX, CX
  MOV AH, 3Dh
  INT 21h
  JC  ErrorOpenLBMap
  MOV BX, AX
  MOV AX, SEG BMapLoad
  MOV DS, AX
  MOV DX, OFFSET BMapLoad
  MOV CX, 40
  MOV AH, 3Fh
  INT 21h
  JC  ErrorLoadBMap
  MOV AX, DS
  MOV ES, AX
  MOV SI, OFFSET BMapLoad
  MOV DI, OFFSET BMapID
  MOV CX, 20
  REPE CMPSB
  JNE NoBMapFile
  MOV AX, BMapSeg
  MOV DS, AX
  XOR DX, DX
  MOV CX, 8000h
  MOV AH, 3Fh
  INT 21h
  JC  ErrorLoadBMap
  MOV DX, 8000h
  MOV CX, 8000h
  MOV AH, 3Fh
  INT 21h
  JC  ErrorLoadBMap
  MOV AH, 3Eh
  INT 21h
  JC  ErrorLoadBMap
  XOR AX, AX
  JMP EndLoadBMap
ErrorOpenLBMap:
  MOV AX, 1
  JMP EndLoadBMap
NoBMapFile:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 3
  JMP EndLoadBMap
ErrorLoadBMap:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 2
EndLoadBMap:
  POP DS
  POP BP
  RET 4
xCSLoadBMap ENDP

END
