;----------------------------------------------------------------------------
;
;  CosmoX BIT Handling Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

BASIC_StrDescriptor STRUC
  StrLenght   DW  ?
  StrOffset   DW  ?
BASIC_StrDescriptor ENDS

.DATA

ALIGN 2

BinString           DB  16 dup(0)
BinDescriptor       BASIC_StrDescriptor <16, OFFSET BinString>

.CODE

PUBLIC  CSShiftL, CSShiftR, CSSetBit, CSClearBit, CSToggleBit, CSReadBit
PUBLIC  CSRotateL, CSRotateR, CSBin, CSBinToDec

CSShiftL PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV CX, [BP+04]
  SHL AX, CL
  MOV BP, BX
  RET 4
CSShiftL ENDP

CSShiftR PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV CX, [BP+04]
  SHR AX, CL
  MOV BP, BX
  RET 4
CSShiftR ENDP

CSRotateL PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV CX, [BP+04]
  ROL AX, CL
  MOV BP, BX
  RET 4
CSRotateL ENDP

CSRotateR PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV CX, [BP+04]
  ROR AX, CL
  MOV BP, BX
  RET 4
CSRotateR ENDP

CSSetBit PROC
  MOV DI, BP
  MOV BP, SP
  MOV CX, [BP+04]
  MOV BX, 1
  MOV AX, [BP+06]
  OR  CX, CX
  JZ  SkipSetShift
SetShift:
  SHL BX, 1
  DEC CX
  JNZ SetShift
SkipSetShift:
  OR  AX, BX
  MOV BP, DI
  RET 4
CSSetBit ENDP

CSClearBit PROC
  MOV DI, BP
  MOV BP, SP
  MOV CX, [BP+04]
  MOV BX, 1
  MOV AX, [BP+06]
  OR  CX, CX
  JZ  SkipClearShift
ClearShift:
  SHL BX, 1
  DEC CX
  JNZ ClearShift
SkipClearShift:
  NOT BX
  AND AX, BX
  MOV BP, DI
  RET 4
CSClearBit ENDP

CSToggleBit PROC
  MOV DI, BP
  MOV BP, SP
  MOV CX, [BP+04]
  MOV BX, 1
  MOV AX, [BP+06]
  OR  CX, CX
  JE  SkipToggleShift
ToggleShift:
  SHL BX, 1
  DEC CX
  JNZ ToggleShift
SkipToggleShift:
  TEST AX, BX
  JNZ ToggleOff
  OR  AX, BX
  MOV BP, DI
  RET 4
ToggleOff:
  NOT BX
  AND AX, BX
  MOV BP, DI
  RET 4
CSToggleBit ENDP

CSReadBit PROC
  MOV DI, BP
  MOV BP, SP
  MOV CX, [BP+04]
  MOV BX, 1
  MOV DX, [BP+06]
  OR  CX, CX
  JE  SkipReadShift
ReadShift:
  SHL BX, 1
  DEC CX
  JNZ ReadShift
SkipReadShift:
  XOR AX, AX
  TEST DX, BX
  SETNZ AL
  MOV BP, DI
  RET 4
CSReadBit ENDP

CSBin PROC
  PUSH BP
  MOV BP, SP
  MOV BX, [BP+06]
  MOV SI, OFFSET BinString
  MOV CX, 16
  MOV DX, 8000h
  MOV AX, '01'
FillString:
  TEST BX, DX
  JZ  ItsAZero
  MOV [SI], AL
  JMP KeepCounters
ItsAZero:
  MOV [SI], AH
KeepCounters:
  INC SI
  SHR DX, 1
  DEC CX
  JNZ FillString
  MOV AX, OFFSET BinDescriptor
  POP BP
  RET 2
CSBin ENDP

CSBinToDec PROC
  PUSH BP
  MOV BP, SP
  MOV BX, [BP+06]
  MOV DI, [BX+02]
  MOV CX, 16
  XOR AX, AX
  MOV DX, 8000h
ProcessString:
  MOV BL, [DI]
  CMP BL, '0'
  JNE ItsAOne
  JMP UpdateCounters
ItsAOne:
  OR  AX, DX
UpdateCounters:
  INC DI
  SHR DX, 1
  DEC CX
  JNZ ProcessString
  POP BP
  RET 2
CSBinToDec ENDP

END
