DECLARE SUB DemoBlankInput ()
DECLARE SUB DemoChoice ()
DECLARE SUB DemoInfo (InfoID AS INTEGER)
DECLARE FUNCTION DemoInput% (Prompt AS STRING, BoundA AS LONG, BoundB AS LONG)
DECLARE SUB DemoMenu ()
DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'DS4QB2CD.BI'

CLS : PRINT "Initializing DS4QB..."
InitDS4QB
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, "Test1.wav"
PRINT #1, "Test2.wav"
CLOSE #1
LoadSample
DemoMenu
DemoChoice
RemoveMusic 1
ShutdownDS4QB

REM $STATIC
SUB CFade (MusicChannel AS INTEGER, FadeStart AS INTEGER, FadeEnd AS INTEGER, FadeSpeed AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, FadeStart
PRINT #1, FadeEnd
PRINT #1, FadeSpeed
CLOSE #1
OUT &H0, 10
OUT &H0, 10
WaitforDMA0
END SUB

SUB CPan (MusicChannel AS INTEGER, PanStart AS INTEGER, PanEnd AS INTEGER, PanSpeed AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, PanStart
PRINT #1, PanEnd
PRINT #1, PanSpeed
CLOSE #1
OUT &H0, 9
OUT &H0, 9
WaitforDMA0
END SUB

SUB DemoBlankInput
LOCATE 22, 3: PRINT "                                                                          "
END SUB

SUB DemoChoice
DIM ChoiceVar AS INTEGER, Enable3D AS INTEGER
DIM MODVol AS INTEGER, SAMVol AS INTEGER, MP3Vol AS INTEGER
DIM PX AS SINGLE, PY AS SINGLE, PZ AS SINGLE, VX AS SINGLE, VY AS SINGLE, VZ AS SINGLE
DIM CStart AS INTEGER, Cend AS INTEGER, CSpeed AS INTEGER, CFreq AS LONG, CVol AS INTEGER
DIM Mtotal AS LONG, MPos AS LONG, MPattern AS INTEGER, MRow AS INTEGER

DO
  ChoiceVar = DemoInput("Your Choice ", 1, 17)
  DemoMenu
  DemoInfo ChoiceVar
  SELECT CASE ChoiceVar
  CASE 1
    ChoiceVar = DemoInput("Select which music to play : 1) MOD  2) MP3 3) CD Audio ", 1, 3)
    RemoveMusic 1
    SELECT CASE ChoiceVar
    CASE 1
      Enable3D = DemoInput("Enable 3D Audio? (1 = 3D Audio Support, 0 = Panning Support ", 0, 1)
      LoadMusic "TEST.MO3", 1, 1, 1, Enable3D
    CASE 2
      Enable3D = DemoInput("Enable 3D Audio? (1 = 3D Audio Support, 0 = Panning Support ", 0, 1)
      LoadMusic "TEST.MP3", 2, 1, 1, Enable3D
    CASE 3
      MusicChannel = DemoInput("Play which track? ", 0, 50)
      LoadMusic "", 3, MusicChannel, 1, 0
    END SELECT
  CASE 2
    MODVol = DemoInput("Enter MOD Music Volume (0 To 100) ", 0, 100)
    SAMVol = DemoInput("Enter Sound Effects Volume (0 To 100) ", 0, 100)
    MP3Vol = DemoInput("Enter MP3/WAV Volume (0 To 100) ", 0, 100)
    SetVolume MODVol, SAMVol, MP3Vol
  CASE 3
    ChoiceVar = DemoInput("Enter EAX Code (0 to 23) ", 0, 23)
    SetEAX ChoiceVar
  CASE 4
    PX = DemoInput("Sound Source's X Position ", -1000, 1000)
    PY = DemoInput("Sound Source's Y Position ", -1000, 1000)
    PZ = DemoInput("Sound Source's Z Position ", -1000, 1000)
    VX = DemoInput("Sound Source's X Velocity ", -1000, 1000)
    VY = DemoInput("Sound Source's Y Velocity ", -1000, 1000)
    VZ = DemoInput("Sound Source's Z Velocity ", -1000, 1000)
    Set3D 1, PX, PY, PZ, VX, VY, VZ
  CASE 5
    CStart = DemoInput("Panning Start (-100 to 100) ", -100, 100)
    Cend = DemoInput("Panning End (-100 to 100) ", -100, 100)
    CSpeed = DemoInput("Panning Speed ", -100, 100)
    CPan 1, CStart, Cend, CSpeed
  CASE 6
    CStart = DemoInput("Fading Start (0 to 100) ", 0, 100)
    Cend = DemoInput("Fading End (0 to 100) ", 0, 100)
    CSpeed = DemoInput("Fading Speed ", -100, 100)
    CFade 1, CStart, Cend, CSpeed
  CASE 7
    ChoiceVar = DemoInput("Which Sound Effect? (1-2) ", 1, 2)
    PlaySample ChoiceVar
  CASE 8
    ChoiceVar = DemoInput("What music is playing? 1) MOD  2) MP3 ", 1, 2)
    IF ChoiceVar = 1 THEN
      DO
        GetFBMOD 1, Mtotal, MPattern, MRow
        DemoBlankInput
        LOCATE 22, 3
        PRINT "Pattern" + STR$(MPattern) + " Row" + STR$(MRow) + "." + STR$(Mtotal) + " total patterns.  Press a key to exit."
      LOOP WHILE INKEY$ = ""
    ELSE
      DO
        GetFBMP3 1, Mtotal, MPos
        DemoBlankInput
        LOCATE 22, 3
        PRINT "Byte" + STR$(MPos) + " out of" + STR$(Mtotal) + " bytes.  Press a key to exit."
      LOOP WHILE INKEY$ = ""
    END IF
  CASE 9
    PauseMusic 1
  CASE 10
    ResumeMusic 1
  CASE 11
    RemoveMusic 1
  CASE 12
    DO
      DemoBlankInput
      LOCATE 22, 3: INPUT "Channel Frequency (100-100000) ", CFreq
    LOOP UNTIL CFreq > 99 AND CFreq < 100001
    CVol = DemoInput("Channel Volume ", 0, 100)
    CStart = DemoInput("Channel Panning (only non-3D channels) ", -100, 100)
    SetChannel 1, CFreq, CVol, CStart
  CASE 13
    ChoiceVar = DemoInput("What music is playing? 1) MOD  2) MP3 ", 1, 2)
    IF ChoiceVar = 1 THEN
      MPos = 0
      MPattern = DemoInput("Jump to which pattern? ", 0, 20)
      MRow = DemoInput("Jump to which row? ", 0, 64)
    ELSE
      DO
        DemoBlankInput
        LOCATE 22, 3: INPUT "Position in the file in bytes ", MPos
      LOOP UNTIL MPos > -1 AND MPos < 2165761
      MPattern = 0
      MRow = 0
    END IF
    SetPos 1, MPos, MPattern, MRow
  CASE 16
    ChoiceVar = DemoInput("What CD Command? 1) Pause  2) Resume ", 1, 2)
    IF ChoiceVar = 1 THEN PauseCD ELSE ResumeCD
  CASE 17
    EXIT DO
  END SELECT
LOOP
END SUB

SUB DemoInfo (InfoID AS INTEGER)
SELECT CASE InfoID
CASE 1
  LOCATE 5, 38: PRINT "LoadMusic (MusicName$, MusicType%,       "
  LOCATE 6, 38: PRINT "MusicChannel%, Repeat%, Enable3D%)       "
  LOCATE 7, 38: PRINT "                                         "
  LOCATE 8, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 9, 38: PRINT "MusicName$ --> The filename of the music "
  LOCATE 10, 38: PRINT "that you want to play.                   "
  LOCATE 11, 38: PRINT "MusicType% --> 1 for MOD, 2 for MP3, 3   "
  LOCATE 12, 38: PRINT "for CD-MusicChannel% is the track to play"
  LOCATE 13, 38: PRINT "MusicChannel% --> Select a channel (1-5) "
  LOCATE 14, 38: PRINT "Repeat% --> 1 = Loop Music, 0 = Play Once"
  LOCATE 15, 38: PRINT "Enable3D% --> Enable 3D Audio Physics.   "
  LOCATE 16, 38: PRINT "This disables panning (use 3D Positions  "
  LOCATE 17, 38: PRINT "to achieve the same effect.              "
  LOCATE 18, 38: PRINT "                                         "
  LOCATE 19, 38: PRINT "------------> Example Usage <----------- -"
  LOCATE 20, 38: PRINT "LoadMusic " + CHR$(34) + "Demo.mo3" + CHR$(34) + ", 1, 1, 1, 1         "
CASE 2
  LOCATE 5, 38: PRINT "SetVolume (MODVol%, SAMVol%, MP3Vol%)    "
  LOCATE 6, 38: PRINT "                                         "
  LOCATE 7, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 8, 38: PRINT "MODVol% --> MOD Music Volume             "
  LOCATE 9, 38: PRINT "SAMVol% --> Sound Effects Volume         "
  LOCATE 10, 38: PRINT "MP3Vol% --> MP3/WAV Volume              "
  LOCATE 11, 38: PRINT "                                         "
  LOCATE 12, 38: PRINT "------------> Example Usage <------------"
  LOCATE 13, 38: PRINT "SetVolume 100, 100, 100                  "
CASE 3
  LOCATE 5, 38: PRINT "SetEAX (EaxCode%)                        "
  LOCATE 6, 38: PRINT "                                         "
  LOCATE 7, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 8, 38: PRINT "EaxCode% --> EAX Environment Code (See   "
  LOCATE 9, 38: PRINT "the readme.txt file for a list of codes) "
  LOCATE 10, 38: PRINT "                                         "
  LOCATE 11, 38: PRINT "------------> Example Usage <------------"
  LOCATE 12, 38: PRINT "SetEAX 13                                "
CASE 4
  LOCATE 5, 38: PRINT "Set3D (MusicChannel%, PX!, PY!, PZ!, VX!,"
  LOCATE 6, 38: PRINT "VY!, VZ!)                                "
  LOCATE 7, 38: PRINT "                                         "
  LOCATE 8, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 9, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 10, 38: PRINT "to set 3D attributes for.                "
  LOCATE 11, 38: PRINT "PX!, PY!, PZ! --> X,Y,Z Position of the  "
  LOCATE 12, 38: PRINT "sound source in 3D Space.                "
  LOCATE 13, 38: PRINT "PX!, PY!, PZ! --> X,Y,Z Velocity of the  "
  LOCATE 14, 38: PRINT "sound source.                            "
  LOCATE 15, 38: PRINT "                                         "
  LOCATE 16, 38: PRINT "------------> Example Usage <------------"
  LOCATE 17, 38: PRINT "Set3D 1, -25, 0, 0, 5, 0, 0              "
CASE 5
  LOCATE 5, 38: PRINT "CPan (MusicChannel%, PanStart%, PanEnd%, "
  LOCATE 6, 38: PRINT "PanSpeed%)                               "
  LOCATE 7, 38: PRINT "                                         "
  LOCATE 8, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 9, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 10, 38: PRINT "PanStart% --> The beginning of the pan   "
  LOCATE 11, 38: PRINT "shift. (-100 to 100)                     "
  LOCATE 12, 38: PRINT "PanEnd% --> The endpoint of the panning  "
  LOCATE 13, 38: PRINT "shift. (-100 to 100)                     "
  LOCATE 14, 38: PRINT "PanSpeed% --> The speed at which panning "
  LOCATE 15, 38: PRINT "occurs.  Remember, if your endpoint is   "
  LOCATE 16, 38: PRINT "less than the starting point, the speed  "
  LOCATE 17, 38: PRINT "must be negative.                        "
  LOCATE 18, 38: PRINT "                                         "
  LOCATE 19, 38: PRINT "------------> Example Usage <------------"
  LOCATE 20, 38: PRINT "CPan 1, -100, 100, 50                    "
CASE 6
  LOCATE 5, 38: PRINT "CFade (MusicChannel%, FadeStart%,        "
  LOCATE 6, 38: PRINT "FadeEnd%, PanSpeed%)                     "
  LOCATE 7, 38: PRINT "                                         "
  LOCATE 8, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 9, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 10, 38: PRINT "FadeStart% --> The beginning of the fade "
  LOCATE 11, 38: PRINT "(Volumes are from 0 to 100)              "
  LOCATE 12, 38: PRINT "FadeEnd% --> The endpoint of the volume  "
  LOCATE 13, 38: PRINT "fade. (Volumes are from 0 to 100)        "
  LOCATE 14, 38: PRINT "FadeSpeed% --> The speed at which fading "
  LOCATE 15, 38: PRINT "occurs.  Remember, if your endpoint is   "
  LOCATE 16, 38: PRINT "less than the starting point, the speed  "
  LOCATE 17, 38: PRINT "must be negative.                        "
  LOCATE 18, 38: PRINT "                                         "
  LOCATE 19, 38: PRINT "------------> Example Usage <------------"
  LOCATE 20, 38: PRINT "CFade 1, 0, 100, 25                      "
CASE 7
  LOCATE 5, 38: PRINT "PlaySample (SFXT%)                       "
  LOCATE 6, 38: PRINT "                                         "
  LOCATE 7, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 8, 38: PRINT "SFXT% --> The slot of the sample to play."
  LOCATE 9, 38: PRINT "this must match up to one of the samples "
  LOCATE 10, 38: PRINT "previously loaded with the LoadMusic     "
  LOCATE 11, 38: PRINT "command.  This means values from 1 to 200"
  LOCATE 12, 38: PRINT "                                         "
  LOCATE 13, 38: PRINT "------------> Example Usage <------------"
  LOCATE 14, 38: PRINT "PlaySample 1                             "
CASE 8
  LOCATE 5, 38: PRINT "GetFBMOD (MusicChannel%, TotalLength&,   "
  LOCATE 6, 38: PRINT "CurrentOrder%, CurrentRow%)              "
  LOCATE 7, 38: PRINT "GetFBMP3 (MusicChannel%, TotalLength&,   "
  LOCATE 8, 38: PRINT "CurrentPos&)                             "
  LOCATE 9, 38: PRINT "                                         "
  LOCATE 10, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 11, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 12, 38: PRINT "TotalLength& --> For an MP3, the size of "
  LOCATE 13, 38: PRINT "the file in bytes.  For a MOD, the number"
  LOCATE 14, 38: PRINT "of Orders (patterns)                     "
  LOCATE 15, 38: PRINT "CurrentPos& --> For MP3s, the current    "
  LOCATE 16, 38: PRINT "play position in the file, in bytes.     "
  LOCATE 17, 38: PRINT "CurrentOrder% --> Currently playing Order"
  LOCATE 18, 38: PRINT "CurrentRow% --> Currently playing Row    "
  LOCATE 19, 38: PRINT "All variables except for MusicChannel are"
  LOCATE 20, 38: PRINT "passed by reference. "
CASE 9
  LOCATE 5, 38: PRINT "PauseMusic (MusicChannel%)               "
  LOCATE 6, 38: PRINT "                                         "
  LOCATE 7, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 8, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 9, 38: PRINT "that music will be paused on.            "
  LOCATE 10, 38: PRINT "                                         "
  LOCATE 11, 38: PRINT "------------> Example Usage <------------"
  LOCATE 12, 38: PRINT "PauseMusic 1                             "
CASE 10
  LOCATE 5, 38: PRINT "ResumeMusic (MusicChannel%)              "
  LOCATE 6, 38: PRINT "                                         "
  LOCATE 7, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 8, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 9, 38: PRINT "that music will be resumed on.           "
  LOCATE 10, 38: PRINT "                                         "
  LOCATE 11, 38: PRINT "------------> Example Usage <------------"
  LOCATE 12, 38: PRINT "ResumeMusic 1                            "
CASE 11
  LOCATE 5, 38: PRINT "RemoveMusic (MusicChannel%)              "
  LOCATE 6, 38: PRINT "                                         "
  LOCATE 7, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 8, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 9, 38: PRINT "that will have its current music cleared "
  LOCATE 10, 38: PRINT "                                         "
  LOCATE 11, 38: PRINT "------------> Example Usage <------------"
  LOCATE 12, 38: PRINT "RemoveMusic 1                            "
CASE 12
  LOCATE 5, 38: PRINT "SetChannel (MusicChannel%, Frequency%,   "
  LOCATE 6, 38: PRINT "Volume%, Panning%)                       "
  LOCATE 7, 38: PRINT "                                         "
  LOCATE 8, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 9, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 10, 38: PRINT "Frequency% --> sampling rate of the      "
  LOCATE 11, 38: PRINT "music (from 100 (low) to 100000 (high)   "
  LOCATE 12, 38: PRINT "Volume% --> The volume of the music      "
  LOCATE 13, 38: PRINT "(Volumes are from 0 to 100)              "
  LOCATE 14, 38: PRINT "Panning% --> The panning position of the "
  LOCATE 15, 38: PRINT "music.  This is from -100 to 100.        "
  LOCATE 16, 38: PRINT "Panning only works in channels that do   "
  LOCATE 17, 38: PRINT "not have 3D Audio enabled.               "
  LOCATE 18, 38: PRINT "                                         "
  LOCATE 19, 38: PRINT "------------> Example Usage <------------"
  LOCATE 20, 38: PRINT "SetChannel 1, 200, 75, -25"
CASE 13
  LOCATE 5, 38: PRINT "SetPos (MusicChannel%, MP3Position&,     "
  LOCATE 6, 38: PRINT "MODOrder%, MODRow%)                      "
  LOCATE 7, 38: PRINT "                                         "
  LOCATE 8, 38: PRINT "-----------> Function Inputs <-----------"
  LOCATE 9, 38: PRINT "MusicChannel% --> The Music Channel (1-5)"
  LOCATE 10, 38: PRINT "MP3Position& --> The position, in bytes, "
  LOCATE 11, 38: PRINT "from the start of the MP3 file.  This may"
  LOCATE 12, 38: PRINT "not match with the actual file size.     "
  LOCATE 13, 38: PRINT "MODOrder% --> The order (pattern) in the "
  LOCATE 14, 38: PRINT "MOD to jump to.                          "
  LOCATE 15, 38: PRINT "MODRow% --> The row in the currently     "
  LOCATE 16, 38: PRINT "playing pattern to jump to.              "
  LOCATE 17, 38: PRINT "                                         "
  LOCATE 18, 38: PRINT "------------> Example Usage <------------"
  LOCATE 19, 38: PRINT "SetPos 1, 0, 5, 20"
  LOCATE 20, 38: PRINT "SetPos 1, 103500, 0, 0"
CASE 14
  LOCATE 5, 38: PRINT " ---- Miscellaneous commands Page A ---- "
  LOCATE 6, 38: PRINT "                                         "
  LOCATE 7, 38: PRINT "InitDS4QB --> This command initializes   "
  LOCATE 8, 38: PRINT "the sound engine.  It must be called     "
  LOCATE 9, 38: PRINT "before any other commands will work.  Not"
  LOCATE 10, 38: PRINT "calling this command will freeze the    "
  LOCATE 11, 38: PRINT "program.  Make sure that the directory  "
  LOCATE 12, 38: PRINT "in the SHELL command inside this SUB is "
  LOCATE 13, 38: PRINT "the directory where DS4QB2.EXE is found."
  LOCATE 14, 38: PRINT "All OPEN commands in DS4QB2 SUBs must be"
  LOCATE 15, 38: PRINT "pointing to this directory.             "
  LOCATE 16, 38: PRINT "                                        "
  LOCATE 17, 38: PRINT "LoadSample --> This command loads a set "
  LOCATE 18, 38: PRINT "samples from a file.  This file must be "
  LOCATE 19, 38: PRINT "a sequential file.  PRINT WAV filenames "
  LOCATE 20, 38: PRINT "to this file before calling LoadSample. "
CASE 15
  LOCATE 5, 38: PRINT " ---- Miscellaneous commands Page B ---- "
  LOCATE 6, 38: PRINT "                                         "
  LOCATE 7, 38: PRINT "StopSFX (SFXChannel%) --> This stops all "
  LOCATE 8, 38: PRINT "playing instances of the sound effect at "
  LOCATE 9, 38: PRINT "SFXChannel%.                             "
  LOCATE 10, 38: PRINT "                                        "
  LOCATE 11, 38: PRINT "ShutdownDS4QB --> This shuts down the   "
  LOCATE 12, 38: PRINT "DS4QB2 slave.  This command must be     "
  LOCATE 13, 38: PRINT "called before exiting the QBasic program"
  LOCATE 14, 38: PRINT "or else the slave will remain loaded.   "
CASE 16
  LOCATE 5, 38: PRINT " -- CD Audio Commands and explanation -- "
  LOCATE 6, 38: PRINT "CD Audio is played through the function  "
  LOCATE 7, 38: PRINT "LoadMusic, just like a MOD or MP3/WAV.   "
  LOCATE 8, 38: PRINT "For MusicType use 3 and for MusicChannel,"
  LOCATE 9, 38: PRINT "use the CD track that you want to play.  "
  LOCATE 10, 38: PRINT "                                         "
  LOCATE 11, 38: PRINT "PauseCD --> This pauses the currently    "
  LOCATE 12, 38: PRINT "playing CD Track.                        "
  LOCATE 13, 38: PRINT "                                         "
  LOCATE 14, 38: PRINT "ResumeCD --> This function resumes a     "
  LOCATE 15, 38: PRINT "paused CD Track.                         "
END SELECT
END SUB

FUNCTION DemoInput% (Prompt AS STRING, BoundA AS LONG, BoundB AS LONG)
DIM Result AS INTEGER
DO
  DemoBlankInput
  LOCATE 22, 3: PRINT Prompt
  LOCATE 22, 3 + LEN(Prompt): INPUT "", Result
LOOP UNTIL Result > BoundA - 1 AND Result < BoundB + 1
DemoInput% = Result
END FUNCTION

SUB DemoMenu
CLS
PRINT "ͻ                ͻ"
PRINT " Welcome to the DS4QB2 Demo ˹ Copyright 2000-2001 AetherSoft "
PRINT "͹"
PRINT " -----> Available Commands <-----  ---------> Command Description <--------- "
PRINT " 1) Load the Demo Music                                                      "
PRINT " 2) Set Global Volumes                                                       "
PRINT " 3) Set SB Live EAX Environment                                              "
PRINT " 4) Set 3D Audio properties                                                  "
PRINT " 5) Test Panning                                                             "
PRINT " 6) Test Fading                                                              "
PRINT " 7) Play a Sound Effect                                                      "
PRINT " 8) Get Music Information                                                    "
PRINT " 9) Pause Music Playback                                                     "
PRINT " 10) Resume Music Playback                                                   "
PRINT " 11) Unload Music from Channel                                               "
PRINT " 12) Set Channel Attributes                                                  "
PRINT " 13) Set Playback Position                                                   "
PRINT " 14) Miscellaneous Commands A                                                "
PRINT " 15) Miscellaneous Commands B                                                "
PRINT " 16) CD Audio Commands                                                       "
PRINT "͹"
PRINT "                                                                              "
PRINT " Enter 17 to Quit ͼ"
'ȹɺʻۼα
END SUB

SUB GetFBMOD (MusicChannel AS INTEGER, TotalLength AS LONG, CurrentOrder AS INTEGER, CurrentRow AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 11
OUT &H0, 11
WaitforDMA0
OPEN "DS4QB2.DAT" FOR BINARY AS #1
GET #1, 1, TotalLength
GET #1, 5, CurrentOrder
GET #1, 7, CurrentRow
CLOSE #1
END SUB

SUB GetFBMP3 (MusicChannel AS INTEGER, TotalLength AS LONG, CurrentPos AS LONG)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 12
OUT &H0, 12
WaitforDMA0
OPEN "DS4QB2.DAT" FOR BINARY AS #1
GET #1, 1, TotalLength
GET #1, 5, CurrentPos
CLOSE #1
END SUB

SUB InitDS4QB
OUT &H0, 0: OUT &H0, 0
SHELL "start /m ds4qb2cd.exe"
END SUB

SUB LoadMusic (MusicName AS STRING, MusicType AS INTEGER, MusicChannel AS INTEGER, Repeat AS INTEGER, Enable3D AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicName
PRINT #1, MusicType
PRINT #1, MusicChannel
PRINT #1, Repeat
PRINT #1, Enable3D
CLOSE #1
OUT &H0, 1
OUT &H0, 1
WaitforDMA0
END SUB

SUB LoadSample
WaitforDMA0
OUT &H0, 3
OUT &H0, 3
WaitforDMA0
END SUB

FUNCTION LongBreak% (LongVar AS LONG, IntNum AS INTEGER)
DIM Offset AS INTEGER, Result AS INTEGER
DIM Byte1 AS INTEGER, Byte2 AS INTEGER

DEF SEG = VARSEG(LongVar)
Offset = VARPTR(LongVar)
Byte1 = PEEK(Offset + IntNum * 2)
Byte2 = PEEK(Offset + IntNum * 2 + 1)
DEF SEG = VARSEG(Result)
Offset = VARPTR(Result)
POKE Offset, Byte1
POKE Offset + 1, Byte2
DEF SEG

LongBreak% = Result
END FUNCTION

FUNCTION LongMake& (IntVar1 AS INTEGER, IntVar2 AS INTEGER)
DIM Offset AS INTEGER, Result AS LONG
DIM Byte1 AS INTEGER, Byte2 AS INTEGER, Byte3 AS INTEGER, Byte4 AS INTEGER

DEF SEG = VARSEG(IntVar1)
Offset = VARPTR(IntVar1)
Byte1 = PEEK(Offset)
Byte2 = PEEK(Offset + 1)
DEF SEG = VARSEG(IntVar2)
Offset = VARPTR(IntVar2)
Byte3 = PEEK(Offset)
Byte4 = PEEK(Offset + 1)
DEF SEG = VARSEG(Result)
Offset = VARPTR(Result)
POKE Offset, Byte1
POKE Offset + 1, Byte2
POKE Offset + 2, Byte3
POKE Offset + 3, Byte4
DEF SEG

LongMake& = Result
END FUNCTION

SUB PauseCD
WaitforDMA0
OUT &H0, 53
OUT &H0, 53
WaitforDMA0
END SUB

SUB PauseMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 14
OUT &H0, 14
WaitforDMA0
END SUB

SUB PlaySample (SFXT)
OUT &H0, SFXT + 55
OUT &H0, SFXT + 55
END SUB

SUB RemoveMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 2
OUT &H0, 2
WaitforDMA0
END SUB

SUB ResumeCD
WaitforDMA0
OUT &H0, 54
OUT &H0, 54
WaitforDMA0
END SUB

SUB ResumeMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 15
OUT &H0, 15
WaitforDMA0
END SUB

SUB Set3D (MusicChannel AS INTEGER, PX AS SINGLE, PY AS SINGLE, PZ AS SINGLE, VX AS SINGLE, VY AS SINGLE, VZ AS SINGLE)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, PX
PRINT #1, PY
PRINT #1, PZ
PRINT #1, VX
PRINT #1, VY
PRINT #1, VZ
CLOSE #1
OUT &H0, 7
OUT &H0, 7
WaitforDMA0
END SUB

SUB SetChannel (MusicChannel AS INTEGER, Frequency AS LONG, Volume AS INTEGER, Panning AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, Frequency
PRINT #1, Volume
PRINT #1, Panning
CLOSE #1
OUT &H0, 8
OUT &H0, 8
WaitforDMA0
END SUB

SUB SetEAX (EaxCode AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, EaxCode
CLOSE #1
OUT &H0, 5
OUT &H0, 5
WaitforDMA0
END SUB

SUB SetPos (MusicChannel AS INTEGER, MP3Position AS LONG, MODOrder AS INTEGER, MODRow AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR BINARY AS #1
PUT #1, 1, MusicChannel
PUT #1, 5, MP3Position
PUT #1, 9, MODOrder
PUT #1, 11, MODRow
CLOSE #1
OUT &H0, 13
OUT &H0, 13
WaitforDMA0
END SUB

SUB SetVolume (MODVol, SAMVol, MP3Vol)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MODVol
PRINT #1, SAMVol
PRINT #1, MP3Vol
CLOSE #1
OUT &H0, 4
OUT &H0, 4
WaitforDMA0
END SUB

SUB ShutdownDS4QB
OUT &H0, 55
END SUB

SUB StopSFX (SFXChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, SFXChannel
CLOSE #1
OUT &H0, 6
OUT &H0, 6
WaitforDMA0
END SUB

SUB WaitforDMA0
DO: LOOP UNTIL INP(&H0) = 0
END SUB

