Attribute VB_Name = "FunctionModule"
Public Sub FreeHandle(HandleNumber As Byte)
Select Case MusicChannels(HandleNumber).CType
Case 1
  Call BASS_MusicFree(MusicChannels(HandleNumber).CHandle)
Case 2
  Call BASS_StreamFree(MusicChannels(HandleNumber).CHandle)
End Select
MusicChannels(HandleNumber).VelActive = False
MusicChannels(HandleNumber).FadeActive = False
MusicChannels(HandleNumber).PanActive = False
End Sub
Public Sub ClearDMA0()
Call vbOut(&H0, 0)
Call vbOut(&H0, 0)
End Sub

Public Sub DS4QBPlayMusic()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, Musicfile
Input #1, Musictype
Input #1, MusicChannel
Input #1, MRepeat
Input #1, M3D
Close #1

If Musictype = 1 Then
  PlayFlag = BASS_MUSIC_RAMP Or BASS_MUSIC_POSRESET
Else
  PlayFlag = BASS_MP3_SETPOS
End If

If MRepeat = 1 Then
  If Musictype = 1 Then
    PlayFlag = PlayFlag Or BASS_MUSIC_LOOP
  Else
    PlayFlag = PlayFlag Or BASS_SAMPLE_LOOP
  End If
End If
    
If M3D = 1 Then
  If Musictype = 1 Then
    PlayFlag = PlayFlag Or BASS_MUSIC_3D
  Else
    PlayFlag = PlayFlag Or BASS_SAMPLE_3D
  End If
End If
    
If Musictype <> 3 Then
  FreeHandle MusicChannel
  MusicChannels(MusicChannel).CType = Musictype
End If

Select Case Musictype
Case 1
  MusicChannels(MusicChannel).CHandle = BASS_MusicLoad(0, Musicfile, 0, 0, PlayFlag)
  Call BASS_MusicPlay(MusicChannels(MusicChannel).CHandle)
Case 2
  MusicChannels(MusicChannel).CHandle = BASS_StreamCreateFile(0, Musicfile, 0, 0, PlayFlag)
  Call BASS_StreamPlay(MusicChannels(MusicChannel).CHandle, 0, PlayFlag)
Case 3
  If BASS_CDInDrive = 1 Then BASS_CDPlay MusicChannel, MRepeat, 0
End Select

If Musictpe <> 3 Then
  BASS_ChannelSet3DAttributes MusicChannels(MusicChannel).CHandle, -1, 15, 1000, -1, -1, -1
  MusicChannels(MusicChannel).VelActive = False
  MusicChannels(MusicChannel).FadeActive = False
  MusicChannels(MusicChannel).PanActive = False
End If
End Sub

Public Sub DS4QBClearMusic()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Close #1
FreeHandle MusicChannel
End Sub

Public Sub DS4QBLoadSFX()
Sfxloopx = 0
Open App.Path + "\ds4qb2.dat" For Input As #1
While Not EOF(1)
  Sfxloopx = Sfxloopx + 1
  Input #1, SFXFile
  SFXHandle(Sfxloopx) = BASS_SampleLoad(BASSFALSE, SFXFile, 0, 0, 3, BASS_SAMPLE_OVER_POS) ' Or BASS_SAMPLE_3D)
Wend
Close #1
End Sub

Public Sub DS4QBSetVolume()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicVol
Input #1, SampleVol
Input #1, StreamVol
Close #1
Call BASS_SetGlobalVolumes(MusicVol, SampleVol, StreamVol)
End Sub

Public Sub DS4QBSetEAX()
If EAXPresent <> False Then
  Open App.Path + "\ds4qb2.dat" For Input As #1
  Input #1, EAXCode
  Close #1
  If EAXCode = 0 Then
    BASS_SetEAXParameters -1, 0, -1, -1
  Else
    BASS_SetEAXParametersVB EAXCode - 1
  End If
End If
End Sub

Public Sub DS4QBStopSFX()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, SFXChannel
Close #1
Call BASS_SampleStop(SFXChannel)
End Sub

Public Sub DS4QBExit()
BASS_Stop
BASS_CDFree
BASS_Free
ClearDMA0
End
End Sub

Public Sub DS4QBPlaySFX()
Call BASS_SamplePlay(SFXHandle(PortData - 55))
End Sub

Public Sub DS4QBSet3D()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Input #1, MusicChannels(MusicChannel).pos.X
Input #1, MusicChannels(MusicChannel).pos.Y
Input #1, MusicChannels(MusicChannel).pos.z
Input #1, MusicChannels(MusicChannel).vel.X
Input #1, MusicChannels(MusicChannel).vel.Y
Input #1, MusicChannels(MusicChannel).vel.z
Close #1

If MusicChannels(MusicChannel).vel.X <> 0 Or MusicChannels(MusicChannel).vel.Y <> 0 Or MusicChannels(MusicChannel).vel.z <> 0 Then MusicChannels(MusicChannel).VelActive = True Else MusicChannels(MusicChannel).VelActive = False
BASS_ChannelSet3DPosition MusicChannels(MusicChannel).CHandle, MusicChannels(MusicChannel).pos, Nothing, MusicChannels(MusicChannel).vel
BASS_Apply3D
End Sub

Public Sub DS4QBPan()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Input #1, MusicChannels(MusicChannel).PanPos
Input #1, MusicChannels(MusicChannel).PanEnd
Input #1, MusicChannels(MusicChannel).PanSpeed
Close #1
BASS_ChannelSetAttributes MusicChannels(MusicChannel).CHandle, -1, -1, MusicChannels(MusicChannel).PanPos
MusicChannels(MusicChannel).PanActive = True
End Sub

Public Sub DS4QBFade()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Input #1, MusicChannels(MusicChannel).FadePos
Input #1, MusicChannels(MusicChannel).FadeEnd
Input #1, MusicChannels(MusicChannel).FadeSpeed
Close #1
BASS_ChannelSetAttributes MusicChannels(MusicChannel).CHandle, -1, MusicChannels(MusicChannel).FadePos, -1
MusicChannels(MusicChannel).FadeActive = True
End Sub

Public Sub DS4QBSetChannel()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Input #1, CFreq
Input #1, CVol
Input #1, CPan
Close #1
BASS_ChannelSetAttributes MusicChannels(MusicChannel).CHandle, Creq, CVol, CPan
End Sub

Public Sub DS4QBFeedBackMOD()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Close #1

FBTotal = BASS_MusicGetLength(MusicChannels(MusicChannel).CHandle)
FBCurrent = BASS_ChannelGetPosition(MusicChannels(MusicChannel).CHandle)

Open App.Path + "\ds4qb2.dat" For Binary As #1
Put #1, 1, FBTotal
Put #1, 5, FBCurrent
Close #1
End Sub

Public Sub DS4QBFeedBackMP3()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Close #1

FBTotal = BASS_StreamGetLength(MusicChannels(MusicChannel).CHandle)
FBCurrent = BASS_ChannelGetPosition(MusicChannels(MusicChannel).CHandle)

Open App.Path + "\ds4qb2.dat" For Binary As #1
Put #1, 1, FBTotal
Put #1, 5, FBCurrent
Close #1
End Sub

Public Sub DS4QBSetPosition()
Open App.Path + "\ds4qb2.dat" For Binary As #1
Get #1, 1, MusicChannel
Select Case MusicChannels(MusicChannel).CType
Case 1
  Get #1, 9, CSetPos
Case 2
  Get #1, 5, CSetPos
End Select
Close #1

BASS_ChannelSetPosition MusicChannels(MusicChannel).CHandle, CSetPos
End Sub

Public Sub DS4QBPause()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Close #1

BASS_ChannelPause MusicChannels(MusicChannel).CHandle
End Sub

Public Sub DS4QBResume()
Open App.Path + "\ds4qb2.dat" For Input As #1
Input #1, MusicChannel
Close #1

BASS_ChannelResume MusicChannels(MusicChannel).CHandle
End Sub
