DECLARE SUB ShutdownDS4QB ()
'DEMOCODE.BAS
'$DYNAMIC
DEFINT A-Z
'$INCLUDE: 'DS4QB.BI'

DOSver! = Info.DOSver% / 100
Windows% = Info.WinMode%

CLS
result = InitDS4QB

PRINT "DIRECTSOUND FOR QUICKBASIC"
PRINT "MSDOS Version:"; DOSver!
PRINT "Windows Version:"; Windows%
PRINT "Clipboard function is available."
PRINT "PRESS A KEY TO BEGIN."
DO: LOOP WHILE INKEY$ = ""
CLS
PRINT "MODULE TEST"
result = LoadModule("test.it", 1)
PRINT "PRESS A KEY TO END MUSIC."
DO: LOOP WHILE INKEY$ = ""
result = RemoveModule
PRINT "PRESS A KEY WHEN THE MODULE STOPS."
DO: LOOP WHILE INKEY$ = ""
CLS
PRINT "STREAM TEST"
result = LoadStream("test.mp3", 1)
PRINT "PRESS A KEY TO END MUSIC."
DO: LOOP WHILE INKEY$ = ""
result = RemoveStream
PRINT "PRESS A KEY WHEN THE STREAM STOPS."
DO: LOOP WHILE INKEY$ = ""
CLS
PRINT "SOUND EFFECTS TEST"
PRINT "This will test DS4QB's WAV loading capability."
PRINT "Press any key to load the sound effects script."
DO: LOOP WHILE INKEY$ = ""
result = LoadSample("testwavs.txt")
PRINT "Give it a few seconds!"
PRINT "To test the samples, press 1 or 2. To unload the samples, press ESC."
DO
a$ = INKEY$
SELECT CASE a$
 CASE "1": result = PlaySample(1)
 CASE "2": result = PlaySample(2)
 CASE ELSE
END SELECT
LOOP UNTIL a$ = CHR$(27)
result = RemoveSample
CLS
PRINT "CD AUDIO PLAYING TEST"
PRINT "This will test DS4QB's CD playing capability."
PRINT "Insert a CD and press any key."
DO: LOOP WHILE INKEY$ = ""
result = PlayCD(1, 1)
PRINT "CD audio should be playing. Press any key to quit."
DO: LOOP WHILE INKEY$ = ""
ShutdownDS4QB
PRINT "The new command ShutdownDS4QB should execute now."
PRINT "This concludes the demo."
END

DEFSNG A-Z
FUNCTION Clipboard.Detect%

'  (c) Carl Gorringe 1/15/96
'------------------------------------------
'  Returns TRUE (-1) if Windows Clipboard
'  is Detected, else returns FALSE (0).
'------------------------------------------
'<< Done - Tested OK >>

DIM inreg AS RegType, outreg AS RegType

ClipMode% = False
WinMode% = Info.WinMode%

IF WinMode% > 1 THEN
  inreg.ax = &H1700
  CALL interrupt(&H2F, inreg, outreg)
  IF outreg.ax = &H1700 THEN
	 ClipMode% = False
  ELSE
	 ClipMode% = True
  END IF
END IF

Clipboard.Detect% = ClipMode%

END FUNCTION

SUB Clipboard.Empty (ErrCode%)

'  (c) Carl Gorringe 1/15/96
'---------------------------------------------
'  Empties the Clipboard
'  ErrCode% is the Error Code returned: 0=OK
'---------------------------------------------
'<< Done - Tested OK >>

DIM inreg AS RegType, outreg AS RegType
DIM InRegX AS RegTypeX, OutRegX AS RegTypeX

'--- Open Clipboard ---
	inreg.ax = &H1701
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 1                  '<-- Clipboard is already open (error)
		EXIT SUB
	END IF

'--- Empty Clipboard ---
	inreg.ax = &H1702
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 3                  '<-- Failure (error)
	END IF

'--- Close Clipboard ---
	inreg.ax = &H1708
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 2                  '<-- Clipboard wont close (error)
		EXIT SUB
	END IF


END SUB

SUB Clipboard.Get (Format%, DataSeg%, DataOff%, ErrCode%)

'  (c) Carl Gorringe 1/15/96  << v1.0 >>
'---------------------------------------------
'  Gets Data from the Clipboard and stores
'  it at address DataSeg% : DataOff%
'  ErrCode% is the Error Code returned: 0=OK
'  Format% is the clipboard format number:
'         1 = Text (Windows Text)  <-- Contains garbage chars at end of text
'         2 = Bitmap Picture
'         3 = Metafile Picture
'         7 = OEM Text (DOS Text)  <-- Contains nulls at end of text
'---------------------------------------------
'<< Done - Tested OK >>

DIM inreg AS RegType, outreg AS RegType
DIM InRegX AS RegTypeX, OutRegX AS RegTypeX

'--- Open Clipboard ---
	inreg.ax = &H1701
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 1                  '<-- Clipboard is already open (error)
		EXIT SUB
	END IF

'--- Get Clipboard Data ---
	InRegX.ax = &H1705
	InRegX.dx = Format%
	InRegX.es = DataSeg%
	InRegX.bx = DataOff%
	CALL interruptx(&H2F, InRegX, OutRegX)
	IF OutRegX.ax = 0 THEN
		ErrCode% = 3                  '<-- (error)
	END IF

'--- Close Clipboard ---
	inreg.ax = &H1708
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 2                  '<-- Clipboard wont close (error)
		EXIT SUB
	END IF

END SUB

FUNCTION Clipboard.GetText$ (ErrCode%)

'  (c) Carl Gorringe 1/15/96  << v1.0 >>
'-----------------------------------------------------
'  Gets and Returns Text Data from the Clipboard.
'  Clipboard Format used is "OEM Text" (Format% = 7)
'  ErrCode% is the Error Code returned: 0=OK
'-----------------------------------------------------
'<< Done - Tested OK >>

ErrCode% = 0
Format% = 1       '<-- 7=OEM Text, 1=Windows Text

'--- Get Size of Clipboard ---
	Size& = Clipboard.Size&(Format%, ErrCode%)
	IF ErrCode% > 0 THEN EXIT FUNCTION
  
	IF Size& = 0 THEN
		ErrCode% = 4         '<-- Clipboard Empty!
		EXIT FUNCTION
	END IF

	IF Size& > 32000 THEN
		ErrCode% = 5         '<-- Clipboard Too Large for String Variable!
		EXIT FUNCTION
	END IF

'--- Get Text from Clipboard and Store It ---
	Temp$ = SPACE$(Size&)
	CALL Clipboard.Get(Format%, VARSEG(Temp$), SADD(Temp$), ErrCode%)
  
	IF ErrCode% = 0 THEN
		'--- Trim Ending Garbage ---
			Temp$ = LEFT$(Temp$, INSTR(Temp$, CHR$(0)) - 1)

		'--- Trim Ending CR/LF if Exists ---
			IF RIGHT$(Temp$, 2) = CHR$(13) + CHR$(10) THEN
				Temp$ = LEFT$(Temp$, LEN(Temp$) - 2)
			END IF

		Clipboard.GetText$ = Temp$
	END IF

END FUNCTION

SUB Clipboard.Put (Format%, DataSeg%, DataOff%, DataSize&, ErrCode%)

'  (c) Carl Gorringe 1/15/96  << v1.0 >>
'---------------------------------------------
'  Stores Data on to the Clipboard starting
'  from address DataSeg% : DataOff%
'    and storing DataSize& bytes.
'  ErrCode% is the Error Code returned: 0=OK
'  Format% is the clipboard format number:
'         1 = Text (Windows Text)
'         2 = Bitmap Picture
'         3 = Metafile Picture
'         7 = OEM Text (DOS Text)
'---------------------------------------------
'<< Done - Tested OK >>

DIM inreg AS RegType, outreg AS RegType
DIM InRegX AS RegTypeX, OutRegX AS RegTypeX

'--- Open Clipboard ---
	inreg.ax = &H1701
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 1                  '<-- Clipboard is already open (error)
		EXIT SUB
	END IF

'--- Store Clipboard Data ---
	InRegX.ax = &H1703
	InRegX.dx = Format%
	InRegX.es = DataSeg%
	InRegX.bx = DataOff%
	IF DataSize& < 32768 THEN
		InRegX.si = 0
		InRegX.cx = DataSize&
	ELSE
		InRegX.si = (DataSize& \ 32768) * 2048   '<-- This part NOT Tested!
		InRegX.cx = DataSize& MOD 32768          '<-- but don't worry about it.
	END IF
  
	CALL interruptx(&H2F, InRegX, OutRegX)
	IF OutRegX.ax = 0 THEN
		ErrCode% = 3                  '<-- (error)
	END IF

'--- Close Clipboard ---
	inreg.ax = &H1708
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 2                  '<-- Clipboard wont close (error)
		EXIT SUB
	END IF

END SUB

SUB Clipboard.PutText (Text$, ErrCode%)
ErrCode% = 0
CALL Clipboard.Empty(ErrCode%)
IF ErrCode% <> 0 THEN
  ErrCode% = ErrCode% + 10
  EXIT SUB
END IF
Temp$ = Text$ + CHR$(0)
TempLen& = LEN(Temp$)
CALL Clipboard.Put(1, VARSEG(Temp$), SADD(Temp$), TempLen&, ErrCode%)
CALL Clipboard.Put(7, VARSEG(Temp$), SADD(Temp$), TempLen&, ErrCode%)
END SUB

FUNCTION Clipboard.Size& (Format%, ErrCode%)

'  (c) Carl Gorringe 1/15/96  << v1.0 >>
'---------------------------------------------
'  Returns the current size of the Clipboard
'  in bytes, using the specified Format%
'  ErrCode% is the Error Code returned: 0=OK
'  Format% is the clipboard format number:
'         1 = Text (Windows Text)
'         2 = Bitmap Picture
'         3 = Metafile Picture
'         7 = OEM Text (DOS Text)
'---------------------------------------------
'<< Done - Tested OK >>

DIM inreg AS RegType, outreg AS RegType
DIM InRegX AS RegTypeX, OutRegX AS RegTypeX

ErrCode% = 0

'--- Open Clipboard ---
	inreg.ax = &H1701
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 1                  '<-- Clipboard is already open
		Clipboard.Size& = 0
		EXIT FUNCTION
	END IF

'--- Get Size of Clipboard in current Format ---
	inreg.ax = &H1704
	inreg.dx = Format%
	CALL interrupt(&H2F, inreg, outreg)
	ClipSize& = (outreg.dx * 16) + outreg.ax

'--- Close Clipboard ---
	inreg.ax = &H1708
	CALL interrupt(&H2F, inreg, outreg)
	IF outreg.ax = 0 THEN
		ErrCode% = 2                  '<-- Clipboard wont close
		Clipboard.Size& = 0
		EXIT FUNCTION
	END IF

Clipboard.Size& = ClipSize&

END FUNCTION

FUNCTION Info.DOSver%

'  (c) Carl Gorringe 1/15/96
'--------------------------------------
'  Returns the DOS version times 100.
'  To get decimal representation,
'  devide the number returned by 100.
'--------------------------------------
'<< Done - Tested OK >>

DIM inreg AS RegType, outreg AS RegType

inreg.ax = &H3306
CALL interrupt(&H21, inreg, outreg)
DOSver% = ((outreg.bx AND 255) * 100) + (outreg.bx \ 256)
IF DOSver% = 0 THEN
  inreg.ax = &H3000
  CALL interrupt(&H21, inreg, outreg)
  DOSver% = ((outreg.ax AND 255) * 100) + (outreg.ax \ 256)
END IF

Info.DOSver% = DOSver%

END FUNCTION

FUNCTION Info.WinMode%

'  (c) Carl Gorringe 1/15/96
'-------------------------------------------------------------
'  Returns the current Windows Mode:
'    0 = Windows not detected
'    1 = Real mode detected (Win 3.0 and earlier only)
'    2 = Standard mode detected. (Win 3.11 and earlier only)
'    3 = 386 enhanced mode detected.
'-------------------------------------------------------------
'<< Done - Tested OK >>

DIM inreg AS RegType, outreg AS RegType

DOSver% = Info.DOSver%

IF DOSver% >= 300 THEN
  inreg.ax = &H160A
  CALL interrupt(&H2F, inreg, outreg)
  IF outreg.ax <> 0 THEN
	 WinMode% = 0
  ELSE
	 WinMode% = outreg.cx
  END IF
END IF

Info.WinMode% = WinMode%

END FUNCTION

REM $STATIC
DEFINT A-Z
FUNCTION InitDS4QB
ClipExist% = Clipboard.Detect%
IF ClipExist% = False THEN
  PRINT "Clipboard not available"
  END
END IF
SHELL "start /m ds4qb.exe"
END FUNCTION

FUNCTION LoadModule (ModuleName AS STRING, Repeat AS INTEGER)
DS4QBbuffer = "DS4QBLOADMOD" + ModuleName + "|" + LTRIM$(RTRIM$(STR$(Repeat)))
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END FUNCTION

FUNCTION LoadSample (SampleName AS STRING)
DS4QBbuffer = "DS4QBLOADSAMPLES" + SampleName + "|"
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END FUNCTION

FUNCTION LoadStream (FileName AS STRING, Repeat AS INTEGER)
DS4QBbuffer = "DS4QBLOADSTREAM" + FileName + "|" + LTRIM$(RTRIM$(STR$(Repeat)))
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END FUNCTION

FUNCTION PlayCD (Track AS INTEGER, Repeat AS INTEGER)
tracky$ = LTRIM$(RTRIM$(STR$(Track)))
IF LEN(tracky$) = 1 THEN tracky$ = "0" + tracky$
DS4QBbuffer = "DS4QBPLAYCD" + tracky$ + "|" + LTRIM$(RTRIM$(STR$(Repeat)))
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END FUNCTION

FUNCTION PlaySample (SampleNumber AS INTEGER)
DS4QBbuffer = "DS4QBPLAYSAMPLE" + LTRIM$(RTRIM$(STR$(SampleNumber))) + "|"
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END FUNCTION

FUNCTION RemoveModule
DS4QBbuffer = "DS4QBREMOVEMODULE|"
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END FUNCTION

FUNCTION RemoveSample
DS4QBbuffer = "DS4QBREMOVESAMPLES|"
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END FUNCTION

FUNCTION RemoveStream
DS4QBbuffer = "DS4QBREMOVESTREAM|"
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END FUNCTION

SUB ShutdownDS4QB
DS4QBbuffer = "DS4QBSHUTDOWN|"
CALL Clipboard.PutText(DS4QBbuffer, ErrCode%)
END SUB

FUNCTION StopModule

END FUNCTION

