MODEL MEDIUM,BASIC
.STACK 30H
.386
.CODE

;FUNCTION RELCOLLIDESPRB%(BYVAL SPR1X%,BYVAL SPR1Y%,BYVAL SPR1SEGMENT%,BYVAL SPR1OFFSET%,BYVAL SPR2X%,BYVAL SPR2Y%,BYVAL SPR2SEGMENT%,BYVAL SPR2OFFSET%)
;RETURNS -1 SPRITES COLLIDED BOX BY BOX, 0 IF OTHERWISE

;STACK
;SPR1X          =22
;SPR1Y          =20  
;SPR1SEG        =18
;SPR1OFFSET     =16
;SPR2X          =14
;SPR2Y          =12  
;SPR2SEG        =10
;SPR2OFFSET     =8
;RET SEG        =6
;RET OFF        =4
;BP             =2
;DS             =0
;SPR1WIDTH      =-2
;SPR1HEIGHT     =-4
;SPR2WIDTH      =-6
;SPR2HEIGHT     =-8



;DS:SI          =SPR1 SEG:SPR1 OFF
;ES:DI          =SPR2 SEG:SPR2 OFF


PUBLIC RELCOLLIDESPRB
RELCOLLIDESPRB PROC

PUSH BP
PUSH DS


MOV BP,SP	;POINT STACK POINTER TO BP

MOV DS,[BP+18]  ;POINT ADDRESS OF SPR1 TO DS
MOV ES,[BP+10]  ;POINT ADDRESS OF SPR2 TO ES


MOV SI,[BP+16]  ;WE ARE NOW ON THE WIDTH OF THE SPR1 W=(ARRAY(0)/8)-1
MOV DI,[BP+8]   ;WE ARE NOW ON THE WIDTH OF THE SPR2 W=(ARRAY(0)/8)-1
                ;SPR1 X1
MOV AX,[SI]     ;WIDTH*8
SHR AX,3        ;DIV WIDTH BY 8
ADD AX,[BP+22]  ;ADD SPR1X TO WIDTH TO GET SPR1X2
DEC AX
CMP AX,[BP+14]          ;IS SPR1X2<SPR2X1
JL LBL_NO_COLLISION     ;ELSE END IT
                ;SPR1Y1
MOV BX,[SI+2]   ;SAVE SPR1 HEIGHT
ADD BX,[BP+20]  ;ADD SPR1Y TO HEIGHT TO GET SPR1Y2
DEC BX
CMP BX,[BP+12]
JL LBL_NO_COLLISION     ;ELSE END IT


;SPR2WIDTH
MOV CX,[DI]     ;WIDTH*8
SHR CX,3        ;DIV WIDTH BY 8
DEC CX
ADD CX,[BP+14]
CMP CX,[BP+22]
JL LBL_NO_COLLISION     ;ELSE END IT

MOV DX,[DI+2]   ;SAVE SPR2 HEIGHT
DEC DX
ADD DX,[BP+12]
CMP DX,[BP+20]
JL LBL_NO_COLLISION     ;ELSE END IT



;================================
;AX=SPR1 X2
;BX=SPR1 Y2
;CX=SPR2 X2
;DX=SPR2 Y2

;CMP AX,CX               ;SPR1X2<SPR2X2 ?
;JG LBL_NO_COLLISION     ;ELSE END IT
;CMP BX,DX               ;SAME AS ABOVE BUT
;JG LBL_NO_COLLISION     ;SPR1Y2 AND SPR2Y2
;SUB CX,AX               ;SPR2X2-SPR1X2
;CMP CX,[BP-6]           ;IS IT > SPR2WIDTH?
;JG LBL_NO_COLLISION     ;NO COLLIDE IF GREATER
;SUB DX,BX               ;SPR2Y2-SPR1Y2
;CMP DX,[BP-8]
;JG LBL_NO_COLLISION


MOV AX,-1
POP DS
POP BP
RET 16

LBL_NO_COLLISION:               ;NO COLLISION

XOR AX,AX
POP DS
POP BP
RET 16

RELCOLLIDESPRB ENDP

END

