'**************************************************
'*This program generates and displays 1-D cellular automata
'*The default starting condition is a single white block in the middle of a black row.
'*The starting condition can be easily changed within the code.  An example that uses a random string
'*as the starting condition has been left commented out of the code.
'*Copyright Joe Campbell. Feb 9-10, 2003
'*Stephen Wolfram's 'A New Kind of Science' is acknowledged as the motivation
'*for writing this code.
'***************************************************
'if a width greater than 1280 is used, you can zoom in and out using "+" & "-"
'you can shift the plot right and left using "<" & ">"
'<SPACE> will recenter image with zoom set to 1/1
'"q" to quit
'***************************************************
'the initial condition can be modified in the code tagged "INITIAL CINDITION"
'adjusting the initial condition strongly effects the output
'***************************************************
'The "rule" is an 8 bit binary number.  Each digit of the number represents
'one of the eight possible nearest-neighbor configurations of a 1-dimensional
'cellular automata.  The value of each bit determines the color
'of the next block.
'For example,  if the rule is 12, then 00001100 is the binary representation.
'this means that if the neighborhood of a block is:
'(000, 001, 100, 101, 110, 111),
'then on the the next row, the block will be (0).
'If the neighborhood is (010, 011) then the next row will have a (1) in that position.
'Sample rules...18 produces a nesting pattern. 30 produces pseudo random data.
'rule 110 produces complex behavior.
'***********************************************

DEFINT A-Z
counter# = 0                        'long integer
scalen = 1
SCREEN 11                           'screen mode for 640x480 b&w display
INPUT "array width(max=30000, default=640)"; size
IF size > 32000 THEN size = 640
IF size < 1 THEN size = 640
DIM rowa(0 TO size) AS INTEGER      'arrays used to process the rules
DIM rowb(0 TO size) AS INTEGER

scalex = size \ 640

DO                                     'get input
INPUT "rule to use (0 to 255)"; rule
IF rule > 255 OR rule < 0 THEN PRINT "try again"
LOOP UNTIL rule < 256 AND rule > -1
CLS

temprule = rule                            'generate case variables (0 or 1) based on the "rule"
                                            
c0 = temprule \ 128                        'use for integer division
IF c0 THEN temprule = temprule - 128       'to generate the binary digit sequence from the "rule"

c1 = temprule \ 64
IF c1 THEN temprule = temprule - 64

c2 = temprule \ 32
IF c2 THEN temprule = temprule - 32

c3 = temprule \ 16
IF c3 THEN temprule = temprule - 16

c4 = temprule \ 8
IF c4 THEN temprule = temprule - 8

c5 = temprule \ 4
IF c5 THEN temprule = temprule - 4

c6 = temprule \ 2
IF c6 THEN temprule = temprule - 2

c7 = temprule \ 1
IF c7 THEN temprule = temprule - 1


CLS
LOCATE 1, 1: PRINT "rule:"; rule; " ="; c0; c1; c2; c3; c4; c5; c6; c7, "generation:"
LOCATE 2, 1: PRINT "zoom(+/-)", scalen; "/"; scalex
LOCATE 2, 40: PRINT "Offset(<>)", offset

'vvvvvvvvvvvvvvvvvvv INITIAL CONDITION vvvvvvvvvvvvvv

'RANDOMIZE TIMER
'FOR z = 100 TO 108     '1 byte of random data
'rowa(z) = RND
'NEXT z

rowa(size / 2) = 1       'single white block in middle of field

'^^^^^^^^^^^^^^^^^^^^INITIAL CONDITION^^^^^^^^^^^^^^^

DO
FOR y = 31 TO 475 STEP 1        '31 offset allows test at top to persist
FOR x = 1 TO size STEP 1        'scans the row and evaluates cell neighborhood

                                'a=left cell; b=middle cell; c=right cell

SELECT CASE x            'this is to deal with wrapping output.  if wrapping not needed, only use CASE ELSE
 CASE 1                  'wrap left
  a = rowa(size)
  b = rowa(x)
  c = rowa(x + 1)
 CASE size               'wrap right
  a = rowa(x - 1)
  b = rowa(x)
  c = rowa(1)
 CASE ELSE
  a = rowa(x - 1)
  b = rowa(x)
  c = rowa(x + 1)
END SELECT

neighborhood = (a * 4) + (b * 2) + (c)       'generate a 3 bit binary based on nearest neighbors

SELECT CASE neighborhood                     'evaluate the neighborhood and apply the "rule"
 CASE 0                                      'to the next row
  rowb(x) = c7
 CASE 1
  rowb(x) = c6
 CASE 2
  rowb(x) = c5
 CASE 3
  rowb(x) = c4
 CASE 4
  rowb(x) = c3
 CASE 5
  rowb(x) = c2
 CASE 6
  rowb(x) = c1
 CASE 7
  rowb(x) = c0
END SELECT
NEXT x

FOR g = 1 TO size                     'screen output & move Array rowb() values to rowa() for use at next row calculation
 PSET ((g * scalen \ scalex) - offset, y), rowb(g)
 SWAP rowa(g), rowb(g)

NEXT g
a$ = INKEY$
SELECT CASE a$
 CASE ""
 CASE "="
  IF scalex > 1 THEN scalex = scalex - 1 ELSE sclaen = scalen + 1
  LOCATE 2, 1: PRINT "zoom(+/-)", scalen; "/"; scalex
 CASE "-"
  IF scalen > 1 THEN scalen = scalen - 1 ELSE scalex = scalex + 1
  LOCATE 2, 1: PRINT "zoom(+/-)", scalen; "/"; scalex
 CASE "."
 offset = offset + 100
 LOCATE 2, 40: PRINT "Offset(<>)", offset
 CASE ","
 offset = offset - 100
 LOCATE 2, 40: PRINT "Offset(<>)", offset
 CASE " "
 scalex = 1
 scalen = 1
 offset = 0
 LOCATE 2, 1: PRINT "zoom(+/-)", scalen; "/"; scalex
 LOCATE 2, 40: PRINT "Offset(<>)", offset
 CASE "q"
  END
END SELECT
NEXT y                                'row complete...goto next row
counter# = counter# + 445
LOCATE 1, 53: PRINT counter#
LOOP 'UNTIL INKEY$ <> ""               'screen filled.  start printing from top
END


