;----------------------------------------------------------------------------
;
;  CosmoX XMS Handling Module
;
;  Part of the CosmoX Library v1.4
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

.386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

XMSMoveStruct STRUC
  XMSLength   DD  ?
  SHandle     DW  ?
  SOffset     DD  ?
  DHandle     DW  ?
  DOffset     DD  ?
XMSMoveStruct ENDS

.DATA

ALIGN 2

XMSAPI              DD  ?               ;  XMS Manager Address
XMSMove             XMSMoveStruct <>    ;  XMS Move Struct

.CODE

PUBLIC  CSDetectXMS, CSFreeXMS, CSAllocateXMS, CSDeallocateXMS, CSMoveToXMS
PUBLIC  CSMoveFromXMS, CSTotalXMS, CSResizeXMS, CSXMSHandles, CSMoveXMS
PUBLIC  xCSGetXMSVer, CSXFreeXMS, CSXTotalXMS, CSXAllocateXMS, CSXResizeXMS

CSDetectXMS PROC
  MOV AX, 4300h
  INT 2Fh
  CMP AL, 80h
  JNE NoXMS
  MOV AX, 4310h
  INT 2Fh
  MOV WORD PTR [XMSAPI], BX
  MOV WORD PTR [XMSAPI+2], ES
  MOV AX, 1
  RET
NoXMS:
  XOR AX, AX
  RET
CSDetectXMS ENDP

xCSGetXMSVer PROC
  XOR AX, AX
  CALL [XMSAPI]
  RET
xCSGetXMSVer ENDP

CSFreeXMS PROC
  MOV AH, 08h
  CALL [XMSAPI]
  XOR DX, DX
  RET
CSFreeXMS ENDP

CSTotalXMS PROC
  MOV AH, 08h
  CALL [XMSAPI]
  MOV AX, DX
  XOR DX, DX
  RET
CSTotalXMS ENDP

CSAllocateXMS PROC
  PUSH BP
  MOV BP, SP
  MOV DX, [BP+06]
  MOV AH, 09h
  CALL [XMSAPI]
  OR  AX, AX
  JZ  EndAllocate
  MOV AX, DX
EndAllocate:
  POP BP
  RET 4
CSAllocateXMS ENDP

CSDeallocateXMS PROC
  PUSH BP
  MOV BP, SP
  MOV DX, [BP+06]
  MOV AH, 0Ah
  CALL [XMSAPI]
  POP BP
  RET 2
CSDeallocateXMS ENDP

CSResizeXMS PROC
  PUSH BP
  MOV BP, SP
  MOV BX, [BP+06]
  MOV DX, [BP+10]
  XOR AX, AX
  MOV AH, 0Fh
  CALL [XMSAPI]
  POP BP
  RET 6
CSResizeXMS ENDP

CSXMSHandles PROC
  XOR CX, CX
  MOV AH, 09h
  MOV DX, 1
  CALL [XMSAPI]
  OR  AX, AX
  JZ  EndXMSHandles
  MOV SI, DX
  MOV AH, 0Eh
  CALL [XMSAPI]
  MOV DX, SI
  OR  AX, AX
  JZ  FreeTempHandle
  MOV CL, BL
  INC CL
FreeTempHandle:
  MOV AH, 0Ah
  CALL [XMSAPI]
EndXMSHandles:
  MOV AX, CX
  RET
CSXMSHandles ENDP

CSMoveToXMS PROC
  PUSH BP
  MOV BP, SP
  MOV DX, DS
  XOR AX, AX
  MOV XMSMove.SHandle, AX
  MOV EAX, [BP+18]
  MOV XMSMOVE.SOffset, EAX
  MOV AX, [BP+14]
  MOV XMSMove.DHandle, AX
  MOV EAX, [BP+10]
  MOV XMSMOVE.DOffset, EAX
  MOV EAX, [BP+06]
  AND AL, 0FEh
  MOV XMSMOVE.XMSLength, EAX
  MOV AX, SEG XMSMove
  MOV DS, AX
  MOV SI, OFFSET XMSMove
  XOR AX, AX
  MOV AH, 0Bh
  CALL [XMSAPI]
  MOV DS, DX
  POP BP
  RET 16
CSMoveToXMS ENDP

CSMoveFromXMS PROC
  PUSH BP
  MOV BP, SP
  MOV DX, DS
  XOR AX, AX
  MOV XMSMOVE.DHandle, AX
  MOV EAX, [BP+18]
  MOV XMSMove.DOffset, EAX
  MOV AX, [BP+14]
  MOV XMSMOVE.SHandle, AX
  MOV EAX, [BP+10]
  MOV XMSMOVE.SOffset, EAX
  MOV EAX, [BP+06]
  AND AL, 0FEh
  MOV XMSMove.XMSLength, EAX
  MOV AX, SEG XMSMove
  MOV DS, AX
  MOV SI, OFFSET XMSMove
  XOR AX, AX
  MOV AH, 0Bh
  CALL [XMSAPI]
  MOV DS, DX
  POP BP
  RET 16
CSMoveFromXMS ENDP

CSMoveXMS PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV DX, DS
  MOV AX, [BP+22]
  MOV XMSMOVE.SHandle, AX
  MOV EAX, [BP+18]
  MOV XMSMOVE.SOffset, EAX
  MOV AX, [BP+16]
  MOV XMSMOVE.DHandle, AX
  MOV EAX, [BP+12]
  MOV XMSMove.DOffset, EAX
  MOV EAX, [BP+08]
  AND AL, 0FEh
  MOV XMSMove.XMSLength, EAX
  MOV AX, SEG XMSMove
  MOV DS, AX
  MOV SI, OFFSET XMSMove
  XOR AX, AX
  MOV AH, 0Bh
  CALL [XMSAPI]
  POP DS
  POP BP
  RET 16
CSMoveXMS ENDP

CSXFreeXMS PROC
  MOV AH, 88h
  CALL [XMSAPI]
  OR  BL, BL
  JS  NoXFreeMemory
  MOV EDX, EAX
  SHR EDX, 16
  RET
NoXFreeMemory:
  MOV DX, 0FFFFh
  MOV AX, 0FFFFh
  RET
CSXFreeXMS ENDP

CSXTotalXMS PROC
  MOV AH, 88h
  CALL [XMSAPI]
  OR  BL, BL
  JS  NoXTotalMemory
  MOV EAX, EDX
  SHR EDX, 16
  RET
NoXTotalMemory:
  MOV DX, 0FFFFh
  MOV AX, 0FFFFh
  RET
CSXTotalXMS ENDP

CSXAllocateXMS PROC
  PUSH BP
  MOV BP, SP
  MOV AH, 89h
  MOV EDX, [BP+06]
  CALL [XMSAPI]
  OR  BL, BL
  JS  NoXAllocateXMS
  OR  AX, AX
  JZ  NoXAllocateXMS
  MOV AX, DX
  POP BP
  RET 4
NoXAllocateXMS:
  MOV AX, 0FFFFh
  POP BP
  RET 4
CSXAllocateXMS ENDP

CSXResizeXMS PROC
  PUSH BP
  MOV BP, SP
  MOV AH, 8Fh
  MOV DX, [BP+10]
  MOV EBX, [BP+06]
  CALL [XMSAPI]
  OR  BL, BL
  JNS EndXResizeXMS
  MOV AX, 0FFFFh
EndXResizeXMS:
  POP BP
  RET 6
CSXResizeXMS ENDP


END
