; ---------------------------------------------------------------------------
;
; DirectQB: a game programming library for QuickBasic 4.5
;                                 (but it could be easily adapted to your
;                                  own programming language!)
;
;       MAIN MODULE
;
; version 1.61 - June, the 1st 1999
; by Angelo Mottola - Enhanced Creations 1998-99
;
;
; For a complete list of the new features, read the file DIRECTQB.DOC provided
; with this new DirectQB distribuition.
;
; Comments, hints, bomb-mails or anything else are to be sent to:
;
; Angelo Mottola
; angelillo@bigfoot.com
;
; Or you can contact me via ICQ
;
; My ICQ number: 24084401
; ICQ Pager: 24084401@pager.mirabilis.com
;
; Check out the latest DirectQB updates at
;
; The QuickBasic Enhanced Programming Homepage
; http://ec.quickbasic.com
;
; I cannot check my mail everyday; this means that you must wait for a reply,
; so don't get angry if you don't get it soon. Anyway I'll try to answer to
; all your questions! To get a quick answer, contact me via ICQ or, if you
; haven't ICQ (download it now!), send a normal e-mail message to my ICQ pager
; address. This message will arrive to my ICQ client and I'll be able to see
; it while online; just remember that messages sent via the ICQ pager must
; not be longer than 450 characters!
; 
; Thanks again for using DirectQB!!
;
; ***************************************************************************

; Let's use a medium memory model...
.MODEL medium,basic

; ...and 386 instructions!
.386

; 256 bytes of stack are enough for us!
.STACK 100h

EMSmoveStruc STRUC
  len         DD  ?
  sourceType  DB  ?
  sourceHdl   DW  ?
  sourceOff   DW  ?
  sourceSegPg DW  ?
  destType    DB  ?
  destHdl     DW  ?
  destOff     DW  ?
  destSegPg   DW  ?
EMSmoveStruc ENDS


; *** Data ***
.DATA

; Global variables
PUBLIC LibVersion
PUBLIC SoundActive,SoundPage,NumSounds,SoundLen,VolActive,VolSeg,BaseAddr,IRQ
PUBLIC PicORmask,OldIRQseg,OldIRQoff,OldInt24seg,OldInt24off,LastError


LibVersion    DW  0013Dh          ; DirectQB library version
LibActive     DB  0               ; Has the library been initialized?
DataPage      DW  ?               ; Starting data EMS logical page
VGAon         DB  0               ; Are we in VGA mode?
PutMode       DW  0               ; Sprite put mode (0:transparent, 1:solid)
Buffer        DB  ?               ; File I/O byte buffer
KeyActive     DB  0               ; Is the keyboard handler already active?
OldInt9seg    DW  ?               ; Original int 9h segment
OldInt9off    DW  ?               ; Original int 9h offset
KeyFlags      DB  ?               ; Original keyboard flags status
SoundActive   DB  0               ; Has the SB custom IRQ been installed?
SoundPage     DW  ?               ; EMS page where sounds data begins
NumSounds     DB  0               ; Number of allocated sounds
BaseAddr      DW  0220h           ; SB base address
IRQ           DB  7               ; SB IRQ
VolActive     DB  0               ; Has volume table been installed?
VolSeg        DW  0               ; Volume table segment
PicORmask     DB  ?               ; OR pic mask to set IRQ
OldIRQseg     DW  ?               ; Old IRQ interrupt segment
OldIRQoff     DW  ?               ; Old IRQ interrupt offset
SoundLen      DW  256 dup(0)      ; Sounds length (256 sounds allowed)
OldInt24seg   DW  ?               ; Original int 24h segment
OldInt24off   DW  ?               ; Original int 24h offset
TimerActive   DB  0               ; Has the custom timer ISR been installed?
TimerFlag     DB  0               ; Internal timer flag
TimerCount    DD  ?               ; Timer counter
ElapsedTicks  DD  ?               ; Number of elapsed clock ticks
OldInt8       DD  ?               ; Old timer ISR address
PackActive    DB  0               ; Is a pack file currently opened?
PackFile      DW  ?               ; Current pack file handle
LastError     DB  29              ; Last error code number
;INCLUDE errors.inc                ; Error messages

; Code begins here!
.CODE


; ***************************************************************************
; Public library procedures
; ***************************************************************************


; ---------------------------------------------------------------------------
; DQBinit FUNCTION
; purpose:
;   Initializes the library, by allocating the needed amount of EMS memory
;   to store layers (if requested). Also checks if a 386 CPU is available on
;   the system, calibrates the joysticks (where available) and sets up the
;   mouse. On success returns 0, otherwise an error code.
;   Always call this procedure before calling any of the library functions!
; declaration:
;   DECLARE FUNCTION DQBinit(BYVAL NumLayers,BYVAL NumSounds,BYVAL MemSize)
; ---------------------------------------------------------------------------
PUBLIC DQBinit
DQBinit PROC
  ; Stack layout:
  ;
  ; 10  NumLayers
  ; 08  NumSounds
  ; 06  EMSpages
  ; 04  Basic segment
  ; 02  Basic offset
  ; 00  BP
  PUSH BP
  MOV BP,SP
  PUSH DS
;  CMP LibActive,1
;  JE Error_AlreadyUp
  MOV AX,@DATA
  MOV ES,AX
  XOR AX,AX
  ;MOV CX,10
  ;MOV DI,OFFSET BaseSet
  ;REP STOSB
  ;MOV DI,OFFSET FontBuffer
  ;XOR AX,AX
  ;MOV DS,AX
  ;MOV SI,DS:[07Ch]
  ;MOV AX,DS:[07Eh]
  ;SUB SI,1024
  ;MOV DS,AX
  ;MOV CX,512
  ;REP MOVSD
  ;MOV EAX,08080808h
  ;MOV CX,64
  ;MOV DI,OFFSET CharLen
  ;REP STOSD
  ;STOSB
  POP DS
;  PUSHF
;  MOV CX,7000h    ; Set bits 12..15
;  PUSH CX
;  POPF
;  PUSHF           ; Push them again...
;  POP AX          ; ...and get them back
;  AND AX,7000h    ; Mask bits 12..15
;  SETNZ AL
;  XOR AH,AH       ; Zero it
;  POPF
;  TEST AX,AX
;  JE Error_NoCPU
  ;XOR AX,AX
  ;MOV EMSallocated,AX
  ;MOV DX,[BP+10]
  ;SHL DX,2
  ;MOV SoundPage,DX
  ;MOV BX,[BP+8]
  ;SHL BX,2
  ;ADD DX,BX
  ;MOV DataPage,DX
  ;MOV DX,[BP+8]
  ;MOV NumSounds,DL
  ;MOV DX,[BP+10]  ; Let's find out the total amount of EMS needed
  ;ADD DX,[BP+8]
  ;SHL DX,2
  ;MOV BX,[BP+6]
  ;OR BX,BX
; ; JZ SHORT @F
  ;SHR BX,4
;  ;INC BX
;  ;ADD DX,BX
;  jmp MemDone
;Error_AlreadyUp:
;  MOV AX,4        ; Error 4: Library already initialized
;  MOV LastError,0
;  JMP EndInit
;Error_NoCPU:
;  MOV AX,1        ; Error 1: No 386 CPU detected!
;  MOV LastError,1
;  JMP EndInit
;Error_NoEMS:
;  MOV AX,2        ; Error 2: No EMS memory manager detected!
;  MOV LastError,2
;  JMP EndInit
;Error_NotEnoughEMS:
;  MOV AX,3        ; Error 3: Not enough free EMS memory!
;  MOV LastError,3
;  JMP EndInit
MemDone:
 ; CALL ResetJoy
  ;XOR AX,AX
  ;INT 33h
  ;TEST AX,AX
  ;JE MouseDone
  ;MOV CX,31
  ;MOV AX,SEG MouseISR
  ;MOV ES,AX
  ;MOV DX,OFFSET MouseISR
  ;MOV AX,0Ch
  ;INT 33h
  ;MOV MouseDetected,1
  ;JMP MouseDone
;MouseISR:
  ;PUSH DS
  ;MOV AX,@DATA
  ;MOV DS,AX
  ;MOV MouseX,CX
  ;MOV MouseY,DX
  ;MOV MouseBut,BL
;  POP DS
;  RET
;MouseDone:
  MOV LibActive,1
;  XOR AX,AX
EndInit:
  POP BP
  RET 6
DQBinit ENDP

; ---------------------------------------------------------------------------
; DQBver FUNCTION
; purpose:
;   Returns the library version number in hexadecimal format; the higher byte
;   is the major release number, and the lower byte is the minor release
;   number.
; declaration:
;   DECLARE FUNCTION DQBver()
; ---------------------------------------------------------------------------
PUBLIC DQBver
DQBver PROC
  MOV AX,LibVersion
  RET
DQBver ENDP

; ---------------------------------------------------------------------------
; DQBclose SUB
; purpose:
;   Deallocates previously allocated EMS memory (if it was allocated), and
;   does other closing stuff needed.
;   ALWAYS CALL THIS SUB BEFORE ENDING YOUR PROGRAMS!
; declaration:
;   DECLARE SUB DQBclose()
; ---------------------------------------------------------------------------
PUBLIC DQBclose
DQBclose PROC
  CMP LibActive,1
  JE SHORT @F
  RET
@@:
;  CMP TimerActive,0
;  JE NoRemoveTimer
;  XOR AX,AX
;  MOV ES,AX
;  CLI
;  MOV EAX,OldInt8
;  MOV ES:[32],EAX
;  STI
;  MOV AL,034h
;  OUT 043h,AL
;  XOR AX,AX
;  OUT 040h,AL
;  OUT 040h,AL
;  MOV TimerActive,0
;NoRemoveTimer:
;  CMP KeyActive,0
;  JE NoRemoveKey
;  PUSH DS
;  MOV DX,OldInt9off
;  MOV AX,OldInt9seg
;  MOV DS,AX
;  MOV AX,2509h
;  INT 21h
;  POP DS
;  MOV BL,KeyFlags
;  MOV AX,040h
;  MOV ES,AX
;  MOV SI,017h
;  MOV ES:[SI],BL
;  MOV KeyActive,0
;NoRemoveKey:
  CMP SoundActive,0
  JE NoRemoveSB
  MOV DX,BaseAddr
  ADD DX,06h
  MOV AL,1
  OUT DX,AL
  IN AL,DX
  IN AL,DX
  IN AL,DX
  IN AL,DX
  XOR AL,AL
  OUT DX,AL
  ADD DX,08h
  XOR CX,CX
WaitRead1:
  DEC CX
  JZ EndReadDSP1
  IN AL,DX
  OR AL,AL
  JNS WaitRead1
EndReadDSP1:
  SUB DX,4
  IN AL,DX          ; SB reset
  IN AL,021h
  OR AL,PicORmask
  OUT 021h,AL
  XOR AX,AX
  MOV ES,AX
  MOV AL,IRQ
  ADD AL,8
  MOV SI,AX
  SHL SI,2
  CLI
  MOV AX,OldIRQoff
  MOV ES:[SI],AX
  MOV AX,OldIRQseg
  MOV ES:[SI+2],AX  ; Old IRQ restored
  STI
  MOV SoundActive,0
NoRemoveSB:
  CMP VolActive,0
  JE NoRemoveVol
  MOV AH,049h
  MOV BX,VolSeg
  MOV ES,BX
  INT 21h
  MOV VolActive,0
NoRemoveVol:
  RET
DQBclose ENDP

END
