DECLARE SUB setvolume (voice%, vol%)
DECLARE SUB eraseordline (o%)
DECLARE SUB copyordline (o%)
DECLARE SUB pasteordline (o%)
DECLARE SUB puthyp (hyp$, x%, y%)
DECLARE SUB saveinstr ()
DECLARE SUB loadinstr ()
DECLARE SUB putspc (x%, y%, w%, atr%)
DECLARE FUNCTION regscol% (r%)
DECLARE SUB setrgb (c%, r%, g%, b%)
DECLARE SUB insedtoins (i%)
DECLARE SUB playnote (v%, frq%, oct%)
DECLARE SUB stopvoice (v%)
DECLARE SUB setinstr (v%, i AS ANY)
DECLARE SUB oplout (reg%, vlu%)
DECLARE SUB copypattern (p%)
DECLARE SUB pastepattern (p%)
DECLARE SUB loadmod ()
DECLARE SUB eraseinstr (i%)
DECLARE SUB savemod ()
DECLARE SUB message (st$)
DECLARE FUNCTION prompt$ (text$, maxchrs%)
DECLARE FUNCTION readb% (fh%, pso%)
DECLARE SUB writeb (fh%, pso%, b%)
DECLARE FUNCTION getstr$ (x%, y%, atr%, maxchrs%)
DECLARE SUB showinstr ()
DECLARE SUB instoinsed (i%)
DECLARE FUNCTION hexscan% (k%)
DECLARE SUB putatr (x%, y%, atr%)
DECLARE FUNCTION editorder% ()
DECLARE FUNCTION editpattern% ()
DECLARE FUNCTION editinstr% ()
DECLARE FUNCTION getkey% ()
DECLARE SUB atrseg (x%, y%, w%, atr%)
DECLARE SUB box (x%, y%, w%, H%, atr%)
DECLARE SUB putstr (st$, x%, y%, atr%)
DECLARE SUB puthex (vlu%, x%, y%, atr%, dig%)
DECLARE SUB erasepattern (p%)
DECLARE SUB showorder ()
DECLARE SUB chrbar (x%, y%, w%, H%, ch$, atr%)
DECLARE SUB showpattern ()
'$INCLUDE: 'QB.BI'
'$INCLUDE: 'KEYCODES.BI'

'Oh by the way, don't forget to start QB with the /L switch ...
'

CONST modeOrder% = 0
CONST modePattern% = 1
CONST modeInstr% = 2
CONST modeDeath% = 3

CONST iedLeft% = 10
CONST iedTop% = 14
CONST iedWidth% = 40
CONST iedHeight% = 20

CONST icrLeft% = iedLeft% + 15
CONST icrTop% = iedTop% + 4
CONST iedMul1% = 0
CONST iedLev1% = 1
CONST iedAtd1% = 2
CONST iedSur1% = 3
CONST iedVib1% = 4
CONST iedTre1% = 5
CONST iedEgs1% = 6
CONST iedWav1% = 7
CONST iedMul2% = 8
CONST iedLev2% = 9
CONST iedAtd2% = 10
CONST iedSur2% = 11
CONST iedVib2% = 12
CONST iedTre2% = 13
CONST iedEgs2% = 14
CONST iedWav2% = 15
CONST iedFb% = 16
CONST iedCon% = 17


TYPE Instrument
	mul1 AS INTEGER
	mul2 AS INTEGER
	lev1 AS INTEGER
	lev2 AS INTEGER
	atd1 AS INTEGER
	atd2 AS INTEGER
	sur1 AS INTEGER
	sur2 AS INTEGER
	wav1 AS INTEGER
	wav2 AS INTEGER
	fbcon AS INTEGER
END TYPE

DIM SHARED regi AS RegTypeX, rego AS RegTypeX
DIM SHARED length%
DIM SHARED ord(0 TO 8, 0 TO 100) AS INTEGER
DIM SHARED nte(0 TO 63, 0 TO 100) AS INTEGER
DIM SHARED oct(0 TO 63, 0 TO 100) AS INTEGER
DIM SHARED ini(0 TO 63, 0 TO 100) AS INTEGER
DIM SHARED eff(0 TO 63, 0 TO 100) AS INTEGER
DIM SHARED ins(0 TO 31) AS Instrument
DIM SHARED notenm$(0 TO 12)
DIM SHARED paramnm$(0 TO 9)
DIM SHARED stnoyes$(0 TO 1)
DIM SHARED stwav$(0 TO 3)
DIM SHARED stcon$(0 TO 1)
DIM SHARED iedfld(0 TO 17)  AS INTEGER
DIM SHARED keyloct%(0 TO 11), keylovr%(0 TO 4)
DIM SHARED keyhoct%(0 TO 11), keyhovr%(0 TO 4)
DIM SHARED keyhex%(0 TO 15)
DIM SHARED vocofs%(0 TO 8)

DIM SHARED vocnte%(0 TO 8)
DIM SHARED vocfrq%(0 TO 8), vococt%(0 TO 8)
DIM SHARED vocvol%(0 TO 8)
DIM SHARED vocins%(0 TO 8)
DIM SHARED voceff%(0 TO 8)
DIM SHARED vocarpfrq%(0 TO 1, 0 TO 8)
DIM SHARED vocarpoct%(0 TO 1, 0 TO 8)
DIM SHARED vocpsl%(0 TO 8), vocbpsl%(0 TO 8)

DIM SHARED frqtab%(0 TO 11)
DIM SHARED edpos%, edrow%, lmchan%
DIM SHARED edoct%, edins%
DIM SHARED tstnot%, tstoct%
DIM SHARED crsv%, crsc%
DIM SHARED playing%, follow%, ontimer%
DIM SHARED hlporder$, hlppattern$, hlpinstr$

DIM SHARED silence AS Instrument
DIM SHARED secs%, mins%

DATA 0,0
DATA 63,63
DATA 15,15
DATA 0,0
DATA 0,0
DATA 0
READ silence.mul1, silence.mul2
READ silence.lev1, silence.lev2
READ silence.atd1, silence.atd2
READ silence.sur1, silence.sur2
READ silence.wav1, silence.wav2
READ silence.fbcon


DATA "C-","C#","D-","D#","E-","F-"
DATA "F#","G-","G#","A-","A#","H-","..."
FOR i% = 0 TO 12: READ notenm$(i%): NEXT i%

DATA  121, 115, 120, 100, 99, 118, 103, 98
DATA  104, 110, 106, 109
DATA  44, 108, 46, 148, 45
DATA  113, 50, 119, 51, 101, 114, 53, 116
DATA  54, 122, 55, 117
DATA  105, 57, 111, 48, 112
FOR i% = 0 TO 11: READ keyloct%(i%): NEXT i%
FOR i% = 0 TO 4: READ keylovr%(i%): NEXT i%
FOR i% = 0 TO 11: READ keyhoct%(i%): NEXT i%
FOR i% = 0 TO 4: READ keyhovr%(i%): NEXT i%

DATA  48, 49, 50, 51, 52, 53, 54, 55
DATA  56, 57, 97, 98, 99, 100, 101
DATA  102
FOR i% = 0 TO 15: READ keyhex%(i%): NEXT i%

DATA "Multiple","Level","Att / Dec","Sus / Rel"
DATA "Vibrato", "Tremolo", "EG Sustain","Waveform"
DATA "Feedback", "Connection"
FOR i% = 0 TO 9: READ paramnm$(i%): NEXT i%

stnoyes$(0) = "No "
stnoyes$(1) = "Yes"

stwav$(0) = "Sine      "
stwav$(1) = "Half-Sine "
stwav$(2) = "Abs-Sine  "
stwav$(3) = "Pulse-Sine"

stcon$(0) = "Mod Op.1  "
stcon$(1) = "Both sound"

DATA 0,1,2,8,9,10,16,17,18
FOR i% = 0 TO 8: READ vocofs%(i%): NEXT i%

DATA &H157,&H16B,&H181,&H198,&H1B0,&H1CA
DATA &H1E5,&H202,&H220,&H241,&H263,&H287
FOR i% = 0 TO 11: READ frqtab%(i%): NEXT i%

DATA "<1EPattern Editor<n<n"
DATA "<06Cursor,(Sh+)Tab,<n"
DATA "PgUp/Down,Home,End<n"
DATA " <07- move around<n<n"
DATA "<06Ins,Del,Backspace,<n"
DATA " <07- edit<n<n"
DATA "<06F1<07  - edit order<n"
DATA "<06F3<07  - edit instr.<n"
DATA "<06F4<07  - load module<n"
DATA "<06F5<07  - save module<n"
DATA "<06F6<07  - cut ptn.<n"
DATA "<06F7<07  - copy ptn.<n"
DATA "<06F8<07  - paste ptn.<n"
DATA "<06F9<07  - prev. ptn.<n"
DATA "<06F10<07 - next ptn.<n<n"
DATA "<06/<07 - octave down<n"
DATA "<06*<07 - octave up<n"
DATA "<06<<<07 - prev. instrument<n"
DATA "<06><07 - next instrument<n<n"
DATA "<06Space<07 - play"
FOR l% = 1 TO 20
	READ st$
	hlppattern$ = hlppattern$ + st$
NEXT l%

DATA "<1EOrder Editor<n<n"
DATA "<06Cursor,(Sh+)Tab<n"
DATA " <07- move around<n<n"
DATA "<06Ins,Del,0..F<n"
DATA " <07- edit<n<n"
DATA "<06F2<07  - edit pattern<n"
DATA "<06F3<07  - edit instr.<n"
DATA "<06F6<07  - cut line<n"
DATA "<06F7<07  - copy line<n"
DATA "<06F8<07  - paste line<n<n"
DATA "<06-,F9<07  - prev. ptn.<n"
DATA "<06+,F10<07 - next ptn."
FOR l% = 1 TO 12
	READ st$
	hlporder$ = hlporder$ + st$
NEXT l%

DATA "<1EInstr. Editor<n<n"
DATA "<06Cursor,(Sh+)Tab<n"
DATA " <07- move around<n<n"
DATA "<06Cursor,0..F<n"
DATA " <07- edit<n<n"
DATA "<06F1<07  - edit order<n<n"
DATA "<06F2<07  - edit pattern<n"
DATA "<06F4<07  - load instr.<n"
DATA "<06F5<07  - save instr.<n<n"
DATA "<06<<<07 - prev. instrument<n"
DATA "<06><07 - next instrument<n"
DATA "<06-<07 - test note down<n"
DATA "<06+<07 - test note up<n<n"
DATA "<06Space<07<n - play test note"
FOR l% = 1 TO 14
	READ st$
	hlpinstr$ = hlpinstr$ + st$
NEXT l%

regi.ax = 3
CALL InterruptX(&H10, regi, rego)
regi.ax = &H1112
regi.bx = 0
CALL InterruptX(&H10, regi, rego)
regi.ax = &H100
regi.CX = &H2000
CALL InterruptX(&H10, regi, rego)
regi.ax = &H306
regi.bx = 0
CALL InterruptX(&H16, regi, rego)

OUT &H43, &H34
OUT &H40, &H1D
OUT &H40, 5

CALL setrgb(regscol(0), 0, 8, 12)
CALL setrgb(regscol(14), 55, 55, 37)
CALL setrgb(regscol(1), 5, 5, 24)
CALL setrgb(regscol(3), 10, 10, 47)
CALL setrgb(regscol(4), 27, 33, 37)
CALL setrgb(regscol(5), 19, 19, 19)
CALL setrgb(regscol(6), 45, 45, 39)

FOR p% = 0 TO 99
	CALL erasepattern(p%)
NEXT p%

length% = 1
edoct% = 2: edins% = 1
tstnot% = 0: tstoct% = 2
ontimer% = 6
CALL showorder
CALL showpattern

CALL putstr("Octave:", 0, 47, 7)
CALL putstr("Instr.:", 0, 48, 7)
CALL puthex(edoct%, 8, 47, 7, 2)
CALL puthex(edins%, 8, 48, 7, 2)

CALL putstr(".-* Beni Tracker 1.3 *-.", 18, 0, 14)
CALL putstr("programmed in pure QB4.5 by one guy from SPP", 8, 1, 14)


mode% = modePattern
WHILE mode% <> modeDeath
	SELECT CASE mode%
	CASE modeOrder: mode% = editorder
	CASE modePattern: mode% = editpattern
	CASE modeInstr: mode% = editinstr
	END SELECT
WEND

CLS
regi.ax = &H100
regi.CX = &HE0F
CALL InterruptX(&H10, regi, rego)
END


'PLAYER ROUTINE
'To be called 50 times / second
'Supported effects so far:
'
'0xx - Arpeggio (AYEAH!)
'1xx - pitch slide up
'2xx - pitch slide down
'Bxx - jump to position xx
'Cxx - set volume
'Dxx - jump to row xx in next position
'E6x - repeat x times from E60
'F0x - set speed
'
Frame:
IF nthframe = ontimer% THEN
	FOR v% = 0 TO 8
		pi% = ord(v%, edpos%)
		n% = nte(edrow%, pi%)
		o% = oct(edrow%, pi%)
		i% = ini(edrow%, pi%)
		e% = eff(edrow%, pi%)
		e1% = e% \ 256
		IF e1% = &HC THEN
			cxx% = 1: vol% = e% AND 255
		END IF
		IF i% <> 0 THEN
			IF n% <> 12 THEN
				CALL stopvoice(v%)
				IF vocins%(v%) <> i% THEN
					CALL setinstr(v%, ins(i%))
					vocins%(v%) = i%
				END IF
				IF cxx% THEN
					CALL setvolume(v%, vol%)
					cxx% = 0
				ELSEIF vocvol%(v%) < 64 THEN
					CALL setvolume(v%, 64)
				END IF
				CALL playnote(v%, frqtab%(n%), o%)
				vocfrq%(v%) = frqtab%(n%)
				vocnte%(v%) = n%
				vococt%(v%) = o%
		  
				vocbpsl%(v%) = 0
				vocpsl%(v%) = 0

			ELSE
				CALL setinstr(v%, ins(i%))
				vocins%(v%) = i%
				IF cxx% THEN
					CALL setvolume(v%, vol%)
					cxx% = 0
				ELSEIF vocvol%(v%) < 64 THEN
					CALL setvolume(v%, vocvol%(v%))
				END IF
			END IF
		ELSE
			IF n% <> 12 THEN
				CALL stopvoice(v%)
				CALL playnote(v%, frqtab%(n%), o%)
				vocfrq%(v%) = frqtab%(n%)
				vocnte%(v%) = n%
				vococt%(v%) = o%
				vocbpsl%(v%) = 0
				vocpsl%(v%) = 0

			ELSE
				IF cxx% THEN
					CALL setvolume(v%, vol%)
					cxx% = 0
				END IF
			END IF
		END IF
		voceff%(v%) = e%
	NEXT v%

	jumpflag% = 0

	FOR v% = 0 TO 8
		vocbarp%(v%) = 0
		e% = voceff%(v%)
		e1% = e% \ 256
		SELECT CASE e1%
		CASE 0:
			IF ((e% AND 255) > 0) THEN
				arpadd% = (e% \ 16) AND 15
				arpnte% = vocnte%(v%) + arpadd%
				vocarpoct%(0, v%) = vococt%(v%)
				IF arpnte% > 11 THEN
					arpnte% = arpnte% - 12
					vocarpoct%(0, v%) = vocarpoct%(0, v%) + 1
				END IF
				vocarpfrq%(0, v%) = frqtab%(arpnte%)
				arpadd% = e% AND 15
				arpnte% = vocnte%(v%) + arpadd%
				vocarpoct%(1, v%) = vococt%(v%)
				IF arpnte% > 11 THEN
					arpnte% = arpnte% - 12
					vocarpoct%(1, v%) = vocarpoct%(1, v%) + 1
				END IF
				vocarpfrq%(1, v%) = frqtab%(arpnte%)
				vocbarp%(v%) = 1
			END IF
		CASE 1:
			vocpsl%(v%) = vocpsl%(v%) + (e% AND 255)
			vocbpsl%(v%) = 1
		CASE 2:
			vocpsl%(v%) = vocpsl%(v%) - (e% AND 255)
			vocbpsl%(v%) = 1
		CASE &HB:
			npos% = e% AND 255
			IF npos% < length% THEN bxx% = 1
		CASE &HD:
			nrow% = e% AND 255
			IF nrow% < 64 THEN dxx% = 1
		CASE &HE:
			IF ((e% \ 16) AND 15) = 6 THEN
				IF e6x% = 0 THEN
					IF ((e% AND 15) = 0) THEN
						e6xrow% = edrow%
					ELSE
						e6xcount% = e% AND 15
						e6x% = 1
					END IF
				END IF
				IF e6x% = 1 THEN
					IF ((e% AND 15) > 0) THEN
						e6xcount% = e6xcount% - 1
						IF e6xcount% >= 0 THEN
							edrow% = e6xrow% - 1
						ELSE
							e6x% = 0
						END IF
					END IF
				END IF
			END IF
		CASE &HF:
			ontimer% = e% AND 15
		END SELECT
	NEXT v%

	IF bxx% THEN
		edpos% = npos%
		edrow% = -1
		IF follow% = 1 THEN CALL showorder
		bxx% = 0
		jumpflag% = 1
	END IF

	IF dxx% THEN
		IF jumpflag% = 0 THEN edpos% = edpos% + 1
		IF edpos% = length% THEN edpos% = 0
		edrow% = nrow% - 1
		dxx% = 0
	END IF

	edrow% = edrow% + 1
	IF edrow% = 64 THEN
		edpos% = edpos% + 1
		IF edpos% = length% THEN edpos% = 0
		edrow% = 0
		IF follow% = 1 THEN CALL showorder
	END IF
	IF follow% = 1 THEN CALL showpattern
	nthframe = 0
END IF

arppos% = tick% MOD 3

FOR v% = 0 TO 8
	IF vocbarp%(v%) THEN
		IF arppos% THEN
			frq% = vocarpfrq%(arppos% - 1, v%)
			oct% = vocarpoct%(arppos% - 1, v%)
		ELSE
			frq% = vocfrq%(v%)
			oct% = vococt%(v%)
		END IF
		IF vocbpsl%(v%) THEN
			CALL playnote(v%, frq% + vocpsl%(v%), oct%)
		ELSE
			CALL playnote(v%, frq%, oct%)
		END IF
	ELSE
		IF vocbpsl%(v%) THEN
			CALL playnote(v%, vocfrq%(v%) + vocpsl%(v%), vococt%(v%))
		END IF
	END IF
NEXT v%

nthframe = nthframe + 1
tick% = (tick% + 1) AND 16383

zuck% = zuck% + 1
IF zuck% = 50 THEN
	secs% = secs% + 1
	IF secs% = 60 THEN
		mins% = mins% + 1
		secs% = 0
	END IF

	stsec$ = STR$(secs%)
	stmin$ = STR$(mins%)
	IF secs% < 10 THEN stsec$ = " 0" + MID$(stsec$, 2, 1)
	IF mins% < 10 THEN stmin$ = " 0" + MID$(stmin$, 2, 1)

	sttime$ = stmin$ + ":" + RIGHT$(stsec$, 2) + SPACE$(10)
	CALL putstr(sttime$, 59, 3, &H5E)
	zuck% = 0
END IF

RETURN

SUB atrseg (x%, y%, w%, atr%)
	ofs% = (2 * ((80 * y%) + x%)) + 1
	DEF SEG = &HB800
	WHILE w%
		w% = w% - 1
		POKE ofs%, atr%
		ofs% = ofs% + 2
	WEND
END SUB

SUB box (x%, y%, w%, H%, atr%)
	H% = H% - 2
	w% = w% - 1
	IF H% < 2 THEN EXIT SUB
	IF w% < 2 THEN EXIT SUB
	o1% = 2 * ((80 * y%) + x%)
	o2% = o1% + w% + w%
	o3% = o1%
	w% = w% - 1
	DEF SEG = &HB800
	POKE o1%, 218: POKE o1% + 1, atr%
	POKE o2%, 191: POKE o2% + 1, atr%
	o1% = o1% + 160
	o2% = o2% + 160
	WHILE H%
		H% = H% - 1
		POKE o1%, 179: POKE o1% + 1, atr%
		POKE o2%, 179: POKE o2% + 1, atr%
		o1% = o1% + 160
		o2% = o2% + 160
	WEND
	POKE o1%, 192: POKE o1% + 1, atr%
	POKE o2%, 217: POKE o2% + 1, atr%
	WHILE w%
		w% = w% - 1
		o3% = o3% + 2
		o2% = o2% - 2
		POKE o3%, 196: POKE o3% + 1, atr%
		POKE o2%, 196: POKE o2% + 1, atr%
	WEND
END SUB

SUB chrbar (x%, y%, w%, H%, ch$, atr%)
	ofs% = 2 * ((80 * y%) + x%)
	mdo% = 160 - w% - w%
	a% = ASC(ch$)
	DEF SEG = &HB800
	WHILE H%
		H% = H% - 1
		FOR x% = 1 TO w%
			POKE ofs%, a%
			ofs% = ofs% + 1
			POKE ofs%, atr%
			ofs% = ofs% + 1
		NEXT x%
		ofs% = ofs% + mdo%
	WEND
END SUB

SUB copyordline (o%)
	FOR v% = 0 TO 8
		ord(v%, 100) = ord(v%, o%)
	NEXT v%
END SUB

SUB copypattern (p%)
	FOR r% = 0 TO 63
		nte(r%, 100) = nte(r%, p%)
		oct(r%, 100) = oct(r%, p%)
		ini(r%, 100) = ini(r%, p%)
		eff(r%, 100) = eff(r%, p%)
	NEXT r%
END SUB

FUNCTION editinstr%

follow% = 0

icrop% = 0
icrc% = 0
icrr% = 0
icrfld% = 0

CALL chrbar(iedLeft, iedTop, iedWidth, iedHeight, " ", 0)
CALL box(iedLeft - 1, iedTop - 1, iedWidth + 2, iedHeight + 2, &H5E)
x% = iedLeft + 1
y% = iedTop + 4
FOR p% = 0 TO 9
	CALL putstr(paramnm$(p%), x%, y%, 7)
	y% = y% + 1
NEXT p%
CALL putstr("Op.1", iedLeft + 15, iedTop + 2, 7)
CALL putstr("Op.2", iedLeft + 27, iedTop + 2, 7)
CALL instoinsed(edins%)
CALL showinstr
CALL atrseg(icrLeft, icrTop, 10, &H17)
CALL putstr("Test note:", iedLeft + 1, 32, 7)
CALL putstr(notenm$(tstnot%), iedLeft + 12, 32, 7)
CALL puthex(tstoct%, iedLeft + 14, 32, 7, 1)
CALL putatr(icrLeft + icrc% + (12 * icrop%), icrTop + icrr%, &H3E)

CALL chrbar(59, 7, 21, 43, " ", 0)
CALL puthyp(hlpinstr$, 59, 10)

WHILE 1
iedgetnextkey:
	k% = getkey
	SELECT CASE k%
	CASE keyF1
		follow% = 1
		CALL insedtoins(edins%)
		FOR v% = 0 TO 8
			IF vocins%(v%) = edins% THEN CALL setinstr(v%, ins(edins%))
		NEXT v%
		CALL stopvoice(0)
		CALL chrbar(0, 11, 58, 33, " ", 0)
		CALL showpattern
		editinstr% = modeOrder
		EXIT FUNCTION
	CASE keyF2
		follow% = 1
		CALL insedtoins(edins%)
		FOR v% = 0 TO 8
		  IF vocins%(v%) = edins% THEN CALL setinstr(v%, ins(edins%))
		NEXT v%
		CALL stopvoice(0)
		CALL chrbar(0, 11, 58, 33, " ", 0)
		CALL showpattern
		editinstr% = modePattern
		EXIT FUNCTION
	CASE keyDown
		IF icrr% < 9 THEN
			CALL atrseg(icrLeft + (12 * icrop%), icrTop + icrr%, 10, 7)
			icrr% = icrr% + 1: crsupd% = 1
		END IF
	CASE keyUp
		IF icrr% THEN
			CALL atrseg(icrLeft + (12 * icrop%), icrTop + icrr%, 10, 7)
			icrr% = icrr% - 1: crsupd% = 1
		END IF
	CASE keyShTab
		CALL atrseg(icrLeft + (12 * icrop%), icrTop + icrr%, 10, 7)
		icrop% = icrop% XOR 1
		crsupd% = 1
	CASE keyTab
		CALL atrseg(icrLeft + (12 * icrop%), icrTop + icrr%, 10, 7)
		icrop% = icrop% XOR 1
		crsupd% = 1
	CASE keyPrevIns
		IF edins% > 1 THEN
			CALL insedtoins(edins%)
			FOR v% = 0 TO 8
				IF vocins%(v%) = edins% THEN CALL setinstr(v%, ins(edins%))
			NEXT v%
			edins% = edins% - 1
			CALL instoinsed(edins%)
			CALL showinstr
			crsupd% = 1
		END IF
	CASE keyNextIns
		IF edins% < 31 THEN
			CALL insedtoins(edins%)
			FOR v% = 0 TO 8
				IF vocins%(v%) = edins% THEN CALL setinstr(v%, ins(edins%))
			NEXT v%
			edins% = edins% + 1
			CALL instoinsed(edins%)
			CALL showinstr
			crsupd% = 1
		END IF
	CASE keyPlus
		IF tstnot% < 11 THEN
			tstnot% = tstnot% + 1
		ELSE
			IF tstoct% < 7 THEN
				tstoct% = tstoct% + 1
				tstnot% = 0
			END IF
		END IF
		CALL putstr(notenm$(tstnot%), iedLeft + 12, 32, 7)
		CALL puthex(tstoct%, iedLeft + 14, 32, 7, 1)
	CASE keyMinus
		IF tstnot% THEN
			tstnot% = tstnot% - 1
		ELSE
			IF tstoct% THEN
				tstoct% = tstoct% - 1
				tstnot% = 11
			END IF
		END IF
		CALL putstr(notenm$(tstnot%), iedLeft + 12, 32, 7)
		CALL puthex(tstoct%, iedLeft + 14, 32, 7, 1)
	CASE keySpace
		CALL insedtoins(edins%)
		CALL stopvoice(0)
		CALL setinstr(0, ins(edins%))
		vocins%(0) = edins%
		CALL playnote(0, frqtab%(tstnot%), tstoct%)
	CASE keyF4
		CALL loadinstr
		CALL instoinsed(edins%)
		CALL showinstr
	CASE keyF5
		CALL insedtoins(edins%)
		CALL saveinstr
	END SELECT

iedcrsupd:
	IF crsupd% THEN
		IF icrr% < 8 THEN
			icrfld% = icrr% + (8 * icrop%)
		ELSE icrfld% = icrr% + 8 + (8 * icrop%)
		END IF
		CALL atrseg(icrLeft + (12 * icrop%), icrTop + icrr%, 10, &H17)
		SELECT CASE icrr%
		CASE 0, 1, 2, 3, 8
			CALL putatr(icrLeft + icrc% + (12 * icrop%), icrTop + icrr%, &H3E)
		END SELECT
		crsupd% = 0
		GOTO iedgetnextkey
	END IF

	IF icrfld% > &H11 THEN GOTO iedgetnextkey

	typ% = 2
	SELECT CASE icrr%
	CASE 0, 1, 2, 3, 8: typ% = 1
	END SELECT

	IF typ% = 1 THEN
		IF (k% = keyLeft) OR (k% = keyRight) THEN
			icrc% = icrc% XOR 1
			crsupd% = 1
			GOTO iedcrsupd
		END IF
		H% = hexscan(k%)
		IF H% >= 0 THEN
			IF icrc% = 0 THEN
				iedfld(icrfld%) = (iedfld(icrfld%) AND 15) OR (H% * 16)
			ELSE
				iedfld(icrfld%) = (iedfld(icrfld%) AND &HF0) OR H%
			END IF
		  
			IF playing% THEN
				CALL insedtoins(edins%)
				FOR v% = 0 TO 8
					IF vocins%(v%) = edins% THEN CALL setinstr(v%, ins(edins%))
				NEXT v%
			END IF
		  
			CALL showinstr
			crsupd% = 1
			GOTO iedcrsupd
		END IF
	ELSE
		IF (k% = keyLeft) OR (k% = keyRight) THEN
			IF k% = keyLeft THEN
				iedfld(icrfld%) = iedfld(icrfld%) - 1
				IF iedfld(icrfld%) < 0 THEN iedfld(icrfld%) = 32767
			ELSE
				iedfld(icrfld%) = iedfld(icrfld%) + 1
			END IF
			SELECT CASE icrr%
			CASE 4, 5, 6, 9: iedfld(icrfld%) = iedfld(icrfld%) AND 1
			CASE 7: iedfld(icrfld%) = iedfld(icrfld%) MOD 4
			END SELECT
		  
			IF playing% THEN
				CALL insedtoins(edins%)
				FOR v% = 0 TO 8
					IF vocins%(v%) = edins% THEN CALL setinstr(v%, ins(edins%))
				NEXT v%
			END IF
		  
			CALL showinstr
			crsupd% = 1
			GOTO iedcrsupd
		END IF
	END IF
WEND

END FUNCTION

FUNCTION editorder%

viewupd% = 0: crsupd% = 0
CALL putatr(11 + (11 * crsv%) + crsc%, 6, &H3E)

CALL chrbar(59, 7, 21, 43, " ", 0)
CALL puthyp(hlporder$, 59, 10)

WHILE 1
ordgetnextkey:
	k% = getkey%
	SELECT CASE k%
	CASE keyF2
		CALL atrseg(0, 6, 58, &H17)
		crsc% = 0
		editorder% = modePattern
		EXIT FUNCTION
	CASE keyF3
		CALL atrseg(0, 6, 58, &H17)
		crsc% = 0
		editorder% = modeInstr
		EXIT FUNCTION
	CASE keyF6
		CALL eraseordline(edpos%)
		viewupd% = 1
	CASE keyF7
		CALL copyordline(edpos%)
		CALL message("Order line copied to clip.")
	CASE keyF8
		CALL pasteordline(edpos%)
		viewupd% = 1
	CASE keyUp
		IF edpos% THEN
			edpos% = edpos% - 1
			viewupd% = 1
		END IF
	CASE keyDown
		IF edpos% < 99 THEN
			edpos% = edpos% + 1
			viewupd% = 1
		END IF
	CASE keyShTab
		IF crsv% THEN
			crsv% = crsv% - 1: crsupd% = 1
		ELSEIF lmchan% THEN
			lmchan% = lmchan% - 1
			CALL showorder
			viewupd% = 1
		END IF
	CASE keyTab
		IF crsv% < 4 THEN
			crsv% = crsv% + 1: crsupd% = 1
		ELSEIF lmchan% < 4 THEN
			lmchan% = lmchan% + 1
			CALL showorder
			viewupd% = 1
		END IF
	CASE keyLeft, keyRight
		crsc% = crsc% XOR 1
		crsupd% = 1
	CASE keyPlus, keyF10
		v% = lmchan% + crsv%
		pi% = ord(v%, edpos%)
		IF pi% < 99 THEN
			ord(v%, edpos%) = pi% + 1
			viewupd% = 1
		END IF
	CASE keyMinus, keyF9
		v% = lmchan% + crsv%
		pi% = ord(v%, edpos%)
		IF pi% THEN
			ord(v%, edpos%) = pi% - 1
			viewupd% = 1
		END IF
	CASE keyIns
		IF length% < 100 THEN
			FOR o% = length% TO edpos% + 1 STEP -1
				FOR v% = 0 TO 8
					ord(v%, o%) = ord(v%, o% - 1)
				NEXT v%
			NEXT o%
			FOR v% = 0 TO 8
				ord(v%, edpos%) = 0
			NEXT v%
			length% = length% + 1
			viewupd% = 1
		END IF
	CASE keyDel
		IF length% > 1 THEN
			FOR o% = edpos% TO length% - 2
				FOR v% = 0 TO 8
					ord(v%, o%) = ord(v%, o% + 1)
				NEXT v%
			NEXT o%
			FOR v% = 0 TO 8
				ord(v%, length% - 1) = 0
			NEXT v%
			length% = length% - 1
			viewupd% = 1
		END IF
	END SELECT

	IF viewupd% THEN
		CALL showorder
		CALL showpattern
		crsupd% = 1
		viewupd% = 0
	END IF
	IF crsupd% = 1 THEN
		CALL atrseg(0, 6, 58, &H17)
		CALL putatr(11 + (11 * crsv%) + crsc%, 6, &H3E)
		crsupd% = 0
		GOTO ordgetnextkey
	END IF

	v% = lmchan% + crsv%
	pi% = ord(v%, edpos%)

	H% = hexscan(k%)
	IF H% >= 0 THEN
		IF crsc% = 0 THEN
			npi% = (pi% AND 15) OR (H% * 16)
		ELSE
			npi% = (pi% AND &HF0) OR H%
		END IF
		IF npi% < 100 THEN
			ord(v%, edpos%) = npi%
			viewupd% = 1
		END IF
	END IF

	IF viewupd% THEN
		CALL showorder
		CALL showpattern
		crsupd% = 1
		viewupd% = 0
	END IF
	IF crsupd% = 1 THEN
		CALL atrseg(0, 6, 58, &H17)
		CALL putatr(11 + (11 * crsv%) + crsc%, 6, &H3E)
		crsupd% = 0
	END IF
WEND

END FUNCTION

FUNCTION editpattern%

CALL chrbar(59, 7, 21, 43, " ", 0)
CALL puthyp(hlppattern$, 59, 10)

viewupd% = 0: crsupd% = 0
CALL putatr(3 + (11 * crsv%) + crsc%, 27, &H3E)
WHILE 1

getnextkey:
	v% = lmchan% + crsv%
	pi% = ord(v%, edpos%)
	k% = getkey%
	SELECT CASE k%
	CASE keyEsc
		editpattern% = modeDeath
		EXIT FUNCTION
	CASE keyF1
		CALL atrseg(0, 27, 58, &H17)
		crsc% = 0
		editpattern% = modeOrder
		EXIT FUNCTION
	CASE keyF3
		CALL atrseg(0, 27, 58, &H17)
		crsc% = 0
		editpattern% = modeInstr
		EXIT FUNCTION
	CASE keyUp
		IF edrow% THEN edrow% = edrow% - 1: viewupd% = 1
	CASE keyDown
		IF edrow% < 63 THEN edrow% = edrow% + 1: viewupd% = 1
	CASE keyLeft
		IF crsc% THEN
			crsc% = crsc% - 1: crsupd% = 1
		END IF
	CASE keyRight
		IF crsc% < 9 THEN
			crsc% = crsc% + 1: crsupd% = 1
		END IF
	CASE keyShTab
		IF crsv% THEN
			crsv% = crsv% - 1: crsupd% = 1
		ELSEIF lmchan% THEN
			lmchan% = lmchan% - 1
			CALL showorder
			viewupd% = 1
		END IF
	CASE keyTab
		IF crsv% < 4 THEN
			crsv% = crsv% + 1: crsupd% = 1
		ELSEIF lmchan% < 4 THEN
			lmchan% = lmchan% + 1
			CALL showorder
			viewupd% = 1
		END IF
	CASE keyF10
		IF pi% < 99 THEN
			ord(v%, edpos%) = pi% + 1
			CALL showorder
			viewupd% = 1
		END IF
	CASE keyF9
		IF pi% THEN
			ord(v%, edpos%) = pi% - 1
			CALL showorder
			viewupd% = 1
		END IF
	CASE keyF4
		CALL loadmod
		CALL showorder
		viewupd% = 1
	CASE keyF5
		CALL savemod
	CASE keyF6
		CALL copypattern(pi%)
		CALL erasepattern(pi%)
		viewupd% = 1
	CASE keyF7
		CALL copypattern(pi%)
		CALL message("Pattern copied to clip")
	CASE keyF8
		CALL pastepattern(pi%)
		viewupd% = 1
	CASE keyIns
		FOR r% = 63 TO edrow% + 1 STEP -1
			nte(r%, pi%) = nte(r% - 1, pi%)
			oct(r%, pi%) = oct(r% - 1, pi%)
			ini(r%, pi%) = ini(r% - 1, pi%)
			eff(r%, pi%) = eff(r% - 1, pi%)
		NEXT r%
		nte(edrow%, pi%) = 12
		oct(edrow%, pi%) = 0
		ini(edrow%, pi%) = 0
		eff(edrow%, pi%) = 0
		viewupd% = 1
	CASE keyBackspc
		IF edrow% THEN
			edrow% = edrow% - 1
			FOR r% = edrow% TO 62
				nte(r%, pi%) = nte(r% + 1, pi%)
				oct(r%, pi%) = oct(r% + 1, pi%)
				ini(r%, pi%) = ini(r% + 1, pi%)
				eff(r%, pi%) = eff(r% + 1, pi%)
			NEXT r%
			nte(63, pi%) = 12
			oct(63, pi%) = 0
			ini(63, pi%) = 0
			eff(63, pi%) = 0
			viewupd% = 1
		END IF
	CASE keyPgUp
		IF edrow% >= 16 THEN edrow% = edrow% - 16 ELSE edrow% = 0
		viewupd% = 1
	CASE keyPgDown
		IF edrow% < 48 THEN edrow% = edrow% + 16 ELSE edrow% = 63
		viewupd% = 1
	CASE keyHome
		edrow% = 0
		viewupd% = 1
	CASE keyEnd
		edrow% = 63
		viewupd% = 1
	CASE keySpace
		playing% = playing% XOR 1
		IF playing% = 1 THEN
			follow% = 1
			secs% = 0: mins% = 0      ' FIDI GEI GEI GEI
			ON TIMER(1) GOSUB Frame
			TIMER ON
		ELSE
			TIMER OFF
			FOR v% = 0 TO 8
				CALL setinstr(v%, silence)
				vocins%(v%) = -1
			NEXT v%
			CALL putspc(59, 3, 18, 0)
		END IF
		crsupd% = 1
	CASE keySlash
		IF edoct% THEN
			edoct% = edoct% - 1
			CALL puthex(edoct%, 8, 47, 7, 2)
		END IF
	CASE keyAsterisk
		IF edoct% < 7 THEN
			edoct% = edoct% + 1
			CALL puthex(edoct%, 8, 47, 7, 2)
		END IF
	CASE keyPrevIns
		IF edins% > 1 THEN
			edins% = edins% - 1
			CALL puthex(edins%, 8, 48, 7, 2)
		END IF
	CASE keyNextIns
		IF edins% < 31 THEN
			edins% = edins% + 1
			CALL puthex(edins%, 8, 48, 7, 2)
		END IF
	END SELECT

	IF viewupd% THEN
		CALL showpattern
		crsupd% = 1
		viewupd% = 0
	END IF
	IF crsupd% THEN
		CALL atrseg(0, 27, 58, &H17)
		CALL putatr(3 + (11 * crsv%) + crsc%, 27, &H3E)
		crsupd% = 0
		GOTO getnextkey
	END IF

	context% = 0
	SELECT CASE crsc%
		CASE 0: context% = 1
		CASE 4, 5: context% = 2
		CASE 7, 8, 9: context% = 3
	END SELECT

	IF context% = 1 THEN
		IF k% = keyDel THEN
			nte(edrow%, pi%) = 12
			oct(edrow%, pi%) = 0
			ini(edrow%, pi%) = 0
			IF edrow% < 63 THEN edrow% = edrow% + 1
			viewupd% = 1
		ELSE
			n% = 12
			FOR i% = 0 TO 11
				IF k% = keyloct%(i%) THEN
					n% = i%: o% = edoct%
					EXIT FOR
				END IF
				IF k% = keyhoct%(i%) THEN
					n% = i%: o% = edoct% + 1
					EXIT FOR
				END IF
			NEXT i%
			FOR i% = 0 TO 4
				IF k% = keylovr%(i%) THEN
					n% = i%: o% = edoct% + 1
					EXIT FOR
				END IF
				IF k% = keyhovr%(i%) THEN
					n% = i%: o% = edoct% + 2
					EXIT FOR
				END IF
			NEXT i%
			IF n% <> 12 THEN
				nte(edrow%, pi%) = n%
				oct(edrow%, pi%) = o%
				ini(edrow%, pi%) = edins%
				CALL stopvoice(v%)
				IF vocins%(v%) <> edins% THEN
					CALL setinstr(v%, ins(edins%))
					vocins%(v%) = edins%
				END IF
				CALL playnote(v%, frqtab%(n%), o%)
				IF edrow% < 63 THEN edrow% = edrow% + 1
				viewupd% = 1
			END IF
		END IF
	ELSEIF context% = 2 THEN
		IF k% = keyDel THEN
			ini(edrow%, pi%) = 0
			IF edrow% < 63 THEN edrow% = edrow% + 1
			viewupd% = 1
		ELSE
			H% = hexscan(k%)
			IF H% >= 0 THEN
				IF crsc% = 4 THEN
					ini(edrow%, pi%) = (ini(edrow%, pi%) AND 15) OR (H% * 16)
				ELSE
					ini(edrow%, pi%) = (ini(edrow%, pi%) AND &HF0) OR H%
				END IF
				IF edrow% < 63 THEN edrow% = edrow% + 1
				viewupd% = 1
			END IF
		END IF
	ELSEIF context% = 3 THEN
		IF k% = keyDel THEN
			eff(edrow%, pi%) = 0
			IF edrow% < 63 THEN edrow% = edrow% + 1
			viewupd% = 1
		ELSE
			H% = hexscan(k%)
			IF H% >= 0 THEN
				IF crsc% = 7 THEN
					eff(edrow%, pi%) = (eff(edrow%, pi%) AND 255) OR (H% * 256)
				ELSEIF crsc% = 8 THEN
					eff(edrow%, pi%) = (eff(edrow%, pi%) AND &HF0F) OR (H% * 16)
				ELSE
					eff(edrow%, pi%) = (eff(edrow%, pi%) AND &HFF0) OR H%
				END IF
				IF edrow% < 63 THEN edrow% = edrow% + 1
				viewupd% = 1
			END IF
		END IF
	END IF

	IF viewupd% THEN
		CALL showpattern
		crsupd% = 1
		viewupd% = 0
	END IF
	IF crsupd% THEN
		CALL atrseg(0, 27, 58, &H17)
		CALL putatr(3 + (11 * crsv%) + crsc%, 27, &H30)
		crsupd% = 0
	END IF
WEND

END FUNCTION

SUB eraseinstr (i%)
	ins(i%).mul1 = 0
	ins(i%).lev1 = 0
	ins(i%).atd1 = 0
	ins(i%).sur1 = 0
	ins(i%).wav1 = 0
	ins(i%).mul2 = 0
	ins(i%).lev2 = 0
	ins(i%).atd2 = 0
	ins(i%).sur2 = 0
	ins(i%).wav2 = 0
	ins(i%).fbcon = 0
END SUB

SUB eraseordline (o%)
	FOR v% = 0 TO 8
		ord(v%, 100) = ord(v%, o%)
		ord(v%, o%) = 0
	NEXT v%
END SUB

SUB erasepattern (p%)
	FOR r% = 0 TO 63
		nte(r%, p%) = 12
		oct(r%, p%) = 0
		ini(r%, p%) = 0
		eff(r%, p%) = 0
	NEXT r%
END SUB

FUNCTION getkey%
	i$ = ""
	WHILE i$ = ""
		i$ = INKEY$
	WEND
	getkey% = CVI(i$ + CHR$(0))
END FUNCTION

FUNCTION getstr$ (x%, y%, atr%, maxchrs%)
	st$ = SPACE$(maxchrs%)
	ofs% = 2 * ((80 * y%) + x%)
	DEF SEG = &HB800
	p% = 1
	maxchrs% = maxchrs% + 1
	DO
		k% = getkey
		IF k% = keyEnter THEN
			getstr$ = LEFT$(st$, p% - 1)
			EXIT FUNCTION
		ELSEIF k% = keyBackspc THEN
			IF p% > 1 THEN
				ofs% = ofs% - 2
				POKE ofs%, 32
				p% = p% - 1
			END IF
		ELSE
			IF p% < maxchrs% THEN
				MID$(st$, p%, 1) = CHR$(k%)
				POKE ofs%, k%
				POKE ofs% + 1, atr%
				ofs% = ofs% + 2
				p% = p% + 1
			END IF
		END IF
	LOOP
END FUNCTION

FUNCTION hexscan% (k%)
	hexscan% = -1
	FOR i% = 0 TO 15
		IF k% = keyhex%(i%) THEN
			hexscan% = i%
			EXIT FUNCTION
		END IF
	NEXT i%
END FUNCTION

SUB insedtoins (i%)
	ins(i%).mul1 = iedfld(iedMul1) OR (iedfld(iedEgs1) * 32) OR (iedfld(iedVib1) * 64) OR (iedfld(iedTre1) * 128)
	ins(i%).mul2 = iedfld(iedMul2) OR (iedfld(iedEgs2) * 32) OR (iedfld(iedVib2) * 64) OR (iedfld(iedTre2) * 128)
	ins(i%).lev1 = iedfld(iedLev1)
	ins(i%).lev2 = iedfld(iedLev2)
	ins(i%).atd1 = iedfld(iedAtd1)
	ins(i%).atd2 = iedfld(iedAtd2)
	ins(i%).sur1 = iedfld(iedSur1)
	ins(i%).sur2 = iedfld(iedSur2)
	ins(i%).wav1 = iedfld(iedWav1)
	ins(i%).wav2 = iedfld(iedWav2)
	ins(i%).fbcon = (iedfld(iedFb) * 2) OR iedfld(iedCon)
END SUB

SUB instoinsed (i%)
	iedfld(iedMul1) = ins(i%).mul1 AND 15
	iedfld(iedMul2) = ins(i%).mul2 AND 15
	iedfld(iedLev1) = ins(i%).lev1
	iedfld(iedLev2) = ins(i%).lev2
	iedfld(iedAtd1) = ins(i%).atd1
	iedfld(iedAtd2) = ins(i%).atd2
	iedfld(iedSur1) = ins(i%).sur1
	iedfld(iedSur2) = ins(i%).sur2
	iedfld(iedVib1) = (ins(i%).mul1 \ 64) AND 1
	iedfld(iedVib2) = (ins(i%).mul2 \ 64) AND 1
	iedfld(iedTre1) = (ins(i%).mul1 \ 128) AND 1
	iedfld(iedTre2) = (ins(i%).mul2 \ 128) AND 1
	iedfld(iedEgs1) = (ins(i%).mul1 \ 32) AND 1
	iedfld(iedEgs2) = (ins(i%).mul2 \ 32) AND 1
	iedfld(iedWav1) = ins(i%).wav1
	iedfld(iedWav2) = ins(i%).wav2
	iedfld(iedFb) = ins(i%).fbcon \ 2
	iedfld(iedCon) = ins(i%).fbcon AND 1

END SUB

SUB loadinstr
	filenm$ = prompt("Load from file:", 64)
	IF filenm$ = "" THEN
		CALL message("Nothing was done.")
		EXIT SUB
	END IF
	OPEN filenm$ FOR BINARY ACCESS READ AS #1
	ins(edins%).mul1 = readb(1, 1)
	ins(edins%).mul2 = readb(1, 2)
	ins(edins%).lev1 = readb(1, 3)
	ins(edins%).lev2 = readb(1, 4)
	ins(edins%).atd1 = readb(1, 5)
	ins(edins%).atd2 = readb(1, 6)
	ins(edins%).sur1 = readb(1, 7)
	ins(edins%).sur2 = readb(1, 8)
	ins(edins%).wav1 = readb(1, 9)
	ins(edins%).wav2 = readb(1, 10)
	ins(edins%).fbcon = readb(1, 11)
	CLOSE #1
END SUB

SUB loadmod
	DIM ptnmap%(0 TO 99), insmap%(0 TO 31)
  
	filenm$ = prompt("Load from file:", 64)
	IF filenm$ = "" THEN
		CALL message("Nothing was done.")
		EXIT SUB
	END IF
	FOR o% = 0 TO length% - 1
		FOR v% = 0 TO 8: ord(v%, o%) = 0: NEXT v%
	NEXT o%
	FOR p% = 0 TO 99: CALL erasepattern(p%): NEXT p%
	FOR i% = 1 TO 31: CALL eraseinstr(i%): NEXT i%
	OPEN filenm$ FOR BINARY ACCESS READ AS #1
	length% = readb(1, 1)
	mp% = readb(1, 2)
	mi% = readb(1, 3)
	fpos% = 4
	FOR p% = 0 TO mp% - 1
		ptnmap%(p%) = readb(1, fpos%)
		fpos% = fpos% + 1
	NEXT p%
	FOR i% = 0 TO mi% - 1
		insmap%(i%) = readb(1, fpos%)
		fpos% = fpos% + 1
	NEXT i%
	FOR o% = 0 TO length% - 1
		FOR v% = 0 TO 8
			ord(v%, o%) = readb(1, fpos%)
			fpos% = fpos% + 1
		NEXT v%
	NEXT o%
	FOR p% = 0 TO mp% - 1
		pi% = ptnmap%(p%)
		FOR r% = 0 TO 63
			b1% = readb(1, fpos%): fpos% = fpos% + 1
			b2% = readb(1, fpos%): fpos% = fpos% + 1
			b3% = readb(1, fpos%): fpos% = fpos% + 1
			nte(r%, pi%) = b1% \ 16
			oct(r%, pi%) = (b1% \ 2) AND 7
			ini(r%, pi%) = ((b1% AND 1) * 16) OR (b2% \ 16)
			eff(r%, pi%) = ((b2% AND 15) * 256) OR b3%
		NEXT r%
	NEXT p%
	FOR i% = 0 TO mi% - 1
		ii% = insmap%(i%)
		ins(ii%).mul1 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).mul2 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).lev1 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).lev2 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).atd1 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).atd2 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).sur1 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).sur2 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).wav1 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).wav2 = readb(1, fpos%): fpos% = fpos% + 1
		ins(ii%).fbcon = readb(1, fpos%): fpos% = fpos% + 1
	NEXT i%
	CLOSE #1
END SUB

SUB message (st$)
	CALL atrseg(0, 49, 80, 0)
	CALL putstr(st$, 0, 49, 14)
	SLEEP 25
	CALL atrseg(0, 49, 80, 0)
END SUB

SUB oplout (reg%, vlu%)
	OUT &H388, reg%
	a% = INP(&H388)
	OUT &H389, vlu%
	a% = INP(&H388)
	a% = INP(&H388)
	a% = INP(&H388)
	a% = INP(&H388)
	a% = INP(&H388)
	a% = INP(&H388)
	a% = INP(&H388)
END SUB

SUB pasteordline (o%)
	FOR v% = 0 TO 8
		ord(v%, o%) = ord(v%, 100)
	NEXT v%
END SUB

SUB pastepattern (p%)
	FOR r% = 0 TO 63
		nte(r%, p%) = nte(r%, 100)
		oct(r%, p%) = oct(r%, 100)
		ini(r%, p%) = ini(r%, 100)
		eff(r%, p%) = eff(r%, 100)
	NEXT r%
END SUB

SUB playnote (v%, frq%, oct%)
	CALL oplout(&HA0 + v%, frq% AND 255)
	CALL oplout(&HB0 + v%, 32 OR (4 * oct%) OR (frq% \ 256))
END SUB

FUNCTION prompt$ (text$, maxchrs%)
	CALL putstr(text$, 0, 49, 7)
	prompt$ = getstr(LEN(text$) + 1, 49, 7, maxchrs%)
	CALL atrseg(0, 49, 80, 0)
END FUNCTION

SUB putatr (x%, y%, atr%)
	ofs% = (2 * ((80 * y%) + x%)) + 1
	DEF SEG = &HB800
	POKE ofs%, atr%
END SUB

SUB puthex (vlu%, x%, y%, atr%, dig%)
	st$ = HEX$(vlu%)
	FOR i% = 1 TO dig% - LEN(st$)
		st$ = "0" + st$
	NEXT i%
	CALL putstr(st$, x%, y%, atr%)
END SUB

SUB puthyp (hyp$, x%, y%)
	ofs% = 2 * ((80 * y%) + x%)
	tonl% = 160
	p% = 1
	atr% = 7
	WHILE p% <= LEN(hyp$)
		l$ = MID$(hyp$, p%, 1)
		p% = p% + 1
		IF l$ = "<" THEN
			m$ = MID$(hyp$, p%, 1)
			p% = p% + 1
			IF m$ = "n" THEN
				ofs% = ofs% + tonl%
				tonl% = 160
			ELSEIF m$ = "<" THEN
				POKE ofs%, 60: ofs% = ofs% + 1
				POKE ofs%, atr%: ofs% = ofs% + 1
				tonl% = tonl% - 2
			ELSE
				n$ = MID$(hyp$, p%, 1)
				p% = p% + 1
				m% = ASC(m$)
				n% = ASC(n$)
				IF m% < 65 THEN m% = m% - 48 ELSE m% = m% - 55
				IF n% < 65 THEN n% = n% - 48 ELSE n% = n% - 55
				atr% = (m% * 16) OR n%
			END IF
		ELSE
			POKE ofs%, ASC(l$): ofs% = ofs% + 1
			POKE ofs%, atr%: ofs% = ofs% + 1
			tonl% = tonl% - 2
		END IF
	WEND
END SUB

SUB putspc (x%, y%, w%, atr%)
	ofs% = 2 * ((80 * y%) + x%)
	DEF SEG = &HB800
	WHILE w%
		w% = w% - 1
		POKE ofs%, 32: ofs% = ofs% + 1
		POKE ofs%, atr%: ofs% = ofs% + 1
	WEND
END SUB

SUB putstr (st$, x%, y%, atr%)
	ofs% = 2 * ((80 * y%) + x%)
	DEF SEG = &HB800
	FOR p% = 1 TO LEN(st$)
		POKE ofs%, ASC(MID$(st$, p%, 1))
		ofs% = ofs% + 1
		POKE ofs%, atr%
		ofs% = ofs% + 1
	NEXT p%
END SUB

FUNCTION readb% (fh%, pso%)
	b$ = CHR$(0)
	GET fh%, pso%, b$
	readb% = ASC(b$)
END FUNCTION

FUNCTION regscol% (r%)
	regi.ax = &H1007
	regi.bx = r%
	CALL InterruptX(&H10, regi, rego)
	regscol% = rego.bx \ 256
END FUNCTION

SUB saveinstr
	filenm$ = prompt("Save to file:", 64)
	IF filenm$ = "" THEN
		CALL message("Nothing was done.")
		EXIT SUB
	END IF
	OPEN filenm$ FOR BINARY ACCESS WRITE AS #1
	CALL writeb(1, 1, ins(edins%).mul1)
	CALL writeb(1, 2, ins(edins%).mul2)
	CALL writeb(1, 3, ins(edins%).lev1)
	CALL writeb(1, 4, ins(edins%).lev2)
	CALL writeb(1, 5, ins(edins%).atd1)
	CALL writeb(1, 6, ins(edins%).atd2)
	CALL writeb(1, 7, ins(edins%).sur1)
	CALL writeb(1, 8, ins(edins%).sur2)
	CALL writeb(1, 9, ins(edins%).wav1)
	CALL writeb(1, 10, ins(edins%).wav2)
	CALL writeb(1, 11, ins(edins%).fbcon)
	CLOSE #1
END SUB

SUB savemod
	DIM ptnuse%(0 TO 99), insuse%(0 TO 31)
	DIM ptnmap%(0 TO 99), insmap%(0 TO 31)

	filenm$ = prompt("Save to file:", 64)
	IF filenm$ = "" THEN
		CALL message("Nothing was done.")
		EXIT SUB
	END IF
	FOR o% = 0 TO length% - 1
		FOR v% = 0 TO 8
			ptnuse%(ord(v%, o%)) = 1
		NEXT v%
	NEXT o%
	mp% = 0
	FOR p% = 0 TO 99
		IF ptnuse%(p%) THEN
			ptnmap%(mp%) = p%
			mp% = mp% + 1
		END IF
	NEXT p%

	FOR p% = 0 TO mp% - 1
		pi% = ptnmap%(p%)
		FOR r% = 0 TO 63
			insuse%(ini(r%, pi%)) = 1
		NEXT r%
	NEXT p%
	mi% = 0
	FOR i% = 1 TO 31
		IF insuse%(i%) THEN
			insmap%(mi%) = i%
			mi% = mi% + 1
		END IF
	NEXT i%
	OPEN filenm$ FOR BINARY ACCESS WRITE AS #1
	CALL writeb(1, 1, length%)
	CALL writeb(1, 2, mp%)
	CALL writeb(1, 3, mi%)
	fpos% = 4
	FOR i% = 0 TO mp% - 1
		CALL writeb(1, fpos%, ptnmap%(i%))
		fpos% = fpos% + 1
	NEXT i%
	FOR i% = 0 TO mi% - 1
		CALL writeb(1, fpos%, insmap%(i%))
		fpos% = fpos% + 1
	NEXT i%
	FOR o% = 0 TO length% - 1
		FOR v% = 0 TO 8
			CALL writeb(1, fpos%, ord(v%, o%))
			fpos% = fpos% + 1
		NEXT v%
	NEXT o%
	FOR p% = 0 TO mp% - 1
		pi% = ptnmap%(p%)
		FOR r% = 0 TO 63
			n% = nte(r%, pi%)
			o% = oct(r%, pi%)
			i% = ini(r%, pi%)
			e% = eff(r%, pi%)
			b1% = (n% * 16) OR (o% * 2) OR (i% \ 16)
			b2% = ((i% * 16) AND &HF0) OR (e% \ 256)
			b3% = e% AND 255
			CALL writeb(1, fpos%, b1%): fpos% = fpos% + 1
			CALL writeb(1, fpos%, b2%): fpos% = fpos% + 1
			CALL writeb(1, fpos%, b3%): fpos% = fpos% + 1
		NEXT r%
	NEXT p%
	FOR i% = 0 TO mi% - 1
		ii% = insmap%(i%)
		CALL writeb(1, fpos%, ins(ii%).mul1): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).mul2): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).lev1): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).lev2): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).atd1): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).atd2): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).sur1): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).sur2): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).wav1): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).wav2): fpos% = fpos% + 1
		CALL writeb(1, fpos%, ins(ii%).fbcon): fpos% = fpos% + 1
	NEXT i%
	CLOSE #1
END SUB

SUB setinstr (v%, i AS Instrument)
	r% = &H20 + vocofs%(v%)
	CALL oplout(r%, i.mul1): r% = r% + 3
	CALL oplout(r%, i.mul2): r% = r% + &H1D
	CALL oplout(r%, i.lev1): r% = r% + 3
	CALL oplout(r%, i.lev2): r% = r% + &H1D
	CALL oplout(r%, i.atd1): r% = r% + 3
	CALL oplout(r%, i.atd2): r% = r% + &H1D
	CALL oplout(r%, i.sur1): r% = r% + 3
	CALL oplout(r%, i.sur2): r% = r% + &H5D
	CALL oplout(r%, i.wav1): r% = r% + 3
	CALL oplout(r%, i.wav2)
	CALL oplout(&HC0 + v%, i.fbcon)
END SUB

SUB setrgb (c%, r%, g%, b%)
	OUT &H3C8, c%
	OUT &H3C9, r%
	OUT &H3C9, g%
	OUT &H3C9, b%
END SUB

SUB setvolume (v%, vol%)
  
	IF vocins%(v%) = -1 THEN EXIT SUB
  
	IF vol% > 64 THEN
		vol% = 64
	ELSEIF vol% < 2 THEN
		vol% = 2
	END IF
	l1% = ins(vocins%(v%)).lev1
	l2% = ins(vocins%(v%)).lev2
	l1% = 64 - (vol% * (64 - l1%) \ 64)
	l2% = 64 - (vol% * (64 - l2%) \ 64)
	CALL oplout(&H40 + vocofs%(v%), l1%)
	CALL oplout(&H43 + vocofs%(v%), l2%)
	vocvol%(v%) = vol%
END SUB

SUB showinstr
	y% = iedTop + 4
	x1% = iedLeft + 15
	x2% = iedLeft + 27
	CALL puthex(iedfld(iedMul1), x1%, y%, 7, 2)
	CALL puthex(iedfld(iedMul2), x2%, y%, 7, 2)
	y% = y% + 1
	CALL puthex(iedfld(iedLev1), x1%, y%, 7, 2)
	CALL puthex(iedfld(iedLev2), x2%, y%, 7, 2)
	y% = y% + 1
	CALL puthex(iedfld(iedAtd1), x1%, y%, 7, 2)
	CALL puthex(iedfld(iedAtd2), x2%, y%, 7, 2)
	y% = y% + 1
	CALL puthex(iedfld(iedSur1), x1%, y%, 7, 2)
	CALL puthex(iedfld(iedSur2), x2%, y%, 7, 2)
	y% = y% + 1
	CALL putstr(stnoyes$(iedfld(iedVib1)), x1%, y%, 7)
	CALL putstr(stnoyes$(iedfld(iedVib2)), x2%, y%, 7)
	y% = y% + 1
	CALL putstr(stnoyes$(iedfld(iedTre1)), x1%, y%, 7)
	CALL putstr(stnoyes$(iedfld(iedTre2)), x2%, y%, 7)
	y% = y% + 1
	CALL putstr(stnoyes$(iedfld(iedEgs1)), x1%, y%, 7)
	CALL putstr(stnoyes$(iedfld(iedEgs2)), x2%, y%, 7)
	y% = y% + 1
	CALL putstr(stwav$(iedfld(iedWav1)), x1%, y%, 7)
	CALL putstr(stwav$(iedfld(iedWav2)), x2%, y%, 7)
	y% = y% + 1
	CALL puthex(iedfld(iedFb), x1%, y%, 7, 2)
	y% = y% + 1
	CALL putstr(stcon$(iedfld(iedCon)), x1%, y%, 7)
	CALL putstr("Nr.", iedLeft + 1, iedTop + 1, 7)
	CALL puthex(edins%, iedLeft + 4, iedTop + 1, 7, 2)
END SUB

SUB showorder
	CALL chrbar(0, 3, 57, 7, " ", 0)
	x% = 2
	FOR c% = 0 TO 4
		CALL box(x%, 2, 12, 9, 4)
		x% = x% + 11
	NEXT c%
	y% = 3: o% = edpos% - 3
	WHILE o% < 0
		y% = y% + 1
		o% = o% + 1
	WEND
	atr% = 7
	DO WHILE y% < 10
		IF o% > 99 THEN EXIT DO
		IF o% >= length% THEN atr% = 8
		CALL puthex(o%, 0, y%, atr%, 2)
		x% = 11
		FOR v% = lmchan% TO lmchan% + 4
			CALL puthex(ord(v%, o%), x%, y%, atr%, 2)
			x% = x% + 11
		NEXT v%
		y% = y% + 1
		o% = o% + 1
	LOOP
	CALL atrseg(0, 6, 58, &H17)
	CALL puthex(edpos%, 60, 6, 7, 2)
	CALL putstr("/", 62, 6, 7)
	CALL puthex(length%, 63, 6, 7, 2)
END SUB

SUB showpattern
	x% = 2
	FOR v% = lmchan% TO lmchan% + 4
		CALL box(x%, 10, 12, 34, 4)
		CALL puthex(v%, x% + 5, 10, 7, 1)
		pi% = ord(v%, edpos%)
		y% = 11: r% = edrow% - 16
		WHILE r% < 0
			CALL putspc(x% + 1, y%, 10, 0)
			y% = y% + 1
			r% = r% + 1
		WEND
		DO WHILE r% < 64
			IF y% >= 43 THEN EXIT DO
			n% = nte(r%, pi%)
			i% = ini(r%, pi%)
			e% = eff(r%, pi%)
			CALL putstr(notenm$(n%), x% + 1, y%, 7)
			IF n% < 12 THEN CALL puthex(oct(r%, pi%), x% + 3, y%, 7, 1)
			IF i% THEN
				CALL puthex(ini(r%, pi%), x% + 5, y%, 7, 2)
			ELSE CALL putstr("..", x% + 5, y%, 7)
			END IF
			IF e% THEN
				CALL puthex(e%, x% + 8, y%, 7, 3)
			ELSE CALL putstr("...", x% + 8, y%, 7)
			END IF
			y% = y% + 1
			r% = r% + 1
		LOOP
		DO WHILE y% < 43
			CALL putspc(x% + 1, y%, 10, 0)
			y% = y% + 1
		LOOP
		x% = x% + 11
	NEXT v%
	FOR v% = lmchan% TO lmchan% + 4
		y% = 11: r% = edrow% - 16
		WHILE r% < 0
			CALL putspc(0, y%, 2, 0)
			y% = y% + 1
			r% = r% + 1
		WEND
		DO WHILE r% < 64
			IF y% >= 43 THEN EXIT DO
			CALL puthex(r%, 0, y%, 7, 2)
			y% = y% + 1
			r% = r% + 1
		LOOP
		DO WHILE y% < 43
			CALL putspc(0, y%, 2, 0)
			y% = y% + 1
		LOOP
	NEXT v%
	CALL atrseg(0, 27, 58, &H17)
END SUB

SUB stopvoice (v%)
	CALL oplout(&HB0 + v%, 0)
END SUB

SUB writeb (fh%, pso%, b%)
	c$ = CHR$(b%)
	PUT fh%, pso%, c$
END SUB

