' $INCLUDE: 'MIDILIB.BI'

DIM SHARED Vol(1)

RANDOMIZE TIMER

' Detect the SBMIDI, SBSIM drivers and the sound card settings.
DetectDrivers
IF MIDIErrorOccured THEN PRINT MIDIError$: END
DetectSettings
IF MIDIErrorOccured THEN PRINT MIDIError$: END

' Choose a filename.
IF COMMAND$ <> "" THEN
    Filename$ = COMMAND$
ELSE
    SELECT CASE INT(RND * 10)
        CASE 0: Filename$ = "CARNIVAL.MID"
        CASE 1: Filename$ = "DANUBE.MID"
        CASE 2: Filename$ = "FBATTLE.MID"
        CASE 3: Filename$ = "GOODRID.MID"
        CASE 4: Filename$ = "MEIA.MID"
        CASE 5: Filename$ = "MONTYP.MID"
        CASE 6: Filename$ = "PARADE.MID"
        CASE 7: Filename$ = "PARANOID.MID"
        CASE 8: Filename$ = "PLANK.MID"
        CASE 9: Filename$ = "SMWINTRO.MID"
    END SELECT
END IF
    
' Draw the screen.
CLS
PRINT ""; STRING$(78, ""); "";
PRINT " MIDILib Library Demonstration Program, (C) 2001 IceWolf"; SPACE$(22); "";
PRINT ""; STRING$(78, ""); "";
PRINT " [P]     - Pause MIDI                  [R]     - Resume MIDI                  ";
PRINT " [S]     - Stop MIDI                   [SPACE] - Play MIDI from beginning     ";
PRINT " [UP]    - Select left channel         [DOWN]  - Select right channel         ";
PRINT " [LEFT]  - Decrease volume             [RIGHT] - Increase volume              ";
PRINT " [ENTER] - Turn reverse stereo on      [ESC]   - Quit                         ";
PRINT ""; STRING$(78, ""); "";
PRINT "         ͻ";
PRINT "          Left Channel      /     ------------------------------- ";
PRINT "          Right Channel     /     ------------------------------- ";
PRINT "         ͼ";
PRINT "  ͻ";
PRINT "                          Looped     times  Playing for          seconds ";
PRINT "  ͹";
PRINT "   Sound card                                                              ";
PRINT "  ͼ";

LOCATE 17, 18: PRINT SoundCard$

' Convert full pathname into just a filename.
FOR i = LEN(Filename$) TO 1 STEP -1: IF MID$(Filename$, i, 1) = "\" OR MID$(Filename$, i, 1) = ":" THEN EXIT FOR
NEXT: i = i + 1: LOCATE 15, 5: PRINT MID$(Filename$, i);

' Initialise the volumes.
SELECT CASE SoundCardType
    CASE 0, 1, 3: maxvol = 0
    CASE 2, 4, 5: maxvol = 15: Vol$ = ""
    CASE 6: maxvol = 31: Vol$ = ""
END SELECT
IF maxvol = 0 THEN
    LOCATE 11, 28: PRINT "--": LOCATE 11, 33: PRINT "--"
    LOCATE 12, 28: PRINT "--": LOCATE 12, 33: PRINT "--"
    LOCATE 11, 38: PRINT "Volume changes aren't supported "
    LOCATE 12, 38: PRINT "for your sound card.            "
ELSE
    Vol(0) = GetVolume(4, 0): Vol(1) = GetVolume(5, 0)
    LOCATE 11, 28: PRINT USING "##"; Vol(0): LOCATE 11, 33: PRINT USING "##"; maxvol
    COLOR 15
    LOCATE 11, 38: PRINT STRING$(Vol(0) * LEN(Vol$), Vol$); STRING$(31 - LEN(Vol$) * Vol(0), "-")
    COLOR 7
    LOCATE 12, 28: PRINT USING "##"; Vol(1): LOCATE 12, 33: PRINT USING "##"; maxvol
    LOCATE 12, 38: PRINT STRING$(Vol(1) * LEN(Vol$), Vol$); STRING$(31 - LEN(Vol$) * Vol(1), "-")
END IF

' Load the MIDI file.
LoadMIDI Filename$: IF MIDIErrorOccured THEN CLS : PRINT MIDIError$: END

' Play it.
PlayMIDI

' Print some stuff on screen.
LOCATE 15, 20: PRINT "Playing"
LOCATE 15, 37: PRINT USING "###"; loops;

DO
      
    ' Print how long the song has been playing.
    IF MIDITime <> -1 THEN LOCATE 15, 61: PRINT USING "####.###"; MIDITime! ELSE LOCATE 15, 61: PRINT "----.---"

    ' If the song has finished, increase the counter and update it on screen.
    md = MusicDone
    IF md AND loops < 1000 THEN loops = loops + 1: LOCATE 15, 37: PRINT USING "###"; loops;
    IF md AND loops = 1000 THEN LOCATE 15, 37: PRINT "!!!"
   
    ' If the song has finished, loop it to the beginning.
    ' The variable md is used so if the music finishes between checking for a
    ' loop and calling LoopMIDI, it won't loop without updating the loop
    ' counter.
    IF md THEN LoopMIDI
   
    ' Handle the keyboard input.
    a$ = INKEY$
    IF UCASE$(a$) = "P" THEN PauseMIDI: LOCATE 15, 20: IF MIDIErrorOccured = 0 THEN PRINT "Paused "
    IF UCASE$(a$) = "R" THEN ResumeMIDI: LOCATE 15, 20: IF MIDIErrorOccured = 0 THEN PRINT "Playing"
    IF UCASE$(a$) = "S" THEN StopMIDI: LOCATE 15, 20: IF MIDIErrorOccured = 0 THEN PRINT "Stopped"
    IF UCASE$(a$) = " " THEN PlayMIDI: LOCATE 15, 20: IF MIDIErrorOccured = 0 THEN PRINT "Playing"
    IF a$ = CHR$(0) + "H" AND channel = 1 THEN channel = 0: needtoredrawvols = TRUE
    IF a$ = CHR$(0) + "P" AND channel = 0 THEN channel = 1: needtoredrawvols = TRUE
    IF a$ = CHR$(0) + "K" AND Vol(channel) > 0 THEN Vol(channel) = Vol(channel) - 1: needtoredrawvols = TRUE: SetVolume 4 + channel, Vol(channel), 0
    IF a$ = CHR$(0) + "M" AND Vol(channel) < maxvol THEN Vol(channel) = Vol(channel) + 1: needtoredrawvols = TRUE: SetVolume 4 + channel, Vol(channel), 0
    IF a$ = CHR$(13) THEN rev = rev XOR 1: ReverseStereo rev: needtoredrawvols = TRUE: LOCATE 8, 33: IF rev THEN PRINT "off" ELSE PRINT "on "
    ' If the volumes changed, redraw the bars.
    IF needtoredrawvols AND maxvol <> 0 THEN
        LOCATE 11, 28: PRINT USING "##"; Vol(0)
        LOCATE 11, 33: PRINT USING "##"; maxvol
        LOCATE 12, 28: PRINT USING "##"; Vol(1)
        LOCATE 12, 33: PRINT USING "##"; maxvol
        IF channel = 0 THEN COLOR 15 ELSE COLOR 7
        LOCATE 11, 38: PRINT STRING$(Vol(0) * LEN(Vol$), Vol$); STRING$(31 - LEN(Vol$) * Vol(0), "-")
        IF channel = 1 THEN COLOR 15 ELSE COLOR 7
        LOCATE 12, 38: PRINT STRING$(Vol(1) * LEN(Vol$), Vol$); STRING$(31 - LEN(Vol$) * Vol(1), "-")
        COLOR 7: needtoredrawvols = FALSE
    END IF

LOOP WHILE a$ <> CHR$(27)

' Free the memory (StopMIDI doesn't need to be called first, it gets called
' by UnloadMIDI if the song is still playing).
UnloadMIDI

