' Player for raw Adlib tunes
' Originally converted from a Turbo Pascal program
' Will only work in QuickBASIC
'
' E-mail: AlexanderVerhaeghe@yahoo.com
'
DEFINT A-Z
REM $INCLUDE: 'qb.bi'
REM $INCLUDE: 'sng.bi'
SCREEN 0
CLS
IF IsFM = 0 THEN
	FMReset
	returncode = PlaySNG("sample1.sng")
	'returncode = PlaySNG("sample2.sng")
	FMReset
END IF

FUNCTION AllocateMemory (bytes AS LONG, returnsegment AS INTEGER)
	DIM inregs AS RegTypeX, outregs AS RegTypeX
	DIM farheap AS LONG
	farheap = SETMEM(-bytes - 1)
	inregs.ax = &H4800
	inregs.bx = bytes \ 16
	INTERRUPTX &H21, inregs, outregs
	returnsegment = outregs.ax
	IF (outregs.flags AND 1) = 0 THEN
		AllocateMemory = 0
	ELSE
		farheap = SETMEM(bytes + 1)
		AllocateMemory = -1
	END IF
END FUNCTION

FUNCTION FindFirst (file AS STRING, attribute AS INTEGER)
	DIM inregs AS RegTypeX, outregs AS RegTypeX
	DIM filename AS STRING
	filename = file + CHR$(0)
	inregs.ax = &H4E00
	inregs.cx = attribute
	inregs.dx = SADD(filename)
	inregs.ds = VARSEG(filename)
	INTERRUPTX &H21, inregs, outregs
	IF (outregs.flags AND 1) = 0 THEN FindFirst = 0 ELSE FindFirst = -1
END FUNCTION

SUB FMReset
	DIM i AS INTEGER
	FOR i = &H1 TO &HF5
		FMWrite i, 0
	NEXT i
END SUB

SUB FMWrite (regs AS INTEGER, value AS INTEGER)
	DIM i AS INTEGER, temp AS INTEGER
	OUT &H388, regs
	FOR i = 0 TO 5
		temp = INP(&H388)
	NEXT i
	OUT &H389, value
	FOR i = 0 TO 34
		temp = INP(&H388)
	NEXT i
END SUB

FUNCTION IsFM
	DIM i AS INTEGER, temp AS INTEGER, temp1 AS INTEGER, temp2 AS INTEGER
	FMWrite &H4, &H60
	FMWrite &H4, &H80
	temp1 = INP(&H388)
	FMWrite &H2, &HFF
	FMWrite &H4, &H21
	FOR i = 1 TO 150
		temp = INP(&H388)
	NEXT i
	temp2 = INP(&H388)
	FMWrite &H4, &H60
	FMWrite &H4, &H80
	IF ((temp1 AND &HE0) = 0) AND ((temp2 AND &HE0) = &HC0) THEN IsFM = 0 ELSE IsFM = -1
END FUNCTION

FUNCTION PlaySNG (file AS STRING)
	DIM sng AS SNGheader
	DIM filenumber AS INTEGER, compression AS INTEGER, delaystart AS INTEGER
	DIM continue AS INTEGER, lowersample AS INTEGER, uppersample AS INTEGER
	DIM buffersegment AS INTEGER
	DIM buffersize AS LONG, songlength AS LONG, nodepos AS LONG, i AS LONG
	IF FindFirst(file, &H3F) = 0 THEN
		filenumber = FREEFILE
		OPEN file FOR BINARY AS filenumber
		GET filenumber, , sng
		IF sng.magic <> "ObsM" THEN
			CLOSE filenumber
			PlaySNG = -1  'invalid SNG
			EXIT FUNCTION
		END IF
		buffersize = 65536
		IF (AllocateMemory(buffersize, buffersegment) = -1) OR (LOF(filenumber) > buffersize) THEN
			CLOSE filenumber
			PlaySNG = -1  'not enough memory, SNG too big
			EXIT FUNCTION
		END IF
		songlength = CVL(MKI$(sng.songlength) + MKI$(0))
		compression = ASC(sng.compression)
		delaystart = ASC(sng.delaystart)
		DIM item(3) AS STRING
		item(0) = "Songlength :" + STR$(songlength)
		item(1) = "Compression:" + STR$(compression)
		item(2) = "Delay      :" + STR$(delaystart)
		PRINT file + SPACE$(80 - LEN(file))
		PRINT "" + STRING$(78, "") + ""
		FOR i = 0 TO 2
			PRINT " " + item(i) + SPACE$(76 - LEN(item(i))) + " "
		NEXT i
		PRINT "" + STRING$(78, "") + ""
		SEEK filenumber, sng.songstart + LEN(sng) + 1
		returncode = ReadFile(FILEATTR(filenumber, 2), buffersegment, 0, sng.songlength)
		DEF SEG = buffersegment
		i = 0
		nodepos = 0
		DO
			continue = 0
			IF compression = 1 THEN
				delaystart = delaystart - 1
				IF delaystart <> 0 THEN continue = 1
			END IF
			IF continue = 0 THEN
				i = nodepos
				DO
					lowersample = PEEK(i)
					uppersample = PEEK(i + 1)
					i = i + 2
					IF i < songlength THEN
						IF uppersample = 0 THEN
							delaystart = lowersample
							nodepos = i
							EXIT DO
						ELSE
							FMWrite uppersample, lowersample
						END IF
					ELSE
						i = sng.songloop
					END IF
				LOOP
			END IF
			WAIT &H3DA, 8
			WAIT &H3DA, 8, 8
		LOOP UNTIL (i > songlength) OR (INKEY$ = CHR$(27))
		DEF SEG
		returncode = ReleaseMemory(buffersize, buffersegment)
		CLOSE filenumber
		PlaySNG = 0  'SNG ok
	ELSE
		PlaySNG = -1  'SNG not found
	END IF
END FUNCTION

FUNCTION ReadFile (filehandle AS INTEGER, segment AS INTEGER, offset AS INTEGER, bytes AS INTEGER)
	DIM inregs AS RegTypeX, outregs AS RegTypeX
	inregs.ax = &H3F00
	inregs.bx = filehandle
	inregs.cx = bytes
	inregs.dx = offset
	inregs.ds = segment
	INTERRUPTX &H21, inregs, outregs
	IF (outregs.flags AND 1) = 0 THEN ReadFile = 0 ELSE ReadFile = -1
END FUNCTION

FUNCTION ReleaseMemory (bytes AS LONG, segment AS INTEGER)
	DIM inregs AS RegTypeX, outregs AS RegTypeX
	DIM farheap AS LONG
	inregs.ax = &H4900
	inregs.es = segment
	INTERRUPTX &H21, inregs, outregs
	IF (outregs.flags AND 1) = 0 THEN
		farheap = SETMEM(bytes + 1)
		ReleaseMemory = 0
	ELSE
		ReleaseMemory = -1
	END IF
END FUNCTION

