'                      100% Q(uick)Basic
'Fake Raytraced Textured Sphere with 2 Lights and bumpmapping
'                             by
'                     Alexander Toresson
'                  toressonodakra@swipnet.se
'
'
'Controls:
'
'Up/Down/Right/Left: Rotate View
'W/S/A/D: Rotate Sphere
'T/G/F/H: Rotate Light #1 (big, far away)
'I/K/J/L: Rotate Light #2 (small, near)
'1/2: Decrease / Increase width of sphere
'3/4: Decrease / Increase height of sphere
'4/5: Decrease / Increase bumpmapping effect
'6/7: Decrease / Increase ambient light
'F1: Show Help
'F2: Toggle Texture Mapping
'F3: Toggle Light #1
'F4: Toggle Light #2
'F5: Toggle Bumpmapping
'
'How this was possible: LOTS of precalculations!
'
'I had to use the depth array for a greyscale version of
'the texture, to significantly increase speed of
'bump-mapping. That array was anyway only used in
'the initializing.
'
'There may be out-of-memory problems on some computers.
'I wrote this program on a computer which has got 560k
'of free conventional memory, so it runs good in the IDE.
'As you probably knew, the IDE uses about 300k of memory.
'This proggy uses about 256k of memory, so even I can
'only barely run it. If there had been a byte data type
'in qb, that would have halved the memory requirements.
'
'If you've got memory problems, try
'the compiled version. If you get memory problems after
'running this proggy in the IDE, use the instruction
'CLEAR in the immediate window.
'
'
'Note: The keyboard handler is buggy.
'      I wanted the program to be 100% qb,
'      so I had no choice but to use Toshi Horie's
'      keyboard handler.
' 
'
'$DYNAMIC
DECLARE SUB PRINTX (text$)
DECLARE SUB ShowHelp ()
DECLARE SUB NumLockOff ()
DECLARE SUB GetKeys (doclear%)
DECLARE SUB DrawSphere (x%, y%, xsize%, ysize%, vx%, vy%, lx%, ly%, lx2%, ly2%, rx%, ry%, bump%, bstrength%, texture%, light1on%, light2on%, ambient%)
DECLARE SUB Normalize (vect AS ANY)
DECLARE FUNCTION ArcCos# (x#)
DIM SHARED text%(0 TO 127, 0 TO 127)
DIM SHARED TextPos%(0 TO 127, 0 TO 127, 1 TO 2)
DIM SHARED Position%(0 TO 127, 1 TO 2)
DIM SHARED Depth%(0 TO 127, 0 TO 127)
DIM SHARED Light%(0 TO 127, 0 TO 127)
DIM SHARED light2%(0 TO 127, 0 TO 127)
DIM SHARED Pal%(0 TO 255, 1 TO 3)
DIM SHARED Colors%(0 TO 255, 0 TO 127)
DIM SHARED radius#, pi#
DIM wx%, wy%, generate%
DIM xsize%, ysize%
DIM bump%, bstrength%
DIM texture%, light1on%, light2on%, ambient%
DIM holdf2%, holdf3%, holdf4%, holdf5%
DIM SHARED kbd(255), keystate(255)

TYPE Vector
x AS DOUBLE
y AS DOUBLE
z AS DOUBLE
END TYPE

DIM HitPoint AS Vector, HitNormal AS Vector, LightSource AS Vector
DIM LightVector AS Vector, LightSource2 AS Vector

FOR k = 0 TO 255: keystate(k) = -((k AND 128) = 0): NEXT k

LightSource.x = 63
LightSource.y = -4096
LightSource.z = 63

LightSource2.x = 63
LightSource2.y = -16
LightSource2.z = 63

texture% = 1
light1on% = 1
light2on% = 1
ambient% = 24
bump% = 1
bstrength% = 16

xsize% = 127
ysize% = 106

pi# = ATN(1) * 4
radius# = 64

OPEN "Pallette.inf" FOR BINARY AS #1
IF LOF(1) = 0 THEN
generate% = 1
ELSE
generate% = 0
END IF
CLOSE #1

ShowHelp

SCREEN 13
OPEN "Text.pal" FOR BINARY AS #1
r$ = " "
g$ = " "
b$ = " "
OUT &H3C8, 0
FOR a% = 0 TO 255
GET #1, 25 + 4 * a%, r$
GET #1, 26 + 4 * a%, g$
GET #1, 27 + 4 * a%, b$
Pal%(a%, 1) = ASC(r$)
Pal%(a%, 2) = ASC(g$)
Pal%(a%, 3) = ASC(b$)
OUT &H3C9, INT(ASC(r$) / 4)
OUT &H3C9, INT(ASC(g$) / 4)
OUT &H3C9, INT(ASC(b$) / 4)
'OUT &H3C9, a% / 4
'OUT &H3C9, a% / 4
'OUT &H3C9, a% / 4
NEXT a%
CLOSE #1

CLS

IF generate% = 1 THEN

FOR a% = 0 TO 255
COLOR 255
LOCATE 1, 1
PRINT "Creating Pallette info... ";
PRINT USING "## % done"; a% / 256 * 100
FOR b% = 0 TO 127
best% = -1
bestpoint% = 1000
newr% = Pal%(a%, 1) * b% / 64
newg% = Pal%(a%, 2) * b% / 64
newb% = Pal%(a%, 3) * b% / 64
FOR c% = 0 TO 255
points% = SQR((Pal%(c%, 1) - newr%) ^ 2 + (Pal%(c%, 2) - newg%) ^ 2 + (Pal%(c%, 3) - newb%) ^ 2)
IF points% < bestpoint% THEN
bestpoint% = points%
best% = c%
END IF
NEXT c%
Colors%(a%, b%) = best%
NEXT b%
NEXT a%

LOCATE 1, 1
PRINT "Creating Pallette info... Done!        "

OPEN "Pallette.inf" FOR BINARY AS #1
FOR a% = 0 TO 255
FOR b% = 0 TO 127
c$ = CHR$(Colors%(a%, b%))
PUT #1, , c$
NEXT b%
NEXT a%
CLOSE #1

LOCATE 2, 1
PRINT "Pallette info was stored on hard drive"

ELSE

OPEN "Pallette.inf" FOR BINARY AS #1
c$ = " "
FOR a% = 0 TO 255
FOR b% = 0 TO 127
GET #1, , c$
Colors%(a%, b%) = ASC(c$)
NEXT b%
NEXT a%
CLOSE #1

END IF

OPEN "Text.raw" FOR BINARY AS #1
c$ = " "
FOR y% = 0 TO 127
FOR x% = 0 TO 127
GET #1, , c$
text%(x%, y%) = ASC(c$)
NEXT x%
NEXT y%
CLOSE #1

FOR y% = 0 TO 127
COLOR 255
LOCATE 3, 1
PRINT "Creating Sphere data... ";
PRINT USING "## % done"; y% / 128 * 100
FOR x% = 0 TO 127
b% = 128
FOR a% = 0 TO 127
IF SQR((x% - 63.5) ^ 2 + (y% - 63.5) ^ 2 + (a% - 63.5) ^ 2) <= radius# THEN
b% = a%
EXIT FOR
END IF
NEXT a%
'PRINT a%;
Depth%(x%, y%) = b%
TextPos%(x%, y%, 1) = (((pi# / 256) / 2) - ATN((x% - 63.5) / (b% - 63.5))) * 41 + 63.5
TextPos%(x%, y%, 2) = (ATN((y% - 63.5) / (b% - 63.5))) * 41 + 63.5
'IF y% > 63.5 THEN
'angle# = 45 - ATN((SQR(((63.5 - x%) ^ 2 + (63.5 - b%) ^ 2 + (63.5 - y%) ^ 2) - ((63.5 - x%) ^ 2))) / ABS(63.5 - y%)) * (180 / pi#) / 2 + 45
''Light%(x%, y%) = 64
'ELSE
''angle# = ATN(ABS(63.5 - x%) / (SQR(((63.5 - x%) ^ 2 + (63.5 - b%) ^ 2 + (63.5 - y%) ^ 2) - ((63.5 - x%) ^ 2)))) * (180 / pi#)
''angle# = ATN(ABS(63.5 - b%) / (SQR(((63.5 - x%) ^ 2 + (63.5 - b%) ^ 2 + (63.5 - y%) ^ 2) - ((63.5 - x%) ^ 2)))) * (180 / pi#)
''angle# = ATN((SQR(((63.5 - x%) ^ 2 + (63.5 - b%) ^ 2 + (63.5 - y%) ^ 2) - ((63.5 - x%) ^ 2))) / ABS(63.5 - y%)) * (180 / pi#) / 2
''angle# = ATN((SQR(((63.5 - x%) ^ 2 + (63.5 - b%) ^ 2 + (63.5 - y%) ^ 2) - ((63.5 - x%) ^ 2))) / ABS(63.5 - x%)) * (180 / pi#)
''angle# = ATN(ABS(63.5 - x%) / ABS(63.5 - b%)) * (180 / pi#)
''PRINT angle#
''angle# = 90 - angle#
''Light%(x%, y%) = angle#
'END IF

'Light%(x%, y%) = 255 * COS(angle# * (pi# / 180)) ^ 4
'IF x% = 63 THEN
'PRINT y%, angle#, Light%(x%, y%), b%
'DO
'LOOP WHILE INKEY$ = ""
'END IF
NEXT x%
NEXT y%

LOCATE 3, 1
PRINT "Creating Sphere data... Done!         "

FOR y% = 0 TO 127
a% = 128
FOR x% = 0 TO 127
IF Depth%(x%, y%) < 128 THEN
a% = x%
EXIT FOR
END IF
NEXT x%
Position%(y%, 1) = a%
a% = 128
FOR x% = 127 TO 0 STEP -1
IF Depth%(x%, y%) < 128 THEN
a% = x%
EXIT FOR
END IF
NEXT x%
Position%(y%, 2) = a%
NEXT y%

FOR y% = 0 TO 127
COLOR 255
LOCATE 4, 1
PRINT "Creating Lightmap #1... ";
PRINT USING "## % done"; y% / 128 * 100
FOR x% = 0 TO 127
HitPoint.x = -radius# * SIN(y% * (pi# / 128)) * COS(x% * (pi# / 128)) + 63.5
HitPoint.y = -radius# * SIN(y% * (pi# / 128)) * SIN(x% * (pi# / 128)) + 63.5
HitPoint.z = -radius# * COS(y% * (pi# / 128)) + 63.5

HitNormal.x = (63.5 - HitPoint.x) / radius#
HitNormal.y = (63.5 - HitPoint.y) / radius#
HitNormal.z = (63.5 - HitPoint.z) / radius#

'Normalize HitPoint

LightVector.x = HitPoint.x - LightSource.x
LightVector.y = HitPoint.y - LightSource.y
LightVector.z = HitPoint.z - LightSource.z

div# = ((LightVector.x ^ 2 + LightVector.y ^ 2 + LightVector.z ^ 2) * (HitNormal.x ^ 2 + HitNormal.y ^ 2 + HitNormal.z ^ 2))

IF div# = 0 THEN
cosoftheta# = (LightVector.x * HitNormal.x + LightVector.y * HitNormal.y + LightVector.z * HitNormal.z)
ELSE
cosoftheta# = (LightVector.x * HitNormal.x + LightVector.y * HitNormal.y + LightVector.z * HitNormal.z) / div#
END IF

angle# = ArcCos#(cosoftheta#) * (180 / pi#)
'angle# = cosoftheta# * 90

IF angle# > 90 THEN angle# = 90

'IF x% = 63 THEN
'PRINT cosoftheta#, y%
'END IF

'IF y% < 64 AND x% < 64 THEN
Light%(x%, y%) = (111 * COS(angle# * (pi# / 180))) * 1000 + 0
'ELSE
'Light%(x%, y%) = 0
'END IF
IF Light%(x%, y%) > 111 THEN Light%(x%, y%) = 111
IF Light%(x%, y%) < 0 THEN Light%(x%, y%) = 0
NEXT x%
NEXT y%

LOCATE 4, 1
PRINT "Creating Lightmap #1... Done!        "

FOR y% = 0 TO 127
COLOR 255
LOCATE 5, 1
PRINT "Creating Lightmap #2... ";
PRINT USING "## % done"; y% / 128 * 100
FOR x% = 0 TO 127
HitPoint.x = -radius# * SIN(y% * (pi# / 128)) * COS(x% * (pi# / 128)) + 63.5
HitPoint.y = -radius# * SIN(y% * (pi# / 128)) * SIN(x% * (pi# / 128)) + 63.5
HitPoint.z = -radius# * COS(y% * (pi# / 128)) + 63.5

HitNormal.x = (63.5 - HitPoint.x) / radius#
HitNormal.y = (63.5 - HitPoint.y) / radius#
HitNormal.z = (63.5 - HitPoint.z) / radius#

'Normalize HitPoint

LightVector.x = HitPoint.x - LightSource2.x
LightVector.y = HitPoint.y - LightSource2.y
LightVector.z = HitPoint.z - LightSource2.z

div# = ((LightVector.x ^ 2 + LightVector.y ^ 2 + LightVector.z ^ 2) * (HitNormal.x ^ 2 + HitNormal.y ^ 2 + HitNormal.z ^ 2))

IF div# = 0 THEN
cosoftheta# = (LightVector.x * HitNormal.x + LightVector.y * HitNormal.y + LightVector.z * HitNormal.z)
ELSE
cosoftheta# = (LightVector.x * HitNormal.x + LightVector.y * HitNormal.y + LightVector.z * HitNormal.z) / div#
END IF

angle# = ArcCos#(cosoftheta#) * (180 / pi#)
'angle# = cosoftheta# * 90

IF angle# > 90 THEN angle# = 90

'IF x% = 63 THEN
'PRINT cosoftheta#, y%
'END IF

'IF y% < 64 AND x% < 64 THEN
light2%(x%, y%) = (111 * COS(angle# * (pi# / 180))) * 8 + 0
'ELSE
'Light%(x%, y%) = 0
'END IF
IF light2%(x%, y%) > 111 THEN Light%(x%, y%) = 111
IF light2%(x%, y%) < 0 THEN Light%(x%, y%) = 0
NEXT x%
NEXT y%

LOCATE 5, 1
PRINT "Creating Lightmap #2... Done!        "

FOR y% = 0 TO 127
FOR x% = 0 TO 127
Depth%(x%, y%) = Pal%(text%(x%, y%), 1) + Pal%(text%(x%, y%), 2) + Pal%(text%(x%, y%), 3)
NEXT x%
NEXT y%

CLS

t# = TIMER

DEF SEG = &HA000
DO
NumLockOff
GetKeys 1

DrawSphere 160, 100, xsize%, ysize%, wx%, wy%, lx%, ly%, lx2%, ly2%, rx%, ry%, bump%, bstrength%, texture%, light1on%, light2on%, ambient%

GetKeys 1

IF kbd(2) THEN xsize% = xsize% - 2: WAIT &H3DA, 8, 8: LINE (0, 0)-(319, 299), 0, BF
IF kbd(3) THEN xsize% = xsize% + 2
IF kbd(4) THEN ysize% = ysize% - 2: WAIT &H3DA, 8, 8: LINE (0, 0)-(319, 299), 0, BF
IF kbd(5) THEN ysize% = ysize% + 2

IF kbd(6) THEN bstrength% = bstrength% - 1
IF kbd(7) THEN bstrength% = bstrength% + 1

IF bstrength% = 0 THEN bstrength% = 1
IF bstrength% = 128 THEN bstrength% = 127

IF kbd(8) THEN ambient% = ambient% - 1
IF kbd(9) THEN ambient% = ambient% + 1

IF ambient% = -1 THEN ambient% = -0
IF ambient% = 128 THEN ambient% = 127

IF kbd(60) AND holdf2% = 0 THEN
texture% = texture% XOR 1
END IF

IF kbd(61) AND holdf3% = 0 THEN
light1on% = light1on% XOR 1
END IF

IF kbd(62) AND holdf4% = 0 THEN
light2on% = light2on% XOR 1
END IF

IF kbd(63) AND holdf5% = 0 THEN
bump% = bump% XOR 1
END IF

IF kbd(63) THEN
holdf5% = 1
ELSE
holdf5% = 0
END IF

IF kbd(62) THEN
holdf4% = 1
ELSE
holdf4% = 0
END IF

IF kbd(61) THEN
holdf3% = 1
ELSE
holdf3% = 0
END IF

IF kbd(60) THEN
holdf2% = 1
ELSE
holdf2% = 0
END IF

IF xsize% > 319 THEN xsize% = 319
IF ysize% > 199 THEN ysize% = 199
IF xsize% < 1 THEN xsize% = 1
IF ysize% < 1 THEN ysize% = 1

IF kbd(77) THEN wx% = wx% - 1
IF kbd(75) THEN wx% = wx% + 1
IF kbd(72) THEN wy% = wy% - 1
IF kbd(80) THEN wy% = wy% + 1

IF kbd(17) THEN ry% = ry% - 1 'W
IF kbd(31) THEN ry% = ry% + 1 'S
IF kbd(32) THEN rx% = rx% - 1 'D
IF kbd(30) THEN rx% = rx% + 1 'A

IF kbd(20) THEN ly% = ly% - 1 'T
IF kbd(34) THEN ly% = ly% + 1 'G
IF kbd(35) THEN lx% = lx% - 1 'H
IF kbd(33) THEN lx% = lx% + 1 'F

IF kbd(23) THEN ly2% = ly2% - 1 'I
IF kbd(37) THEN ly2% = ly2% + 1 'K
IF kbd(38) THEN lx2% = lx2% - 1 'L
IF kbd(36) THEN lx2% = lx2% + 1 'J

IF kbd(59) THEN
SCREEN 0
WIDTH 80, 25
ShowHelp
SCREEN 13
OUT &H3C8, 0
FOR a% = 0 TO 255
OUT &H3C9, Pal%(a%, 1) \ 4
OUT &H3C9, Pal%(a%, 2) \ 4
OUT &H3C9, Pal%(a%, 3) \ 4
NEXT a%
FOR k = 0 TO 255: keystate(k) = -((k AND 128) = 0): NEXT k
END IF

IF wx% > 256 THEN wx% = wx% - 256
IF wy% > 256 THEN wy% = wy% - 256
IF wx% < -256 THEN wx% = wx% + 256
IF wy% < -256 THEN wy% = wy% + 256
IF lx% > 256 THEN lx% = lx% - 256
IF ly% > 256 THEN ly% = ly% - 256
IF lx% < -256 THEN lx% = lx% + 256
IF ly% < -256 THEN ly% = ly% + 256
IF lx2% > 256 THEN lx2% = lx2% - 256
IF ly2% > 256 THEN ly2% = ly2% - 256
IF lx2% < -256 THEN lx2% = lx2% + 256
IF ly2% < -256 THEN ly2% = ly2% + 256
IF rx% > 256 THEN rx% = rx% - 256
IF ry% > 256 THEN ry% = ry% - 256
IF rx% < -256 THEN rx% = rx% + 256
IF ry% < -256 THEN ry% = ry% + 256
frames% = frames% + 1
GetKeys 1
IF TIMER - t# > 1 THEN
LOCATE 1, 1
PRINT USING "#####.## fps"; frames% / (TIMER - t#)
frames% = 0
t# = TIMER
END IF
LOOP UNTIL kbd(1)
DEF SEG

REM $STATIC
FUNCTION ArcCos# (x#)
ArcCos# = pi# / 2 - 2 * ATN(x# / (1! + SQR(1! - x * x)))
'PI_HALF - 2 * arctan(x / (1.0 + sqrt(1.0 - x * x)))
END FUNCTION

SUB DrawSphere (x%, y%, xsize%, ysize%, vx%, vy%, lx%, ly%, lx2%, ly2%, rx%, ry%, bump%, bstrength%, texture%, light1on%, light2on%, ambient%)
y4% = CINT(y% - ysize% / 2)
x4% = CINT(x% - xsize% / 2)
stepx% = (127 / xsize%) * 128
stepy% = (127 / ysize%) * 128
add& = CLNG(y4%) * 320! + CLNG(x4%)
FOR y% = 0 TO 16256 STEP stepy%
y5% = y% \ 128
IF Position%(y5%, 1) < 128 THEN
add& = add& + Position%(y5%, 1) * xsize% \ 128
FOR x% = Position%(y5%, 1) * 128 TO Position%(y5%, 2) * 128 STEP stepx%
x5% = x% \ 128
IF light1on% OR light2on% OR texture% THEN
x2% = TextPos%(x5%, y5%, 1) + vx%
y2% = TextPos%(x5%, y5%, 2) + vy%
ELSE
x2% = 0
y2% = 0
END IF
IF bump% THEN
x6% = x2% + rx%
y6% = y2% + ry%
bx% = (Depth%((x6% - 1) AND 127, y6% AND 127) - Depth%((x6% + 1) AND 127, y6% AND 127)) \ bstrength%
by% = (Depth%(x6% AND 127, (y6% - 1) AND 127) - Depth%(x6% AND 127, (y6% + 1) AND 127)) \ bstrength%
xl1% = (x2% + lx% + bx%) AND 255
yl1% = (y2% + ly% + by%) AND 255
xl2% = (x2% + lx2% + bx%) AND 255
yl2% = (y2% + ly2% + by%) AND 255
ELSE
xl1% = (x2% + lx%) AND 255
yl1% = (y2% + ly%) AND 255
xl2% = (x2% + lx2%) AND 255
yl2% = (y2% + ly2%) AND 255
END IF
x2% = x2% + rx%
y2% = y2% + ry%
IF light1on% THEN
IF xl1% < 128 AND yl1% < 128 THEN
curlight% = Light%(xl1%, yl1%) + 0
ELSE
curlight% = 0
END IF
ELSE
curlight% = 0
END IF
IF light2on% THEN
IF xl2% < 128 AND yl2% < 128 THEN
curlight% = curlight% + light2%(xl2%, yl2%)
ELSE
curlight% = curlight%
END IF
END IF
curlight% = curlight% + ambient%
IF curlight% > 127 THEN curlight% = 127
IF curlight% < 0 THEN curlight% = 0
IF texture% THEN
POKE add&, Colors%(text%(x2% AND 127, y2% AND 127), curlight%)
ELSE
POKE add&, Colors%(192, curlight%)
END IF
add& = add& + 1
NEXT x%
END IF
y4% = y4% + 1
add& = (CLNG(y4%)) * 320! + CLNG(x4%)
NEXT y%
END SUB

SUB GetKeys (doclear%)
    'clear keyboard buffer every other frame
    IF doclear% THEN
    DEF SEG = &H40
    POKE &H1C, PEEK(&H1A)
    DEF SEG = &HA000
    END IF

    'Fill multikey state table
    'Each key entry indexed by scancode is either a 1 for depressed
    'or a 0 for released.
    k = INP(&H60): kbd(k AND 127) = keystate(k)

END SUB

SUB Normalize (vect AS Vector)
IF ABS(vect.x) > ABS(vect.y) AND ABS(vect.x) > ABS(vect.z) THEN
vect.x = vect.x / vect.x
vect.y = vect.y / vect.x
vect.z = vect.z / vect.x
ELSEIF ABS(vect.y) > ABS(vect.x) AND ABS(vect.y) > ABS(vect.z) THEN
vect.x = vect.x / vect.y
vect.y = vect.y / vect.y
vect.z = vect.z / vect.y
ELSEIF ABS(vect.z) > ABS(vect.x) AND ABS(vect.z) > ABS(vect.y) THEN
vect.x = vect.x / vect.z
vect.y = vect.y / vect.z
vect.z = vect.z / vect.z
END IF
END SUB

SUB NumLockOff
'Set NumLock and other shift keys off
'-----------------------------------------------------------
REM This is absolutely necessary, since the demo code assumes
REM a depressed key will always return a 0 in the lower 7 bits.
DEF SEG = &H40: POKE &H17, 0: DEF SEG = &HA000
END SUB

SUB PRINTX (text$)
LOCATE , 40 - LEN(text$) \ 2
PRINT text$
END SUB

SUB ShowHelp
CLS
PRINTX "100% Q(uick)Basic"
PRINTX "Fake Raytraced Textured Sphere with 2 Lights and bumpmapping"
PRINTX "by"
PRINTX "Alexander Toresson"
PRINTX "toressonodakra@swipnet.se"
PRINT
PRINTX "Controls:"
PRINT
PRINTX "Up/Down/Right/Left: Rotate View"
PRINTX "W/S/A/D: Rotate Sphere"
PRINTX "T/G/F/H: Rotate Light #1 (big, far away)"
PRINTX "I/K/J/L: Rotate Light #2 (small, near)"
PRINTX "1/2: Decrease / Increase width of sphere"
PRINTX "3/4: Decrease / Increase height of sphere"
PRINTX "5/6: Decrease / Increase bumpmapping effect"
PRINTX "7/8: Decrease / Increase ambient light"
PRINTX "F1: Show Help (this page)"
PRINTX "F2: Toggle Texture Mapping"
PRINTX "F3: Toggle Light #1"
PRINTX "F4: Toggle Light #2"
PRINTX "F5: Toggle Bumpmapping"
PRINTX "Esc: Quit"
PRINT
PRINTX "Press any key to continue"

DO
LOOP WHILE INKEY$ = ""

END SUB

