'/////////////////////////////////////////////////////////////////////////////
'//|                                                                       |//
'//|     ////////////////                                                  |//
'//|     U G L  - P O N G                                                  |//
'//|     ////////////////                                                  |//
'//|                                                                       |//
'//|     Version: 1.0                                                      |//
'//|     Author:  Tomer Filiba                                             |//
'//|     Email:   thetomer@mail.com                                        |//
'//|     Website: http://bitwise.cjb.net                                   |//
'//|                                                                       |//
'//|                                                                       |//
'//|     A simple Pong game made with UGL so that blitz and v1ctor         |//
'//|     won't feel unneeded :)                                            |//
'//|     Anyway, it uses a very simple AI. Feel free to modify and         |//
'//|     learn from this UGL example. For questions or anything of         |//
'//|     the kind, email me.                                               |//
'//|                                                                       |//
'//|                                                                       |//
'//|                                                                       |//
'/////////////////////////////////////////////////////////////////////////////
DECLARE SUB doBall ()
DECLARE SUB doComputer ()
DECLARE SUB doDraw ()
DECLARE SUB doPlayer ()
DECLARE SUB doStatistics ()
DECLARE SUB EndPong ()
DECLARE SUB InitPong ()
DECLARE SUB uglWrite (X%, Y%, text$, size%)

REM $STATIC
REM $INCLUDE: 'ugl.bi'
REM $INCLUDE: 'kbd.bi'
REM $INCLUDE: 'tmr.bi'
REM $INCLUDE: 'font.bi'
OPTION EXPLICIT              ' <--- ONLY IN VBDOS
DEFINT A-Z

CONST radian = 180 / 3.14159265359#

TYPE box2D
  X1 AS INTEGER
  Y1 AS INTEGER
  X2 AS INTEGER
  Y2 AS INTEGER
END TYPE

TYPE PaddleType
  oX AS INTEGER
  oY AS INTEGER
  X AS SINGLE
  Y AS SINGLE
  Width AS INTEGER
  Height AS INTEGER
  Shifted AS INTEGER
  Speed AS INTEGER              ' pixels per second
  Score AS INTEGER
  imgDC AS LONG
  bgDC AS LONG
END TYPE

TYPE BallType
  oX AS INTEGER
  oY AS INTEGER
  X AS SINGLE
  Y AS SINGLE
  Radius AS INTEGER
  Speed AS INTEGER              ' pixels per second
  Angle AS INTEGER              ' angle in degrees
  imgDC AS LONG
  bgDC AS LONG
END TYPE

TYPE EnvType
  Width AS INTEGER
  Height AS INTEGER
  Colors AS INTEGER
  ViewPage AS INTEGER
  WorkPage AS INTEGER
  VideoDC AS LONG
  hFont AS LONG
  FPS AS INTEGER
  fpsTimer AS TMR
  Keyboard AS TKBD
  PlayComputer AS INTEGER
END TYPE
'----------------------------------------------------------------------------

DIM SHARED Env AS EnvType
DIM SHARED Box AS box2D, Ball AS BallType
DIM SHARED Player AS PaddleType, Computer AS PaddleType
DIM curFPS AS LONG, t!

ON ERROR GOTO OnGlobalError


SHELL "cd c:\vbdos\bas\pong"

InitPong
curFPS = 60                '' to prevent division by zero

DO
  curFPS = curFPS + 1
  'IF Env.fpsTimer.State = TMR.OFF THEN
  IF TIMER > t! + 1 THEN
    Env.FPS = curFPS
    curFPS = 0
    doStatistics
    t! = TIMER
    tmrNew Env.fpsTimer, TMR.ONESHOT, tmrSec2Freq(1)
  END IF
  
  doBall
  doPlayer
  doComputer
  doDraw
LOOP


END
OnGlobalError:
  EndPong
  CLS
  PRINT "VBDOS ERROR #"; ERR; " - "; ERROR$
  END

SUB doBall ()

  Ball.oX = Ball.X
  Ball.oY = Ball.Y
  Ball.X = Ball.X + Ball.Speed * COS(Ball.Angle / radian) / Env.FPS
  Ball.Y = Ball.Y + Ball.Speed * SIN(Ball.Angle / radian) / Env.FPS

  IF Ball.X > Box.X2 - Ball.Radius * 2 THEN     '' hit left wall
    Ball.X = Box.X2 - Ball.Radius * 2
    Ball.Angle = -180 - Ball.Angle
    PLAY "MBL64A"
  ELSEIF Ball.X < Box.X1 THEN                   '' hit right wall
    Ball.X = Box.X1
    Ball.Angle = -180 - Ball.Angle
    PLAY "MBL64A"
  END IF

  IF Ball.Y > Box.Y2 - Ball.Radius * 2 THEN     '' hit bottom wall
    Ball.X = (Box.X1 + Box.X2 - Ball.Radius) / 2
    Ball.Y = (Box.Y1 + Box.Y2 - Ball.Radius) / 2
    Ball.Angle = RND * 45
    Computer.Score = Computer.Score + 1
    PLAY "MBL64GGBBG"
    doStatistics
  ELSEIF Ball.Y < Box.Y1 THEN                   '' hit top wall
    Ball.X = (Box.X1 + Box.X2 - Ball.Radius) / 2
    Ball.Y = (Box.Y1 + Box.Y2 - Ball.Radius) / 2
    Ball.Angle = 270 + RND * 45
    Player.Score = Player.Score + 1
    PLAY "MBL64GGBBG"
    doStatistics
  END IF

  '' hit player
  IF Ball.Y + Ball.Radius * 2 >= Player.Y AND Ball.Y + Ball.Radius * 2 < Player.Y + Player.Height THEN
    IF (Ball.X >= Player.X AND Ball.X < Player.X + Player.Shifted) OR (Ball.X + Ball.Radius * 2 >= Player.X AND Ball.X + Ball.Radius * 2 < Player.X + Player.Shifted) THEN
      Ball.Y = Player.Y - Ball.Radius * 2 - 1
      Ball.Angle = -Ball.Angle - 45
      PLAY "MBL64A"
    ELSEIF (Ball.X >= Player.X + Player.Shifted AND Ball.X < Player.X + Player.Width - Player.Shifted) OR (Ball.X + Ball.Radius * 2 >= Player.X + Player.Shifted AND Ball.X + Ball.Radius * 2 < Player.X + Player.Width - Player.Shifted) THEN
      Ball.Y = Player.Y - Ball.Radius * 2 - 1
      Ball.Angle = -Ball.Angle
      PLAY "MBL64A"
    ELSEIF (Ball.X >= Player.X + Player.Width - Player.Shifted AND Ball.X < Player.X + Player.Width) OR (Ball.X + Ball.Radius * 2 >= Player.X + Player.Width - Player.Shifted AND Ball.X + Ball.Radius * 2 < Player.X + Player.Width) THEN
      Ball.Y = Player.Y - Ball.Radius * 2 - 1
      Ball.Angle = -Ball.Angle + 45
      PLAY "MBL64A"
    END IF
  END IF

  '' hit computer
  IF (Ball.Y >= Computer.Y AND Ball.Y < Computer.Y + Computer.Height) THEN
    IF (Ball.X >= Computer.X AND Ball.X < Computer.X + Computer.Shifted) OR (Ball.X + Ball.Radius * 2 >= Computer.X AND Ball.X + Ball.Radius * 2 < Computer.X + Computer.Shifted) THEN
      Ball.Y = Computer.Y + Computer.Height + 1
      Ball.Angle = -Ball.Angle + 45
      PLAY "MBL64A"
    ELSEIF (Ball.X >= Computer.X + Computer.Shifted AND Ball.X < Computer.X + Computer.Width - Computer.Shifted) OR (Ball.X + Ball.Radius * 2 >= Computer.X + Computer.Shifted AND Ball.X + Ball.Radius * 2 < Computer.X + Computer.Width - Computer. _
Shifted) THEN
      Ball.Y = Computer.Y + Computer.Height + 1
      Ball.Angle = -Ball.Angle
      PLAY "MBL64A"
    ELSEIF (Ball.X >= Computer.X + Computer.Width - Computer.Shifted AND Ball.X < Computer.X + Computer.Width) OR (Ball.X + Ball.Radius * 2 >= Computer.X + Computer.Width - Computer.Shifted AND Ball.X + Ball.Radius * 2 < Computer.X + Computer.Width) _
 THEN
      Ball.Y = Computer.Y + Computer.Height + 1
      Ball.Angle = -Ball.Angle - 45
      PLAY "MBL64A"
    END IF
  END IF

  Ball.Angle = Ball.Angle MOD 360
  IF Ball.Angle < 0 THEN Ball.Angle = Ball.Angle + 360
  IF Ball.Angle = 0 THEN Ball.Angle = 1
  IF Ball.Angle = 180 THEN Ball.Angle = 179
  
END SUB

SUB doComputer ()
  DIM hit

  Computer.oX = Computer.X
  Computer.oY = Computer.Y

  IF Ball.Angle > 180 AND Ball.Angle < 360 THEN
    IF ABS(Computer.X - Ball.X) > Computer.Speed / Env.FPS THEN
      IF Computer.X + Computer.Width / 2 > Ball.X THEN
        Computer.X = Computer.X - Computer.Speed / Env.FPS
        IF Computer.X < Box.X1 THEN Computer.X = Box.X1
      ELSEIF Computer.X + Computer.Width / 2 < Ball.X THEN
        Computer.X = Computer.X + Computer.Speed / Env.FPS
        IF Computer.X > Box.X2 - Computer.Width THEN Computer.X = Box.X2 - Computer.Width
      END IF
    END IF
  ELSE
    IF ABS(Computer.X - (Box.X1 + Box.X2 - Computer.Width) / 2) > Computer.Speed / Env.FPS THEN
      IF Computer.X > (Box.X1 + Box.X2 - Computer.Width) / 2 THEN
        Computer.X = Computer.X - Computer.Speed / Env.FPS
        IF Computer.X < Box.X1 THEN Computer.X = Box.X1
      ELSEIF Computer.X < (Box.X1 + Box.X2 - Computer.Width) / 2 THEN
        Computer.X = Computer.X + Computer.Speed / Env.FPS
        IF Computer.X > Box.X2 - Computer.Width THEN Computer.X = Box.X2 - Computer.Width
      END IF
    END IF
  END IF
END SUB

SUB doDraw ()
  '' put old background
  uglPut Env.VideoDC, Ball.oX, Ball.oY, Ball.bgDC
  uglPut Env.VideoDC, Player.oX, Player.oY, Player.bgDC
  uglPut Env.VideoDC, Computer.oX, Computer.oY, Computer.bgDC

  '' get new background
  uglGet Env.VideoDC, Ball.X, Ball.Y, Ball.bgDC
  uglGet Env.VideoDC, Player.X, Player.Y, Player.bgDC
  uglGet Env.VideoDC, Computer.X, Computer.Y, Computer.bgDC

  '' put imgs
  uglPutMsk Env.VideoDC, Ball.X, Ball.Y, Ball.imgDC
  uglPutMsk Env.VideoDC, Player.X, Player.Y, Player.imgDC
  uglPutMsk Env.VideoDC, Computer.X, Computer.Y, Computer.imgDC

  '' draw box
  uglRect Env.VideoDC, Box.X1, Box.Y1, Box.X2, Box.Y2, uglColor(Env.Colors, 255, 255, 255)

  '' vsync
  WAIT &H3DA, 8
  WAIT &H3DA, 8, 8
END SUB

SUB doPlayer ()
  Player.oX = Player.X
  Player.oY = Player.Y
  
  IF Env.Keyboard.Esc THEN
    EndPong
    END
  ELSEIF Env.Keyboard.SpcBar THEN
    Env.PlayComputer = NOT Env.PlayComputer
    Env.Keyboard.SpcBar = 0
  ELSEIF Env.PlayComputer THEN
    IF Ball.Angle > 0 AND Ball.Angle < 180 THEN
      IF ABS(Player.X - Ball.X) > Computer.Speed / Env.FPS THEN
        IF Player.X + Player.Width / 2 > Ball.X THEN
          Player.X = Player.X - Player.Speed / Env.FPS
          IF Player.X < Box.X1 THEN Player.X = Box.X1
        ELSEIF Player.X + Player.Width / 2 < Ball.X THEN
          Player.X = Player.X + Player.Speed / Env.FPS
          IF Player.X > Box.X2 - Player.Width THEN Player.X = Box.X2 - Player.Width
        END IF
      END IF
    ELSE
      IF ABS(Player.X + -(Box.X1 + Box.X2 - Player.Width) / 2) > Computer.Speed / Env.FPS THEN
        IF Player.X > (Box.X1 + Box.X2 - Player.Width) / 2 THEN
          Player.X = Player.X - Player.Speed / Env.FPS
          IF Player.X < Box.X1 THEN Player.X = Box.X1
        ELSEIF Player.X < (Box.X1 + Box.X2 - Player.Width) / 2 THEN
          Player.X = Player.X + Player.Speed / Env.FPS
          IF Player.X > Box.X2 - Player.Width THEN Player.X = Box.X2 - Player.Width
        END IF
      END IF
    END IF
  ELSEIF NOT Env.PlayComputer THEN
    IF Env.Keyboard.Left THEN
      Player.X = Player.X - Player.Speed / Env.FPS
      IF Player.X < Box.X1 THEN Player.X = Box.X1
    ELSEIF Env.Keyboard.Right THEN
      Player.X = Player.X + Player.Speed / Env.FPS
      IF Player.X > Box.X2 - Player.Width THEN Player.X = Box.X2 - Player.Width
    END IF
  END IF
  
END SUB

SUB doStatistics ()
  uglRectF Env.VideoDC, 0, 0, 150, 60, 0
  uglWrite 0, 0, "FPS:", 15
  uglWrite 100, 0, STR$(Env.FPS), 15
  uglWrite 0, 20, "Player:", 15
  uglWrite 100, 20, STR$(Player.Score), 15
  uglWrite 0, 40, "Computer:", 15
  uglWrite 100, 40, STR$(Computer.Score), 15
END SUB

SUB EndPong ()
  kbdEnd
  tmrEnd
  uglRestore
  uglEnd
END SUB

SUB InitPong ()
  tmrInit
  kbdInit Env.Keyboard
  IF NOT uglInit THEN PRINT "Cannot initialize UGL": END
  Env.hFont = fontNew("arial.uvf")
  IF Env.hFont = 0 THEN PRINT "Cannot load font": END

  RANDOMIZE

  Env.FPS = 1    '' to prevent division by zero
  Env.Width = 640
  Env.Height = 480
  Env.Colors = UGL.16BIT
  Env.VideoDC = uglSetVideoDC(Env.Colors, Env.Width, Env.Height, 1)
  Env.ViewPage = 0
  Env.WorkPage = 0
  uglSetWrkPage Env.WorkPage
  uglSetVisPage Env.ViewPage

  Box.X1 = 100
  Box.Y1 = 100
  Box.X2 = 540
  Box.Y2 = 380

  Player.Speed = 200
  Player.Width = 40
  Player.Height = 15
  Player.Shifted = 7
  Player.X = (Box.X1 + Box.X2 - Player.Width) / 2
  Player.Y = Box.Y2 - Player.Height
  Player.imgDC = uglNew(UGL.EMS, Env.Colors, Player.Width, Player.Height)
  Player.bgDC = uglNew(UGL.EMS, Env.Colors, Player.Width, Player.Height)
  Player.Score = 0
  uglClear Player.bgDC, 0
  Player.imgDC = uglNewBMP(UGL.EMS, Env.Colors, "plyr.bmp")

  Computer.Speed = 200
  Computer.Width = 40
  Computer.Height = 15
  Computer.Shifted = 7
  Computer.X = (Box.X1 + Box.X2 - Computer.Width) / 2
  Computer.Y = Box.Y1
  Computer.imgDC = uglNew(UGL.EMS, Env.Colors, Computer.Width, Computer.Height)
  Computer.bgDC = uglNew(UGL.EMS, Env.Colors, Computer.Width, Computer.Height)
  Computer.Score = 0
  uglClear Computer.bgDC, 0
  Computer.imgDC = uglNewBMP(UGL.EMS, Env.Colors, "comp.bmp")

  Ball.Radius = 10
  Ball.Speed = 250
  Ball.X = (Box.X1 + Box.X2 - Ball.Radius) / 2
  Ball.Y = (Box.Y1 + Box.Y2 - Ball.Radius) / 2
  Ball.Angle = 270 + RND * 45
  IF Ball.Angle < 20 THEN Ball.Angle = 20
  Ball.imgDC = uglNew(UGL.EMS, Env.Colors, Ball.Radius * 2 + 1, Ball.Radius * 2 + 1)
  Ball.bgDC = uglNew(UGL.EMS, Env.Colors, Ball.Radius * 2 + 1, Ball.Radius * 2 + 1)
  uglClear Ball.bgDC, 0
  uglClear Ball.imgDC, uglColor(Env.Colors, 255, 0, 255)
  uglCircleF Ball.imgDC, Ball.Radius, Ball.Radius, Ball.Radius, uglColor(Env.Colors, 200, 0, 0)

  uglWrite 270, 0, "UGL PONG", 20
END SUB

SUB uglWrite (X, Y, text$, size)
  fontSetSize size
  fontSetAlign FONT.HALIGN.LEFT, FONT.VALIGN.TOP
  fontSetBGMode FONT.BG.TRANSPARENT
  fontSetExtraSpc 1
  fontSetAngle 0
  fontSetUnderline FONT.FALSE
  fontSetStrikeout FONT.FALSE
  fontSetOutline FONT.FALSE
  fontTextOut Env.VideoDC, X, Y, uglColor(Env.Colors, 255, 255, 255), Env.hFont, text$
END SUB

