'(C) FINGERSOFT 2002
'This demonstrates in a bad way how to utilise 3d mathematics in QBasic
'As qbasic is very slow, 386 could do the same much faster in C/ASM than
'this QB shit on my Athlon 650@780. :)
'Any way, you may study from this if you want. But copy-paste is not allowed!
'
'Written by Toni Fingerroos (I used to wrote QB Code, not any more, as you see)
'
'Thanx to open source Mesa3d lib, got much help on lookat and projection mtrx
'stuff :)




DECLARE SUB DrawLINE (x1!, y1!, x2!, y2!, c%)
'MATRICES: view, projection and transformation matrices
DIM viewMat(4, 4), projMat(4, 4), transMat(4, 4), multiMat(4, 4)
'MATRICES: in mat1 and mat2, (gosub matMultiply) = outMat = mat1*mat2
DIM inMat1(4, 4), inMat2(4, 4), outMat(4, 4)
'DOUBLE VALUES FOR VIEWMAT
CONST MPI = 3.14159265#

DIM water(100, 3) 'Water we're going to draw

FOR i% = 0 TO 100
  water(i%, 0) = -6 + RND * 12
  water(i%, 1) = 61 + RND * 30
  water(i%, 2) = -6 + RND * 12
NEXT i%



'YOU MAY USE THESE IF SCREEN 9 IS TOO SLOW
CONST SCRX = 320
CONST SCRY = 200
SCREEN 7

'THIS IS BETTER LOOKING BUT MUCH SLOWER
'CONST SCRX = 640
'CONST SCRY = 350
'SCREEN 9

'We init our projection matrix only once
fov = 90 '45 degree field of view
aspect = 1.33 'Screen aspect ratio
zNear = 1 'Near plane
zFar = 1000 'Far plane
GOSUB constructProjectionMatrix

'To the program itseft
startTime = TIMER
GOTO 10

'Here's all matrix and transformation stuff
transform:
outW = 1 / (outMat(3, 0) * inX + outMat(3, 1) * inY + outMat(3, 2) * inZ + outMat(3, 3))
outX = (outMat(0, 0) * inX + outMat(0, 1) * inY + outMat(0, 2) * inZ + outMat(0, 3)) * outW
outY = (outMat(1, 0) * inX + outMat(1, 1) * inY + outMat(1, 2) * inZ + outMat(1, 3)) * outW
outZ = (outMat(2, 0) * inX + outMat(2, 1) * inY + outMat(2, 2) * inZ + outMat(2, 3)) * outW

outX = ((outX + 1) * .5) * SCRX
outY = SCRY - ((outY + 1) * .5) * SCRY
RETURN

constructProjectionMatrix:
ymax = zNear * TAN(fov * MPI / 360)
ymin = -ymax
xmin = ymin * aspect
xmax = ymax * aspect
left = xmin: right = xmax
bottom = ymin: top = ymax
farval = zFar
nearval = zNear

pmx = (2 * nearval) / (right - left)
pmy = (2 * nearval) / (top - bottom)
pma = (right + left) / (right - left)
pmb = (top + bottom) / (top - bottom)
pmc = -(farval + nearval) / (farval - nearval)
pmd = -(2 * farval * nearval) / (farval - nearval)

projMat(0, 0) = pmx: projMat(0, 1) = 0: projMat(0, 2) = pma: projMat(0, 3) = 0
projMat(1, 0) = 0: projMat(1, 1) = pmy: projMat(1, 2) = pmb: projMat(1, 3) = 0
projMat(2, 0) = 0: projMat(2, 1) = 0: projMat(2, 2) = pmc: projMat(2, 3) = pmd
projMat(3, 0) = 0: projMat(3, 1) = 0: projMat(3, 2) = -1: projMat(3, 3) = 0
RETURN

constructViewMatrix:
z0 = eyeX - toX
z1 = eyeY - toY
z2 = eyeZ - toZ

mag = SQR(z0 * z0 + z1 * z1 + z2 * z2)
IF (mag > 0) THEN
  z0 = z0 / mag
  z1 = z1 / mag
  z2 = z2 / mag
END IF

y0 = upX: y1 = upY: y2 = upZ

x0 = y1 * z2 - y2 * z1
x1 = -y0 * z2 + y2 * z0
x2 = y0 * z1 - y1 * z0

y0 = z1 * x2 - z2 * x1
y1 = -z0 * x2 + z2 * x0
y2 = z0 * x1 - z1 * x0

mag = SQR(x0 * x0 + x1 * x1 + x2 * x2)
IF mag > 0 THEN
  x0 = x0 / mag
  x1 = x1 / mag
  x2 = x2 / mag
END IF

mag = SQR(y0 * y0 + y1 * y1 + y2 * y2)
IF mag > 0 THEN
  y0 = y0 / mag
  y1 = y1 / mag
  y2 = y2 / mag
END IF


viewMat(0, 0) = x0: viewMat(0, 1) = x1: viewMat(0, 2) = x2: viewMat(0, 3) = 0
viewMat(1, 0) = y0: viewMat(1, 1) = y1: viewMat(1, 2) = y2: viewMat(1, 3) = 0
viewMat(2, 0) = z0: viewMat(2, 1) = z1: viewMat(2, 2) = z2: viewMat(2, 3) = 0
viewMat(3, 0) = 0: viewMat(3, 1) = 0: viewMat(3, 2) = 0: viewMat(3, 3) = 1

transMat(0, 0) = 1: transMat(0, 1) = 0: transMat(0, 2) = 0: transMat(0, 3) = -eyeX
transMat(1, 0) = 0: transMat(1, 1) = 1: transMat(1, 2) = 0: transMat(1, 3) = -eyeY
transMat(2, 0) = 0: transMat(2, 1) = 0: transMat(2, 2) = 1: transMat(2, 3) = -eyeZ
transMat(3, 0) = 0: transMat(3, 1) = 0: transMat(3, 2) = 0: transMat(3, 3) = 1

FOR i% = 0 TO 3: FOR j% = 0 TO 3: inMat1(i%, j%) = viewMat(i%, j%): NEXT j%: NEXT i%
FOR i% = 0 TO 3: FOR j% = 0 TO 3: inMat2(i%, j%) = transMat(i%, j%): NEXT j%: NEXT i%
GOSUB matMultiply

FOR i% = 0 TO 3: FOR j% = 0 TO 3: inMat1(i%, j%) = projMat(i%, j%): NEXT j%: NEXT i%
FOR i% = 0 TO 3: FOR j% = 0 TO 3: inMat2(i%, j%) = outMat(i%, j%): NEXT j%: NEXT i%
GOSUB matMultiply

RETURN


RETURN
  
matMultiply:
FOR mi% = 0 TO 3
  outMat(mi%, 0) = inMat1(mi%, 0) * inMat2(0, 0) + inMat1(mi%, 1) * inMat2(1, 0) + inMat1(mi%, 2) * inMat2(2, 0) + inMat1(mi%, 3) * inMat2(3, 0)
  outMat(mi%, 1) = inMat1(mi%, 0) * inMat2(0, 1) + inMat1(mi%, 1) * inMat2(1, 1) + inMat1(mi%, 2) * inMat2(2, 1) + inMat1(mi%, 3) * inMat2(3, 1)
  outMat(mi%, 2) = inMat1(mi%, 0) * inMat2(0, 2) + inMat1(mi%, 1) * inMat2(1, 2) + inMat1(mi%, 2) * inMat2(2, 2) + inMat1(mi%, 3) * inMat2(3, 2)
  outMat(mi%, 3) = inMat1(mi%, 0) * inMat2(0, 3) + inMat1(mi%, 1) * inMat2(1, 3) + inMat1(mi%, 2) * inMat2(2, 3) + inMat1(mi%, 3) * inMat2(3, 3)
  NEXT mi%
RETURN


'This is so called page flipping, not as much flickering as using pure cls :)
flip:
SCREEN , 0, 0, 1
PCOPY 0, 1
CLS
RETURN



































































makeCamera:
a$ = INKEY$
'These matrix calculation will prepare our 3d transformation to 2d
RETURN

DrawSPHERE:
inX = sX: inY = sY: inZ = sZ
GOSUB transform
spX = outX: spY = outY

inX = sX + viewMat(1, 0) * sR: inY = sY + viewMat(1, 1) * sR: inZ = sZ + viewMat(1, 2) * sR
GOSUB transform
spR = ABS(spY - outY)
CIRCLE (spX, spY), spR, sC%
GOSUB transform

RETURN

DrawDOT:
inX = pX: inY = pY: inZ = pZ
GOSUB transform
PSET (outX, outY), pC%
RETURN




DrawCUBE:
x(0) = cX - (cSx * .5)
y(0) = cY + (cSy * .5)
z(0) = cZ + (cSz * .5)

x(1) = cX + (cSx * .5)
y(1) = cY + (cSy * .5)
z(1) = cZ + (cSz * .5)

x(2) = cX + (cSx * .5)
y(2) = cY + (cSy * .5)
z(2) = cZ - (cSz * .5)

x(3) = cX - (cSx * .5)
y(3) = cY + (cSy * .5)
z(3) = cZ - (cSz * .5)

x(4) = cX - (cSx * .5)
y(4) = cY - (cSy * .5)
z(4) = cZ + (cSz * .5)

x(5) = cX + (cSx * .5)
y(5) = cY - (cSy * .5)
z(5) = cZ + (cSz * .5)

x(6) = cX + (cSx * .5)
y(6) = cY - (cSy * .5)
z(6) = cZ - (cSz * .5)

x(7) = cX - (cSx * .5)
y(7) = cY - (cSy * .5)
z(7) = cZ - (cSz * .5)

FOR ci% = 0 TO 7
  inX = x(ci%): inY = y(ci%): inZ = z(ci%)
  GOSUB transform
  IF outZ > 1! THEN
    RETURN
  END IF
  x(ci%) = outX: y(ci%) = outY
NEXT ci%

'TOP
CALL DrawLINE(x(0), y(0), x(1), y(1), cC%)
CALL DrawLINE(x(1), y(1), x(2), y(2), cC%)
CALL DrawLINE(x(2), y(2), x(3), y(3), cC%)
CALL DrawLINE(x(3), y(3), x(0), y(0), cC%)

'BOTTOM
CALL DrawLINE(x(4), y(4), x(5), y(5), cC%)
CALL DrawLINE(x(5), y(5), x(6), y(6), cC%)
CALL DrawLINE(x(6), y(6), x(7), y(7), cC%)
CALL DrawLINE(x(7), y(7), x(4), y(4), cC%)

'SIDES
CALL DrawLINE(x(0), y(0), x(4), y(4), cC%)
CALL DrawLINE(x(1), y(1), x(5), y(5), cC%)
CALL DrawLINE(x(2), y(2), x(6), y(6), cC%)
CALL DrawLINE(x(3), y(3), x(7), y(7), cC%)
RETURN



10
oldTime = TIMER + 1
fps = fpsCount
fpsCount = 0

mainLoop:
runTime = TIMER - startTime
fpsCount = fpsCount + 1

nTime = TIMER
fTime = nTime - oTime
oTime = nTime

GOSUB makeCamera

'Clear frame buffer

'LOCATE 1, 1: PRINT "FPS:"; fps; " EANGLE:"; eay

IF state% = 0 THEN GOSUB state1
IF state% = 1 THEN GOSUB state2
IF state% = 2 THEN GOSUB state3
IF state% = 3 THEN GOSUB state4


GOSUB flip

IF oldTime < TIMER THEN GOTO 10


GOTO mainLoop

END

state1:
eay = eay + .045
tay = eay + 1

IF eay > 8.5 THEN fAway = fAway + .02
IF fAway > .6 THEN state% = 1
toX = SIN(tay) * 4
toY = -COS(tay * 2) * 4 + SIN(fAway) * 60
toZ = COS(tay) * 4

eyeX = SIN(eay) * 8
eyeY = -COS(eay * 2) * 8 + SIN(fAway) * 60
eyeZ = COS(eay) * 8

upY = 1
upZ = .7
GOSUB constructViewMatrix

cSx = 6
cSy = 6
cSz = 6
c% = 1

FOR i = -1 TO 1
  FOR j = -1 TO 1
    FOR k = -1 TO 1
      c% = c% + 1
      IF c% > 14 THEN c% = 1
      cX = i * 20
      cY = j * 20
      cZ = k * 20
      cC% = c%
      GOSUB DrawCUBE
    NEXT k
  NEXT j
NEXT i

RETURN


state2:
eay = eay + .045
tay = eay + 1

IF fAway < 1.57 AND eay < 13 THEN fAway = fAway + .02
toX = 0
toY = SIN(fAway) * 60
toZ = 0

IF eay > 25 THEN fAway = fAway - .02
IF fAway < .6 THEN state% = 2

eyeX = SIN(tay) * 20
eyeY = 10 + SIN(fAway) * 60
eyeZ = COS(tay) * 20

upY = 1
upZ = 0
GOSUB constructViewMatrix

cSx = 15
cSy = 1
cSz = 15
cY = 60
cX = 0
cZ = 0
c% = 2
GOSUB DrawCUBE

cSx = 1
cSy = 8
cSz = 1
c% = 3

cX = 7.5
cZ = 7.5
GOSUB DrawCUBE
cX = 7.5
cZ = -7.5
GOSUB DrawCUBE
cX = -7.5
cZ = -7.5
GOSUB DrawCUBE
cX = -7.5
cZ = 7.5
GOSUB DrawCUBE

pC% = 1
FOR i% = 0 TO 100
  pC% = pC% + 8
  IF (pC% > 10) THEN pC% = 1
  pX = water(i%, 0)
  pY = water(i%, 1)
  pZ = water(i%, 2)

  water(i%, 1) = water(i%, 1) - .45
  IF water(i%, 1) < 61 THEN water(i%, 1) = 91

  GOSUB DrawDOT
NEXT i%

RETURN

state3:
eay = eay + .045
tay = eay + 1

toX = 0
toY = SIN(fAway) * 60
toZ = 0

IF fAway > 0 AND eay < 40 THEN fAway = fAway - .02

IF eay > 45 THEN fAway = fAway + .2
IF fAway > .6 THEN state% = 3

eyeX = SIN(tay) * 20
eyeY = 10 + SIN(tay) * 10 + SIN(fAway) * 60
eyeZ = COS(tay) * 20

upY = 1
upZ = 0

GOSUB constructViewMatrix

FOR i = -7 TO 7
  cSx = SIN(i / 5 + eay * 2) * 8
  cSy = 1
  cSz = COS(i / 5 + eay * 2) * 8
  cC% = 8 + i

  cX = 0
  cY = i
  cZ = 0
  GOSUB DrawCUBE
NEXT i
  
RETURN

state4:
eay = eay + .045
tay = eay + 1

IF fAway < 1.57 AND eay < 55 THEN fAway = fAway + .02
toX = 0
toY = SIN(fAway) * 60
toZ = 0

IF eay > 60 THEN fAway = fAway - .02
IF fAway < .6 THEN
  LINE (0, 0)-(SCRX, SCRY), 15, BF
  state% = 0
  fAway = 0
  eay = 0
  RETURN
END IF

eyeX = SIN(tay) * 20
eyeY = 10 + SIN(fAway) * 60
eyeZ = COS(tay) * 20

upY = 1
upZ = 0
GOSUB constructViewMatrix
sR = .5

sC% = 1
FOR i = 0 TO 36
  sC% = sC% + 8
  IF sC% > 15 THEN sC% = 1
 
  sX = SIN(i / 36 * MPI * 2 + tay / 2) * 10
  sY = COS(i / 36 * MPI * 2 + tay / 2) * 10 + 60
  sZ = 0
  GOSUB DrawSPHERE
NEXT i

sC% = 4
FOR i = 0 TO 36
  sC% = sC% + 8
  IF sC% > 15 THEN sC% = 4
 
  sX = COS(i / 36 * MPI * 2 + tay / 2) * 10
  sY = 60
  sZ = SIN(i / 36 * MPI * 2 + tay / 2) * 10
  GOSUB DrawSPHERE
NEXT i

sC% = 2
FOR i = 0 TO 36
  sC% = sC% + 8
  IF sC% > 15 THEN sC% = 2
  sX = 0
  sY = SIN(i / 36 * MPI * 2 + tay / 2) * 10 + 60
  sZ = -COS(i / 36 * MPI * 2 + tay / 2) * 10
  GOSUB DrawSPHERE
NEXT i

RETURN

SUB DrawLINE (x1, y1, x2, y2, c%)
bDrawn% = 0

IF x1 > -5000 AND x1 < 5000 AND y1 > -5000 AND y1 < 1000 THEN
  IF x2 > -5000 AND x2 < 5000 AND y2 > -5000 AND y2 < 1000 THEN
    LINE (x1, y1)-(x2, y2), c%
  END IF
END IF


END SUB

