'ball_bounce.bas

'General:
'--------

option explicit

#include "allegro.bi"

'Declarations:
'-------------

'Types

'Ball type
type BALL_TYPE
   x as single
   y as single
   speedx as single
   speedy as single
   radius as single
end type

'Create a ball object
dim ball as BALL_TYPE

'Create an Allegro BITMAP for double buffering
dim dblbuffer as BITMAP ptr

'Check whether game is running
dim end_game as single

'Colours for precalculation
dim white as integer

'Initialisation:
'---------------

'Initialise Allegro routines
allegro_init
install_keyboard

'Set colour depth to 8-bit
set_color_depth 8

'Set graphics mode to 320x240 with error checking
if set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 240, 0, 0) < 0 then
		allegro_message "Unable to set any graphic mode" + chr(13) + allegro_error + chr(13)
		end 1
end if

'Set window title to "Bouncing ball"
set_window_title "Bouncing ball"

'Create the double buffer surface
dblbuffer = create_bitmap (SCREEN_W, SCREEN_H)

'Check to make sure there was enough memory to create the surface.
if dblbuffer = NULL then
   allegro_exit
   allegro_message "Sorry, not enough memory."
   end 1
end if

'Initialise the variables

'Game is not ended yet
end_game = 0

'Initialise the ball
ball.x = SCREEN_W / 2
ball.y = SCREEN_H / 2
ball.speedx = 5
ball.speedy = 5
ball.radius = 2

'Precalculate colours for speed
white = makecol (255, 255, 255)

'Clear everything off the screen and buffer
clear_bitmap screen
clear_bitmap dblbuffer

'Clear the keyboard buffer
clear_keybuf

'Main Program Flow:
'------------------

'Main game loop while end_game is not set
do
   'Move the ball
   ball.x = ball.x + ball.speedx
   ball.y = ball.y + ball.speedy
   
   'Check for collisions against the sides
   if ball.x - ball.radius <= 0 or ball.x + ball.radius >= SCREEN_W then ball.speedx = - ball.speedx
   'Check for collisions against the top
   if ball.y - ball.radius <= 0 or ball.y + ball.radius >= SCREEN_H then ball.speedy = - ball.speedy
   
   'Draw the ball to the buffer
   circlefill dblbuffer, ball.x, ball.y, ball.radius, white
   
   'Wait for the vertical retrace
   vsync
   
   'Blit the contents of the buffer to the visible screen
   blit dblbuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H
   
   'Clear the previous loop's buffer contents
   clear_bitmap dblbuffer
   
   'Check for the key Escape, then end_game = 1
   if key(KEY_ESC) then end_game = 1
loop until end_game = 1

'Destroy the double bufffer and remove it from memory
destroy_bitmap dblbuffer

'De-initialise allegro
remove_keyboard
allegro_exit

end 0